/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.instabug.bug.OnSdkDismissedCallback;
import com.instabug.bug.PromptOption;
import com.instabug.bug.b.a;
import com.instabug.bug.c;
import com.instabug.bug.invocation.InvocationMode;
import com.instabug.bug.model.ReportCategory;
import com.instabug.bug.settings.AttachmentsTypesParams;
import com.instabug.bug.settings.a;
import com.instabug.bug.settings.b;
import com.instabug.chat.InstabugChat;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.bugreporting.model.Bug;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.model.BugCategory;
import com.instabug.library.settings.SettingsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BugReporting {
    public static void setInvocationEvents(InstabugInvocationEvent ... invocationEvents) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)TextUtils.join((CharSequence)",", (Object[])invocationEvents))});
        InvocationManager.getInstance().setInstabugInvocationEvent(invocationEvents);
    }

    public static void invoke() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().invoke();
    }

    public static void invoke(@NonNull InvocationMode invocationMode, int ... invocationOptions) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("invocationMode").setType(InvocationMode.class).setValue((Object)invocationMode.toString()), new Api.Parameter().setName("invocationOption").setValue(String.class).setValue((Object)Arrays.toString(invocationOptions))});
        BugReporting.setInvocationOptions(invocationOptions);
        switch (invocationMode) {
            case NEW_BUG: {
                InvocationManager.getInstance().invoke(1);
                break;
            }
            case NEW_FEEDBACK: {
                InvocationManager.getInstance().invoke(2);
                break;
            }
            case NEW_CHAT: {
                InvocationManager.getInstance().invoke(3);
                break;
            }
            case CHATS_LIST: {
                InvocationManager.getInstance().invoke(4);
                break;
            }
            default: {
                InvocationManager.getInstance().invoke(0);
            }
        }
    }

    public static void setInvocationOptions(int ... invocationOptions) {
        APIBuildChecker.check();
        block6: for (int n : invocationOptions) {
            switch (n) {
                case 8: {
                    a.a().c(true);
                    continue block6;
                }
                case 2: {
                    a.a().b(false);
                    a.a().a(false);
                    continue block6;
                }
                case 4: {
                    a.a().b(true);
                    a.a().a(false);
                    continue block6;
                }
                case 16: {
                    a.a().d(false);
                    continue block6;
                }
            }
        }
    }

    public static void setOnInvokeCallback(OnInvokeCallback onInvokeCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("setOnInvokeCallback").setType(Runnable.class)});
        SettingsManager.getInstance().setOnInvokeCallback(onInvokeCallback);
    }

    public static void setOnDismissCallback(OnSdkDismissCallback onSdkDismissedCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("onSdkDismissedCallback").setType(com.instabug.library.OnSdkDismissedCallback.class)});
        InstabugChat.setOnSdkDismissCallback((OnSdkDismissCallback)onSdkDismissedCallback);
        a.a().a(onSdkDismissedCallback);
    }

    public static void setPromptOptionsEnabled(PromptOption ... promptOptions) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("promptOptions").setType(PromptOption.class).setValue(Arrays.asList(promptOptions))});
        c.a(promptOptions);
    }

    public static void setShakingThreshold(int threshold) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue((Object)Integer.toString(threshold))});
        InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(threshold);
    }

    public static void setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugFloatingButtonEdge").setType(InstabugFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge)});
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
    }

    public static void setFloatingButtonOffset(@IntRange(from=0L) int floatingButtonOffsetFromTop) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue((Object)Integer.toString(floatingButtonOffsetFromTop))});
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(floatingButtonOffsetFromTop);
    }

    public static void setVideoRecordingFloatingButtonPosition(@NonNull InstabugVideoRecordingButtonPosition instabugViewRecordingButtonPosition) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugViewRecordingButtonPosition").setType(InstabugVideoRecordingButtonPosition.class).setValue((Object)instabugViewRecordingButtonPosition)});
        InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(instabugViewRecordingButtonPosition);
    }

    public static void setExtendedBugReportState(ExtendedBugReport.State state) {
        a.a a2;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        switch (state) {
            case ENABLED_WITH_REQUIRED_FIELDS: {
                a2 = a.a.ENABLED_WITH_REQUIRED_FIELDS;
                break;
            }
            case ENABLED_WITH_OPTIONAL_FIELDS: {
                a2 = a.a.ENABLED_WITH_OPTIONAL_FIELDS;
                break;
            }
            default: {
                a2 = a.a.DISABLED;
            }
        }
        a.a().a(a2);
    }

    private static void setLegacyReportCategories(List<com.instabug.library.bugreporting.model.ReportCategory> legacyReportCategories) {
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        for (com.instabug.library.bugreporting.model.ReportCategory reportCategory : legacyReportCategories) {
            ReportCategory reportCategory2 = ReportCategory.getInstance().withIcon(reportCategory.getIcon()).withLabel(reportCategory.getLabel());
            arrayList.add(reportCategory2);
        }
        BugReporting.setReportCategories(arrayList);
    }

    @Deprecated
    public static void setReportCategories(List<ReportCategory> reportCategories) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("reportCategories").setType(ReportCategory.class)});
        a.a().a(reportCategories);
    }

    private static void setLegacyBugCategories(List<BugCategory> legacyBugCategories) {
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        for (BugCategory bugCategory : legacyBugCategories) {
            ReportCategory reportCategory = ReportCategory.getInstance().withIcon(bugCategory.getIcon()).withLabel(bugCategory.getLabel());
            arrayList.add(reportCategory);
        }
        BugReporting.setReportCategories(arrayList);
    }

    private static void setLegacyOnSdkDismissedCallback(final com.instabug.library.OnSdkDismissedCallback onSdkDismissedCallback) throws IllegalStateException {
        OnSdkDismissedCallback onSdkDismissedCallback2 = new OnSdkDismissedCallback(){

            @Override
            public void onSdkDismissed(OnSdkDismissedCallback.DismissType issueState, com.instabug.bug.model.c reportType) {
                OnSdkDismissedCallback.DismissType dismissType;
                Bug.Type type;
                switch (reportType) {
                    case BUG: {
                        type = Bug.Type.BUG;
                        break;
                    }
                    case FEEDBACK: {
                        type = Bug.Type.FEEDBACK;
                        break;
                    }
                    case NOT_AVAILABLE: {
                        type = Bug.Type.NOT_AVAILABLE;
                        break;
                    }
                    default: {
                        type = Bug.Type.NOT_AVAILABLE;
                    }
                }
                switch (issueState) {
                    case SUBMIT: {
                        dismissType = OnSdkDismissedCallback.DismissType.SUBMIT;
                        break;
                    }
                    case CANCEL: {
                        dismissType = OnSdkDismissedCallback.DismissType.CANCEL;
                        break;
                    }
                    case ADD_ATTACHMENT: {
                        dismissType = OnSdkDismissedCallback.DismissType.ADD_ATTACHMENT;
                        break;
                    }
                    default: {
                        dismissType = OnSdkDismissedCallback.DismissType.CANCEL;
                    }
                }
                onSdkDismissedCallback.onSdkDismissed(dismissType, type);
            }
        };
        BugReporting.setOnSdkDismissedCallback(onSdkDismissedCallback2);
    }

    @Deprecated
    public static void setOnSdkDismissedCallback(OnSdkDismissedCallback onSdkDismissedCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("onSdkDismissedCallback").setType(OnSdkDismissedCallback.class)});
        a.a().a(onSdkDismissedCallback);
    }

    public static void setAttachmentTypesEnabled(boolean initialScreenshot, boolean extraScreenshot, boolean imageFromGallery, boolean screenRecording) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("initialScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(initialScreenshot)), new Api.Parameter().setName("extraScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(extraScreenshot)), new Api.Parameter().setName("galleryImage").setType(Boolean.class).setValue((Object)Boolean.toString(imageFromGallery)), new Api.Parameter().setName("screenRecording").setType(Boolean.class).setValue((Object)Boolean.toString(screenRecording))});
        AttachmentsTypesParams attachmentsTypesParams = new AttachmentsTypesParams(initialScreenshot, extraScreenshot, imageFromGallery, screenRecording);
        a.a().a(attachmentsTypesParams);
    }

    @RequiresApi(value=21)
    private static void setScreenshotByMediaProjectionEnabled(boolean enabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().setScreenshotByMediaProjectionEnabled(enabled);
    }

    @Deprecated
    public static Runnable getPreSendingRunnable() {
        return b.b().h();
    }

    @Deprecated
    public static void setPreSendingRunnable(Runnable runnable) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("runnable").setType(Runnable.class)});
        a.a().a(runnable);
    }

    @Deprecated
    public static void setShouldSkipInitialScreenshotAnnotation(boolean willSkipInitialScreenshotAnnotating) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
    }

    @Deprecated
    public static void setEmailFieldRequired(boolean isRequired) {
        APIBuildChecker.check();
        a.a().a(isRequired);
    }

    @Deprecated
    public static void setEmailFieldVisibility(boolean emailFieldVisibility) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("emailFieldVisibility").setType(Boolean.class).setValue((Object)Boolean.toString(emailFieldVisibility))});
        a.a().b(emailFieldVisibility);
    }

    @Deprecated
    public static void setCommentFieldRequired(boolean commentFieldRequired) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("commentFieldRequired").setType(Boolean.class).setValue((Object)Boolean.toString(commentFieldRequired))});
        a.a().c(commentFieldRequired);
    }

    @Deprecated
    public static void setSuccessDialogEnabled(boolean enabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("enabled").setType(Boolean.class).setValue((Object)Boolean.toString(enabled))});
        a.a().d(enabled);
    }

    @Deprecated
    public static void openNewFeedback() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        com.instabug.bug.a.d();
    }

    @Deprecated
    public static void openNewBugReport() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        com.instabug.bug.a.e();
    }

    @Deprecated
    public static void addExtraReportField(CharSequence fieldHint, boolean required) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("fieldHint").setType(CharSequence.class).setValue((Object)fieldHint), new Api.Parameter().setName("required").setType(Boolean.TYPE).setValue((Object)required)});
        a.a().a(fieldHint, required);
    }

    @Deprecated
    public static void clearExtraReportFields() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        a.a().n();
    }

    protected static void setScreenshotRequired(boolean screenshotRequired) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("screenshotRequired").setType(Boolean.TYPE)});
        a.a().e(screenshotRequired);
    }
}

