/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.screenshot.viewhierarchy.utilities;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.bug.screenshot.viewhierarchy.b;
import com.instabug.bug.screenshot.viewhierarchy.c;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ViewHierarchyDiskUtils {
    public static void saveViewHierarchyImage(b b2) {
        File file = new File(ViewHierarchyDiskUtils.getViewHierarchyImagesDirectory(b2.o().getContext()).getAbsolutePath() + File.separator + b2.a() + ".png");
        try {
            if (b2.j() != null) {
                DiskUtils.saveBitmapOnDisk((Bitmap)b2.j(), (File)file);
                b2.a(Uri.fromFile((File)file));
            } else {
                InstabugSDKLogger.d(ViewHierarchyDiskUtils.class, (String)("trying to save a null value bitmap, time in MS: " + System.currentTimeMillis()));
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(ViewHierarchyDiskUtils.class, (String)("save viewHierarchy image got error: " + iOException.getMessage() + ", time in MS: " + System.currentTimeMillis()), (Throwable)iOException);
        }
    }

    @Nullable
    public static synchronized Uri zipViewHierarchyImages(b b2) {
        InstabugSDKLogger.v(ViewHierarchyDiskUtils.class, (String)("zip viewHierarchy images just started, time in MS: " + System.currentTimeMillis()));
        try {
            File file = new File(DiskUtils.getInstabugDirectory((Context)b2.o().getContext()) + File.separator + "view_hierarchy_attachment_" + System.currentTimeMillis() + ".zip");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (b b3 : c.b(b2)) {
                if (b3.l() == null) continue;
                File file2 = new File(b3.l().getPath());
                zipOutputStream.putNextEntry(new ZipEntry(b3.a() + ".png"));
                ViewHierarchyDiskUtils.copy(file2, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
                if (!file2.delete()) continue;
                InstabugSDKLogger.v(ViewHierarchyDiskUtils.class, (String)("file zipped successfully, path: " + file2.getPath() + ", time in MS: " + System.currentTimeMillis()));
            }
            if (file.length() != 0L) {
                zipOutputStream.close();
            }
            InstabugSDKLogger.v(ViewHierarchyDiskUtils.class, (String)("zip viewHierarchy images done successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis()));
            return Uri.fromFile((File)file);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(ViewHierarchyDiskUtils.class, (String)("zip viewHierarchy images got error: " + iOException.getMessage() + ", time in MS: " + System.currentTimeMillis()), (Throwable)iOException);
            return null;
        }
    }

    private static void copy(File file, OutputStream outputStream) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ViewHierarchyDiskUtils.copy(fileInputStream, outputStream);
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static File getViewHierarchyImagesDirectory(Context context) {
        String string2 = DiskUtils.getInstabugDirectory((Context)context) + "/view-hierarchy-images/";
        File file = new File(string2);
        if (!file.exists() && file.mkdir()) {
            InstabugSDKLogger.i(ViewHierarchyDiskUtils.class, (String)("temp directory created successfully: " + file.getPath() + ", time in MS: " + System.currentTimeMillis()));
        }
        return file;
    }
}

