/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.network;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.instabug.bug.cache.BugsCacheManager;
import com.instabug.bug.model.Bug;
import com.instabug.bug.settings.a;
import com.instabug.bug.settings.c;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;
import rx.Subscriber;

public final class b {
    private static b a;
    private NetworkManager b = new NetworkManager();

    public static b a() {
        if (a == null) {
            a = new b();
        }
        return a;
    }

    private b() {
    }

    public final void a(Context context, Bug bug, Request.Callbacks<String, Throwable> callbacks) throws JSONException, IOException {
        InstabugSDKLogger.d((Object)this, (String)("Reporting a bug with message: " + bug.d()));
        Request request = this.b.buildRequest(context, Request.Endpoint.ReportBug, Request.RequestMethod.Post);
        ArrayList arrayList = bug.getState().getStateItems();
        for (int j = 0; j < arrayList.size(); ++j) {
            InstabugSDKLogger.d((Object)this, (String)("Bug State Key: " + ((State.StateItem)arrayList.get(j)).getKey() + ", Bug State value: " + ((State.StateItem)arrayList.get(j)).getValue()));
            request.addRequestBodyParameter(((State.StateItem)bug.getState().getStateItems().get(j)).getKey(), ((State.StateItem)bug.getState().getStateItems().get(j)).getValue());
        }
        request.addRequestBodyParameter("title", (Object)bug.d());
        request.addRequestBodyParameter("attachments_count", (Object)bug.e().size());
        request.addRequestBodyParameter("categories", (Object)bug.m());
        this.b.doRequest(request).subscribe((Subscriber)new Subscriber<RequestResponse>(this, callbacks, context){
            private /* synthetic */ Request.Callbacks a;
            private /* synthetic */ Context b;
            {
                this.a = callbacks;
                this.b = context;
            }

            public final void onStart() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"reportingBugRequest started");
            }

            public final void onCompleted() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"reportingBugRequest completed");
            }

            public final void onError(Throwable throwable) {
                InstabugSDKLogger.e((Object)((Object)this), (String)("reportingBugRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                this.a.onFailed((Object)throwable);
            }

            public final /* synthetic */ void onNext(Object object) {
                RequestResponse requestResponse = (RequestResponse)object;
                object = this;
                InstabugSDKLogger.v((Object)object, (String)("reportingBugRequest onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                try {
                    object.a.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e((Object)object, (String)("reportingBugRequest onNext got error: " + jSONException.getMessage()), (Throwable)jSONException);
                }
                if (requestResponse.getResponseCode() == 200) {
                    Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
                    InstabugSDKLogger.d((Object)object, (String)("Updating last_contacted_at to " + calendar.getTime()));
                    com.instabug.bug.settings.a.a();
                    long l = calendar.getTime().getTime();
                    c.a().a(l);
                    InstabugCore.setLastContactedAt((long)calendar.getTime().getTime());
                    requestResponse = new Intent();
                    requestResponse.setAction("User last contact at changed");
                    requestResponse.putExtra("last_contacted_at", calendar.getTime().getTime());
                    LocalBroadcastManager.getInstance((Context)object.b).sendBroadcast((Intent)requestResponse);
                }
            }
        });
    }

    public final void b(Context context, Bug bug, Request.Callbacks<Boolean, Bug> callbacks) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.d((Object)this, (String)"Uploading Bug attachments");
        Observable[] observableArray = new Observable[bug.e().size()];
        for (int j = 0; j < observableArray.length; ++j) {
            Attachment attachment = bug.e().get(j);
            Request request = this.b.buildRequest(context, Request.Endpoint.AddBugAttachment, Request.RequestMethod.Post, NetworkManager.RequestType.MULTI_PART);
            request.setEndpoint(request.getEndpoint().replaceAll(":bug_token", bug.a()));
            request.addParameter("metadata[file_type]", (Object)attachment.getType());
            if (attachment.getType() == Attachment.Type.AUDIO) {
                request.addParameter("metadata[duration]", (Object)attachment.getDuration());
            }
            request.setFileToUpload(new Request.FileToUpload("file", attachment.getName(), attachment.getLocalPath(), attachment.getFileType()));
            observableArray[j] = this.b.doRequest(request);
        }
        Observable.merge((Observable[])observableArray, (int)1).subscribe((Subscriber)new Subscriber<RequestResponse>(this, bug, callbacks){
            private /* synthetic */ Bug a;
            private /* synthetic */ Request.Callbacks b;
            {
                this.a = bug;
                this.b = callbacks;
            }

            public final void onStart() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingBugAttachmentRequest started");
            }

            public final void onCompleted() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingBugAttachmentRequest completed");
                if (this.a.e().size() == 0) {
                    this.b.onSucceeded((Object)true);
                }
            }

            public final void onError(Throwable throwable) {
                InstabugSDKLogger.e((Object)((Object)this), (String)("uploadingBugAttachmentRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                this.b.onFailed((Object)this.a);
            }

            public final /* synthetic */ void onNext(Object object) {
                Object object2 = (RequestResponse)object;
                object = this;
                InstabugSDKLogger.d((Object)object, (String)("uploadingBugAttachmentRequest onNext, Response code: " + object2.getResponseCode() + ", Response body: " + object2.getResponseBody()));
                object2 = new File(object.a.e().get(0).getLocalPath());
                boolean bl = object2.delete();
                if (bl) {
                    InstabugSDKLogger.d((Object)object, (String)"uploadingBugAttachmentRequest onNext, attachment file deleted successfully");
                }
                object.a.e().remove(0);
                BugsCacheManager.addBug(object.a);
                BugsCacheManager.saveCacheToDisk();
            }
        });
    }

    public final void c(Context context, Bug bug, Request.Callbacks<Boolean, Bug> callbacks) {
        try {
            context = this.b.buildRequest(context, Request.Endpoint.bugLogs, Request.RequestMethod.Post);
            context.setEndpoint(context.getEndpoint().replaceAll(":bug_token", bug.a()));
            Object object = bug.getState().getLogsItems();
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                State.StateItem stateItem = (State.StateItem)object.next();
                context.addRequestBodyParameter(stateItem.getKey(), stateItem.getValue());
            }
            if (bug.g() != null) {
                context.addRequestBodyParameter("view_hierarchy", (Object)bug.g());
            }
            this.b.doRequest((Request)context).subscribe((Subscriber)new Subscriber<RequestResponse>(this, callbacks, bug){
                private /* synthetic */ Request.Callbacks a;
                private /* synthetic */ Bug b;
                {
                    this.a = callbacks;
                    this.b = bug;
                }

                public final void onStart() {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploading bug logs started");
                }

                public final void onCompleted() {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploading bug logs completed");
                    this.a.onSucceeded((Object)true);
                }

                public final void onError(Throwable throwable) {
                    InstabugSDKLogger.d((Object)((Object)this), (String)("uploading bug logs got error: " + throwable.getMessage()));
                    this.a.onFailed((Object)this.b);
                }

                public final /* synthetic */ void onNext(Object object) {
                    RequestResponse requestResponse = (RequestResponse)object;
                    object = this;
                    InstabugSDKLogger.v((Object)object, (String)("uploading bug logs onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                }
            });
            return;
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.d((Object)this, (String)("uploading bug logs got Json error: " + jSONException.getMessage()));
            callbacks.onFailed((Object)bug);
            return;
        }
    }
}

