package com.instabug.bug.utils;

import androidx.annotation.StyleRes;

import com.instabug.bug.R;
import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;

/**
 * Created by mzelzoghbi on 4/10/18.
 */
public class BugReportingThemeResolver {
    @StyleRes
    public static int resolveTheme(InstabugColorTheme instabugTheme) {
        if (!InstabugCore.isFeatureEnabled(IBGFeature.CUSTOM_FONT)) {
            if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
                return R.style.InstabugBugReportingLight;
            } else {
                return R.style.InstabugBugReportingDark;
            }
        } else {
            return getCustomFontTheme(instabugTheme);
        }
    }

    @StyleRes
    private static int getCustomFontTheme(InstabugColorTheme instabugTheme) {
        if (instabugTheme == InstabugColorTheme.InstabugColorThemeLight) {
            return R.style.InstabugBugReportingLight_CustomFont;
        } else {
            return R.style.InstabugBugReportingDark_CustomFont;
        }
    }

}
