package com.instabug.bug.proactivereporting.ui

import androidx.appcompat.app.AppCompatActivity
import com.instabug.library.core.ui.BaseContract
import com.instabug.library.frustratingexperience.FrustratingExperienceType

interface ProactiveReportingDialogActivityContract {

    interface View : BaseContract.View<AppCompatActivity> {

        fun navigateToBugReportingActivity()
    }

    interface Presenter : BaseContract.Presenter {
        fun getTitleResId(type: @FrustratingExperienceType String?): Int?

        fun onDialogShown()

        fun onNegativeButtonClicked()

        fun onPositiveButtonClicked(type: @FrustratingExperienceType String?, id: Long?)


    }


}