package com.instabug.bug.invocation.invocationdialog;

import android.annotation.SuppressLint;

import com.instabug.library.core.plugin.PluginPromptOption;

import java.io.Serializable;
import java.util.ArrayList;

import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;

/**
 * Created by mzelzoghbi on 4/18/18.
 */
public class InstabugDialogItem implements Serializable {

    @Nullable
    private String title;
    @Nullable
    private String description;
    private int badgeCount;
    @DrawableRes
    private int resDrawable;
    private boolean isInitialScreenshotRequired;
    @Nullable
    private InstabugDialogItem parent;
    @Nullable
    private ArrayList<InstabugDialogItem> subItems;
    private int order;
    private int identifier;

    public InstabugDialogItem() {
    }

    public InstabugDialogItem(@Nullable String title, int badgeCount, int resDrawable, boolean isInitialScreenshotRequired) {
        this.title = title;
        this.badgeCount = badgeCount;
        this.resDrawable = resDrawable;
        this.isInitialScreenshotRequired = isInitialScreenshotRequired;
    }

    @Nullable
    public String getTitle() {
        return title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public int getBadgeCount() {
        return badgeCount;
    }

    public void setBadge(int badge) {
        this.badgeCount = badge;
    }

    public int getResDrawable() {
        return resDrawable;
    }

    public void setResDrawable(int resDrawable) {
        this.resDrawable = resDrawable;
    }

    public boolean isInitialScreenshotRequired() {
        return isInitialScreenshotRequired;
    }

    public void setInitialScreenshotRequired(boolean initialScreenshotRequired) {
        isInitialScreenshotRequired = initialScreenshotRequired;
    }

    @Nullable
    public ArrayList<InstabugDialogItem> getSubItems() {
        return subItems;
    }

    public void setSubItems(@Nullable ArrayList<InstabugDialogItem> subItems) {
        this.subItems = subItems;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Nullable
    public InstabugDialogItem getParent() {
        return parent;
    }

    public void setParent(@Nullable InstabugDialogItem parent) {
        if (parent != null) {
            this.parent = parent;
        }
    }

    public void setIdentifier(@PluginPromptOption.PromptOptionIdentifier int identifier) {
        this.identifier = identifier;
    }

    @PluginPromptOption.PromptOptionIdentifier
    public int getIdentifier() {
        return identifier;
    }

    @Override
    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION")
    public boolean equals(Object obj) {
        if (obj instanceof InstabugDialogItem) {
            InstabugDialogItem item = (InstabugDialogItem) obj;
            return this.identifier == item.identifier;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = 13;
        result = 31 * result + badgeCount;
        result = 31 * result + resDrawable;
        result = 31 * result + (isInitialScreenshotRequired? 1:0);
        result = 31 * result + order;
        result = 31 * result + identifier;
        if (title != null) {
            result = 31 * result + title.hashCode();
        }
        if (description != null) {
            result = 31 * result + description.hashCode();
        }
        return result;
    }
}
