package com.instabug.bug;

import androidx.annotation.Nullable;

import com.instabug.library.core.eventbus.EventBus;
import com.instabug.library.model.State;

/**
 * A Class used for posting EVENTs related to State.object creation.
 *
 * The State{@link State} object is a main and important object of The Report, it contains most of the
 * device information and many logs. It takes time to get collected so it should be made Off the UI Thread.
 */
public class StateCreatorEventBus extends EventBus<State.Action> {

    @Nullable
    private static StateCreatorEventBus instance;

    public static StateCreatorEventBus getInstance() {
        if (instance == null) {
            instance = new StateCreatorEventBus();
        }
        return instance;
    }

    /**
     * Release this instance when no need to keep it in memory for optmization
     */
    public static void release() {
        instance = null;
    }
}