/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.chats;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.bug.R;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.Message;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.ui.custom.CircularImageView;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.util.threading.PoolProvider;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

class ChatsAdapter
extends BaseAdapter {
    private List<Chat> chats;
    @Nullable
    private final IBGTheme ibgTheme;

    ChatsAdapter(List<Chat> list, @Nullable IBGTheme iBGTheme) {
        this.chats = list;
        this.ibgTheme = iBGTheme;
    }

    private String getLocalizedString(Context context, @StringRes int n) {
        return LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)context), (int)n, (Context)context);
    }

    private void bind(Context context, final ViewHolder viewHolder, Chat chat) {
        String string2;
        Chat chat2 = chat;
        Collections.sort(chat2.getMessages(), new Message.Comparator());
        Message message = chat2.getLastMessage();
        if (message != null && message.getBody() != null && !TextUtils.isEmpty((CharSequence)message.getBody().trim()) && !message.getBody().equals("null")) {
            if (viewHolder.messageSnippetTextView != null) {
                viewHolder.messageSnippetTextView.setText((CharSequence)message.getBody());
            }
        } else if (message != null && message.getAttachments().size() > 0 && (string2 = message.getAttachments().get(message.getAttachments().size() - 1).getType()) != null && viewHolder.messageSnippetTextView != null) {
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1830389646: {
                    if (!string2.equals("video_gallery")) break;
                    n = 5;
                    break;
                }
                case 1710800780: {
                    if (!string2.equals("extra_video")) break;
                    n = 4;
                    break;
                }
                case 1698911340: {
                    if (!string2.equals("extra_image")) break;
                    n = 3;
                    break;
                }
                case 112202875: {
                    if (!string2.equals("video")) break;
                    n = 2;
                    break;
                }
                case 93166550: {
                    if (!string2.equals("audio")) break;
                    n = 1;
                    break;
                }
                case -831439762: {
                    if (!string2.equals("image_gallery")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    viewHolder.messageSnippetTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.CHATS_TYPE_VIDEO, (String)this.getLocalizedString(context, R.string.instabug_str_video)));
                    break;
                }
                case 1: {
                    viewHolder.messageSnippetTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.CHATS_TYPE_AUDIO, (String)this.getLocalizedString(context, R.string.instabug_str_audio)));
                    break;
                }
                case 0: 
                case 3: {
                    viewHolder.messageSnippetTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.CHATS_TYPE_IMAGE, (String)this.getLocalizedString(context, R.string.instabug_str_image)));
                }
            }
        }
        string2 = chat.getSenderName();
        if (viewHolder.senderTextView != null) {
            if (!(string2 == null || string2.equals("") || string2.equals("null") || message == null || message.isInbound())) {
                viewHolder.senderTextView.setText((CharSequence)string2);
            } else {
                viewHolder.senderTextView.setText((CharSequence)chat.getTitle());
            }
        }
        if (viewHolder.messageTimeTextView != null) {
            viewHolder.messageTimeTextView.setText((CharSequence)InstabugDateFormatter.formatConversationLastMessageDate((Context)context, (long)chat.getLastMessageDate()));
        }
        if (chat.getUnreadCount() != 0) {
            TypedValue typedValue;
            Context context2 = context;
            message = typedValue;
            typedValue = new TypedValue();
            context2.getTheme().resolveAttribute(R.attr.instabug_unread_message_background_color, (TypedValue)message, true);
            message = ContextCompat.getDrawable((Context)context2, (int)R.drawable.ibg_core_bg_white_oval);
            if (message != null) {
                message = Colorizer.getPrimaryColorTintedDrawable((Drawable)message);
                if (viewHolder.unreadMessagesCount != null) {
                    viewHolder.unreadMessagesCount.setBackgroundDrawable((Drawable)message);
                }
            }
            if (viewHolder.unreadMessagesCount != null) {
                viewHolder.unreadMessagesCount.setText((CharSequence)String.valueOf(chat.getUnreadCount()));
                viewHolder.unreadMessagesCount.setVisibility(0);
            }
        } else if (viewHolder.unreadMessagesCount != null) {
            viewHolder.unreadMessagesCount.setVisibility(8);
        }
        if (chat.getSenderAvatarUrl() != null) {
            PoolProvider.postIOTask(() -> {
                if (((Chat)chat).getSenderAvatarUrl() != null) {
                    BitmapUtils.OnBitmapReady onBitmapReady;
                    Context context = context;
                    chat = ((Chat)chat).getSenderAvatarUrl();
                    context = onBitmapReady;
                    onBitmapReady = new BitmapUtils.OnBitmapReady(){

                        public void onBitmapReady(@Nullable Bitmap bitmap) {
                            PoolProvider.postMainThreadTask(() -> {
                                if (viewHolder.senderAvatar != null) {
                                    viewHolder.senderAvatar.setImageBitmap(bitmap);
                                }
                            });
                        }

                        public void onBitmapFailedToLoad() {
                        }
                    };
                    BitmapUtils.loadBitmapForAsset((Context)context, (String)((Object)chat), (AssetEntity.AssetType)AssetEntity.AssetType.IMAGE, (BitmapUtils.OnBitmapReady)context);
                }
            });
        } else if (viewHolder.senderAvatar != null) {
            viewHolder.senderAvatar.setImageResource(R.drawable.ibg_core_ic_avatar);
        }
        this.renderIBGTheme(viewHolder);
    }

    private void renderIBGTheme(ViewHolder viewHolder) {
        ViewHolder viewHolder2 = viewHolder;
        ThemeApplier.applyPrimaryTextStyle((TextView)viewHolder2.senderTextView, (IBGTheme)this.ibgTheme);
        ThemeApplier.applySecondaryTextStyle((TextView)viewHolder2.messageSnippetTextView, (IBGTheme)this.ibgTheme);
        ThemeApplier.applySecondaryTextStyle((TextView)viewHolder2.messageTimeTextView, (IBGTheme)this.ibgTheme);
    }

    public int getCount() {
        return this.chats.size();
    }

    public Chat getItem(int n) {
        return this.chats.get(n);
    }

    public long getItemId(int n) {
        return (this = ((ChatsAdapter)((Object)this)).getItem(n).getId()) != null ? (long)((String)this).hashCode() : (long)n;
    }

    public View getView(final int n, final View view, ViewGroup object) {
        if (object != null) {
            AccessibilityDelegateCompat accessibilityDelegateCompat;
            if (view == null) {
                ViewHolder viewHolder;
                view = LayoutInflater.from((Context)object.getContext()).inflate(R.layout.instabug_conversation_list_item, object, false);
                object = viewHolder;
                view.setTag((Object)new ViewHolder(view));
            } else {
                object = (ViewHolder)view.getTag();
            }
            ChatsAdapter chatsAdapter = this;
            Context context = view.getContext();
            Chat chat = chatsAdapter.getItem(n);
            chatsAdapter.bind(context, (ViewHolder)object, chat);
            object = accessibilityDelegateCompat;
            accessibilityDelegateCompat = new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View view2, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                    1 v0 = object;
                    super.onInitializeAccessibilityNodeInfo(view2, accessibilityNodeInfoCompat);
                    if (v0.ChatsAdapter.this.getItem(object.n).getTitle() != null) {
                        Object object = object.ChatsAdapter.this.getItem(object.n).getTitle();
                        accessibilityNodeInfoCompat.setContentDescription((CharSequence)String.format(object.ChatsAdapter.this.getLocalizedString(R.string.ibg_chat_conversation_with_name_content_description, object.view.getContext()), object));
                    } else {
                        accessibilityNodeInfoCompat.setContentDescription((CharSequence)object.ChatsAdapter.this.getLocalizedString(R.string.ibg_chat_conversation_content_description, object.view.getContext()));
                    }
                }
            };
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)object);
        }
        return view;
    }

    public void setChats(List<Chat> list) {
        this.chats = list;
    }

    public String getLocalizedString(@StringRes int n, Context context) {
        return LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)context), (int)n, (Context)context);
    }

    private static class ViewHolder {
        @Nullable
        private final TextView senderTextView;
        @Nullable
        private final CircularImageView senderAvatar;
        @Nullable
        private final TextView messageTimeTextView;
        @Nullable
        private final TextView messageSnippetTextView;
        @Nullable
        private final TextView unreadMessagesCount;

        ViewHolder(View view) {
            this.senderTextView = (TextView)view.findViewById(R.id.instabug_txt_message_sender);
            this.senderAvatar = (CircularImageView)view.findViewById(R.id.instabug_message_sender_avatar);
            this.messageTimeTextView = (TextView)view.findViewById(R.id.instabug_txt_message_time);
            this.unreadMessagesCount = (TextView)view.findViewById(R.id.instabug_unread_messages_count);
            this.messageSnippetTextView = (TextView)view.findViewById(R.id.instabug_txt_message_snippet);
        }
    }
}

