/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.URLUtil;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.bug.R;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.view.ScaleImageView;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED", "ERADICATE_FIELD_NOT_NULLABLE"})
public class ImageAttachmentViewerFragment
extends Fragment {
    private String imgUrl;
    private ProgressBar mProgressBar;
    private ScaleImageView mImageView;
    private float windowWidth;
    private float windowHeight;

    public static ImageAttachmentViewerFragment newInstance(String string2) {
        Bundle bundle;
        ImageAttachmentViewerFragment imageAttachmentViewerFragment = new ImageAttachmentViewerFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString("img_url", string2);
        imageAttachmentViewerFragment.setArguments(bundle2);
        return imageAttachmentViewerFragment;
    }

    private void showAttachment(@Nullable Bitmap bitmap) {
        if (bitmap != null) {
            this.mImageView.setImageBitmap(bitmap);
        } else {
            bitmap = this.getContext();
            if (bitmap != null) {
                Toast.makeText((Context)bitmap, (int)R.string.instabug_str_image_loading_error, (int)0).show();
            }
        }
        if (this.mProgressBar.getVisibility() == 0) {
            this.mProgressBar.setVisibility(8);
        }
    }

    public void onCreate(@Nullable Bundle bundle) {
        ImageAttachmentViewerFragment imageAttachmentViewerFragment = this;
        super.onCreate(bundle);
        if (imageAttachmentViewerFragment.getArguments() != null) {
            this.imgUrl = this.getArguments().getString("img_url");
            return;
        }
        if (bundle != null) {
            this.imgUrl = bundle.getString("img_url");
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        ImageAttachmentViewerFragment imageAttachmentViewerFragment = this;
        super.onSaveInstanceState(bundle);
        bundle.putString("img_url", imageAttachmentViewerFragment.imgUrl);
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        layoutInflater = layoutInflater.inflate(R.layout.instabug_fragment_image_attachment_viewer, viewGroup, false);
        this.mProgressBar = (ProgressBar)layoutInflater.findViewById(R.id.instabug_attachment_progress_bar);
        this.mImageView = (ScaleImageView)layoutInflater.findViewById(R.id.instabug_img_attachment);
        return layoutInflater;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle bundle) {
        DisplayMetrics displayMetrics;
        ImageAttachmentViewerFragment imageAttachmentViewerFragment = imageAttachmentViewerFragment4;
        super.onViewCreated(view, bundle);
        if (imageAttachmentViewerFragment.getActivity() == null) {
            return;
        }
        ImageAttachmentViewerFragment imageAttachmentViewerFragment2 = imageAttachmentViewerFragment4;
        view = displayMetrics;
        displayMetrics = new DisplayMetrics();
        imageAttachmentViewerFragment2.getActivity().getWindowManager().getDefaultDisplay().getMetrics((DisplayMetrics)view);
        int n = (int)imageAttachmentViewerFragment2.convertDpToPixel(24.0f, (Context)imageAttachmentViewerFragment2.getActivity());
        imageAttachmentViewerFragment2.windowWidth = view.widthPixels - n;
        imageAttachmentViewerFragment2.windowHeight = view.heightPixels - n;
        if (URLUtil.isValidUrl((String)imageAttachmentViewerFragment2.imgUrl)) {
            PoolProvider.postIOTask((Runnable)new Runnable(){

                @Override
                public void run() {
                    BitmapUtils.loadBitmapForAsset((Context)ImageAttachmentViewerFragment.this.getActivity(), (String)ImageAttachmentViewerFragment.this.imgUrl, (AssetEntity.AssetType)AssetEntity.AssetType.IMAGE, (BitmapUtils.OnBitmapReady)new BitmapUtils.OnBitmapReady(){

                        public void onBitmapReady(final @Nullable Bitmap bitmap) {
                            PoolProvider.postMainThreadTask((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (ImageAttachmentViewerFragment.this.mImageView != null) {
                                        ImageAttachmentViewerFragment.this.showAttachment(bitmap);
                                    }
                                }
                            });
                        }

                        public void onBitmapFailedToLoad() {
                        }
                    });
                }
            });
        } else {
            ImageAttachmentViewerFragment imageAttachmentViewerFragment3 = imageAttachmentViewerFragment4;
            ImageAttachmentViewerFragment imageAttachmentViewerFragment4 = imageAttachmentViewerFragment3.mImageView;
            float f = imageAttachmentViewerFragment3.windowWidth;
            float f2 = imageAttachmentViewerFragment3.windowHeight;
            BitmapUtils.loadBitmap((String)imageAttachmentViewerFragment4.imgUrl, (ImageView)imageAttachmentViewerFragment4, (float)f, (float)f2);
        }
    }

    public float convertDpToPixel(float f, Context context) {
        return f * ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mImageView = null;
        this.mProgressBar = null;
    }
}

