/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.instabug.chat.settings.AttachmentTypesState;
import com.instabug.chat.settings.PerSessionSettings;
import com.instabug.chat.settings.PersistableSettings;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

public abstract class ChatSettings {
    public static void init(Context context) {
        PersistableSettings.init(ChatSettings.getChatSharedPreferences(context));
    }

    @Nullable
    public static SharedPreferences getChatSharedPreferences(Context context) {
        return CoreServiceLocator.getInstabugSharedPreferences((Context)context, (String)"instabug_chat");
    }

    @Nullable
    public static Runnable getNewMessageRunnable() {
        return PerSessionSettings.getInstance().getNewMessageRunnable();
    }

    public static void setNewMessageRunnable(Runnable runnable) {
        PerSessionSettings.getInstance().setNewMessageRunnable(runnable);
    }

    public static AttachmentTypesState getAttachmentTypesState() {
        return PerSessionSettings.getInstance().getAttachmentTypesState();
    }

    public static void setAttachmentsTypesParams(AttachmentTypesState attachmentTypesState) {
        PerSessionSettings.getInstance().setAttachmentsTypesParams(attachmentTypesState);
    }

    public static boolean isAttachmentsTypesEnabled() {
        AttachmentTypesState attachmentTypesState = ChatSettings.getAttachmentTypesState();
        return attachmentTypesState.isScreenshotEnabled() || attachmentTypesState.isImageFromGalleryEnabled() || attachmentTypesState.isScreenRecordingEnabled();
    }

    public static boolean shouldSkipImageAttachmentAnnotation() {
        return PerSessionSettings.getInstance().shouldSkipImageAttachmentAnnotation();
    }

    @Nullable
    public static OnSdkDismissCallback getOnSdkDismissCallback() {
        return PerSessionSettings.getInstance().getOnSdkDismissCallback();
    }

    public static void setOnSdkDismissCallback(OnSdkDismissCallback onSdkDismissCallback) {
        PerSessionSettings.getInstance().setOnSdkDismissCallback(onSdkDismissCallback);
    }

    public static void setPushNotificationChannelId(String string2) {
        PerSessionSettings.getInstance().setPushNotificationChannelId(string2);
    }

    @Nullable
    public static String getPushNotificationChannelId() {
        return PerSessionSettings.getInstance().getPushNotificationChannelId();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static long getLastChatTime() {
        return PersistableSettings.getInstance().getLastChatTime();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static void setLastChatTime(long l) {
        PersistableSettings.getInstance().setLastChatTime(l);
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static long getTTL() {
        return PersistableSettings.getInstance().getTTL();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static void setTTL(long l) {
        PersistableSettings.getInstance().setTTL(l);
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static boolean isNotificationEnable() {
        return PersistableSettings.getInstance().isNotificationEnable();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static void enableNotification(boolean bl) {
        PersistableSettings.getInstance().enableNotification(bl);
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static boolean isSystemNotificationSoundEnabled() {
        return PersistableSettings.getInstance().isSystemNotificationSoundEnabled();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static void enableSystemNotificationSound(boolean bl) {
        PersistableSettings.getInstance().enableSystemNotificationSound(bl);
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static boolean isInAppNotificationSoundEnabled() {
        return PersistableSettings.getInstance().isInAppNotificationSoundEnabled();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static void enableInAppNotificationSound(boolean bl) {
        PersistableSettings.getInstance().enableInAppNotificationSound(bl);
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static void enableConversationSound(boolean bl) {
        PersistableSettings.getInstance().enableConversationSound(bl);
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    @DrawableRes
    public static int getNotificationIcon() {
        return PersistableSettings.getInstance().getNotificationIcon();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public static void setNotificationIcon(@DrawableRes int n) {
        PersistableSettings.getInstance().setNotificationIcon(n);
    }

    public static void release() {
        PerSessionSettings.release();
        PersistableSettings.release();
    }
}

