/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.notification;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.instabug.bug.R;
import com.instabug.chat.ChatPlugin;
import com.instabug.chat.RepliesWrapper;
import com.instabug.chat.cache.ReadQueueCacheManager;
import com.instabug.chat.model.Message;
import com.instabug.chat.model.NotificationMessage;
import com.instabug.chat.notification.NotificationBarInvoker;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.chat.synchronization.SynchronizationManager;
import com.instabug.chat.ui.ChatActivityLauncher;
import com.instabug.chat.util.PlaceHolderResolver;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.PresentationManager;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.util.InstabugAppData;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class NotificationManager {
    private static NotificationManager INSTANCE;
    private int type;
    private final NotificationBarInvoker notificationBarInvoker;
    private InstabugAppData appData;
    private List<Message> messages;

    private NotificationManager() {
        NotificationBarInvoker notificationBarInvoker;
        NotificationBarInvoker notificationBarInvoker2 = notificationBarInvoker;
        notificationBarInvoker = new NotificationBarInvoker();
        v1.notificationBarInvoker = notificationBarInvoker2;
    }

    public static synchronized NotificationManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NotificationManager();
        }
        return INSTANCE;
    }

    private void handleAppOnForeground(Context context, List<Message> list, @Nullable Intent intent, @Nullable String string2) {
        Activity activity = context instanceof Activity ? (Activity)context : InstabugCore.getTargetActivity();
        if (InstabugCore.isForegroundNotBusy()) {
            if (activity != null) {
                this.sendInAppNotification(activity, list);
            }
        } else {
            ChatPlugin chatPlugin = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class);
            if (chatPlugin != null && chatPlugin.getState() == 1 && activity != null) {
                this.sendInAppNotification(activity, list);
            } else if (intent != null) {
                this.showSystemNotification(context, intent, string2);
            }
        }
    }

    private boolean isAppOnForeground() {
        return InstabugCore.getStartedActivitiesCount() > 0;
    }

    private int getNotificationType(List<Message> object) {
        int n = 1;
        ArrayList<Message> arrayList = new ArrayList<Message>((Collection<Message>)object);
        object = object.get(0).getChatId();
        Collections.sort(arrayList, new Message.Comparator(1));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = ((Message)iterator.next()).getChatId();
            if (string2 == null || string2.equals(object)) continue;
            ++n;
            object = string2;
        }
        return n == 1 ? 0 : 1;
    }

    @Nullable
    private String generateNotificationBody(@Nullable Context object, int n, List<Message> list) {
        if (n != 0) {
            if (n == 1 && object != null) {
                List<Message> list2 = list;
                Object object2 = list2.get(list2.size() - 1).getSenderName();
                if (object2 != null) {
                    object2 = list.size();
                    object = ((String)object2).split(" ")[0];
                    return String.format(PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.CHATS_MULTIPLE_MESSAGE_NOTIFICATION, (String)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)object), (int)R.string.instabug_str_notifications_body, (Context)object)), object2, object);
                }
            }
            return "";
        }
        List<Message> list3 = list;
        return list3.get(list3.size() - 1).getBody();
    }

    private String generateNotificationTitle(int n, @Nullable String string2) {
        if (string2 != null && !string2.equals("null")) {
            if (n != 0) {
                if (n != 1) {
                    return "";
                }
                return PlaceHolderResolver.getTeamTitleResolved();
            }
            return string2 + " (" + PlaceHolderResolver.getTeamTitleResolved() + ")";
        }
        return PlaceHolderResolver.getTeamTitleResolved();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void showSystemNotification(Context context, Intent intent, @Nullable CharSequence charSequence) {
        int n;
        if (!RepliesWrapper.isMessagingServiceAvailable()) {
            return;
        }
        int n2 = ChatSettings.getNotificationIcon();
        if (n2 == -1 || n2 == 0) {
            n2 = this.appData.getAppIcon();
        }
        String string2 = ChatSettings.getPushNotificationChannelId() != null ? ChatSettings.getPushNotificationChannelId() : "ibg-replies-channel";
        if (!ChatSettings.isSystemNotificationSoundEnabled()) {
            string2 = string2 + "-silent";
        }
        int n3 = (n = Build.VERSION.SDK_INT) >= 23 ? 0xC000000 : 0x8000000;
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)n3);
        intent = RingtoneManager.getDefaultUri((int)2);
        charSequence = new NotificationCompat.Builder(context, string2).setSmallIcon(n2).setContentTitle((CharSequence)this.appData.getAppName()).setContentText(charSequence).setAutoCancel(true).setContentIntent(pendingIntent);
        if (n >= 16) {
            charSequence.setPriority(1);
        }
        if (n >= 21) {
            charSequence.setVibrate(new long[0]);
        }
        if (ChatSettings.isSystemNotificationSoundEnabled()) {
            charSequence.setSound((Uri)intent);
        }
        if ((context = (android.app.NotificationManager)context.getSystemService("notification")) != null) {
            if (n >= 26) {
                context.createNotificationChannel(this.buildNotificationChannel(string2, this.appData.getAppName(), (Uri)intent));
            }
            context.notify(0, charSequence.build());
        }
    }

    @RequiresApi(api=26)
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private NotificationChannel buildNotificationChannel(String string2, String string3, Uri uri) {
        NotificationChannel notificationChannel;
        NotificationManager notificationManager = notificationChannel;
        notificationChannel = new NotificationChannel(string2, (CharSequence)string3, 4);
        if (ChatSettings.isSystemNotificationSoundEnabled()) {
            notificationManager.setSound(uri, null);
        } else {
            notificationManager.setSound(null, null);
        }
        return notificationManager;
    }

    private void sendInAppNotification(Activity object, List<Message> object2) {
        if (InstabugCore.isFeatureEnabled((String)"REPLIES")) {
            NotificationBarInvoker.OnButtonsClickListener onButtonsClickListener;
            WeakReference<Activity> weakReference;
            NotificationManager notificationManager = this;
            List<Message> list = object2;
            object2 = weakReference;
            weakReference = new WeakReference<Activity>((Activity)object);
            object = list.get(list.size() - 1);
            Object object3 = Instabug.getApplicationContext();
            object3 = notificationManager.createNotificationMessage((Context)object3, notificationManager.type, (Message)object);
            Object object4 = object2;
            object2 = onButtonsClickListener;
            onButtonsClickListener = new NotificationBarInvoker.OnButtonsClickListener(){
                final /* synthetic */ Message val$lastMessage;
                {
                    this.val$lastMessage = message;
                }

                @Override
                public void onReply() {
                    if (!InstabugCore.isFeatureEnabled((String)"REPLIES")) {
                        return;
                    }
                    NotificationManager.this.handleInAppNotificationClickEvent();
                    PresentationManager.getInstance().setNotificationShowing(false);
                }

                @Override
                public void onDismiss() {
                    ReadQueueCacheManager.getInstance().markAsRead(this.val$lastMessage);
                    if (SynchronizationManager.getInstance() != null) {
                        SynchronizationManager.getInstance().sync(false);
                    }
                    NotificationManager.this.notifyNotificationDismissed();
                }
            };
            notificationManager.notificationBarInvoker.show((WeakReference<Activity>)object4, (NotificationMessage)object3, (NotificationBarInvoker.OnButtonsClickListener)object2);
            PresentationManager.getInstance().setNotificationShowing(true);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private NotificationMessage createNotificationMessage(@Nullable Context context, int n, Message message) {
        NotificationMessage notificationMessage;
        if (n != 1) {
            NotificationMessage notificationMessage2;
            notificationMessage = notificationMessage2;
            notificationMessage();
            notificationMessage.setBody(this.generateNotificationBody(context, 0, this.messages));
            notificationMessage.setFrom(this.generateNotificationTitle(0, message.getSenderName()));
            notificationMessage2.setAvatarURL(message.getSenderAvatarUrl());
        } else {
            NotificationMessage notificationMessage3;
            notificationMessage = notificationMessage3;
            notificationMessage();
            notificationMessage.setBody(this.generateNotificationBody(context, 1, this.messages));
            notificationMessage.setFrom(this.generateNotificationTitle(1, message.getSenderName()));
            notificationMessage3.setAvatarURL(message.getSenderAvatarUrl());
        }
        return notificationMessage;
    }

    private void handleInAppNotificationClickEvent() {
        Context context = Instabug.getApplicationContext();
        if (((NotificationManager)((Object)message)).type != 1) {
            List<Message> list = ((NotificationManager)((Object)message)).messages;
            Message message = list.get(list.size() - 1);
            if (context != null) {
                Context context2 = context;
                Intent intent = ChatActivityLauncher.chatProcessIntent(context2, message.getChatId());
                intent.addFlags(0x10000000);
                context2.startActivity(intent);
            }
        } else if (context != null) {
            Context context3 = context;
            context3.startActivity(ChatActivityLauncher.chatsProcessIntent(context3));
        }
    }

    private void notifyNotificationDismissed() {
        PresentationManager.getInstance().setNotificationShowing(false);
        PresentationManager.getInstance().notifyActivityChanged();
    }

    public void showNotification(Context context, List<Message> list) {
        InstabugAppData instabugAppData;
        Object object = instabugAppData;
        instabugAppData = new InstabugAppData(context);
        this.appData = object;
        object = "";
        Object object2 = null;
        int n = this.getNotificationType(list);
        NotificationManager notificationManager = this;
        notificationManager.type = n;
        notificationManager.messages = list;
        if (n != 0) {
            if (n == 1) {
                object = this.generateNotificationBody(context, 1, list);
                object2 = ChatActivityLauncher.chatsProcessIntent(context);
            }
        } else {
            List<Message> list2 = list;
            object = list2.get(list2.size() - 1);
            object2 = this.generateNotificationBody(context, 0, list);
            Object object3 = object = ChatActivityLauncher.chatProcessIntent(context, ((Message)object).getChatId());
            object = object2;
            object2 = object3;
        }
        if (!this.isAppOnForeground() && object2 != null) {
            this.showSystemNotification(context, (Intent)object2, (CharSequence)object);
        } else {
            this.handleAppOnForeground(context, list, (Intent)object2, (String)object);
        }
    }

    public void dismissSystemNotification(@Nullable Context context) {
        if (context != null) {
            ((android.app.NotificationManager)context.getSystemService("notification")).cancel(0);
        }
    }

    public void playNotificationSound(@Nullable Context context) {
        if (context != null && InstabugDeviceProperties.checkRingerIsOn((Context)context)) {
            MediaPlayer.OnCompletionListener onCompletionListener;
            context = MediaPlayer.create((Context)context, (int)R.raw.ib_core_sound_new_message);
            if (Build.VERSION.SDK_INT >= 21) {
                context.setAudioAttributes(new AudioAttributes.Builder().setUsage(5).setContentType(4).build());
            } else {
                context.setAudioStreamType(5);
            }
            Context context2 = context;
            context2.start();
            MediaPlayer.OnCompletionListener onCompletionListener2 = onCompletionListener;
            onCompletionListener = new MediaPlayer.OnCompletionListener(){
                final /* synthetic */ MediaPlayer val$mPlayer;
                {
                    this.val$mPlayer = mediaPlayer;
                }

                public void onCompletion(MediaPlayer mediaPlayer) {
                    this.val$mPlayer.release();
                }
            };
            context2.setOnCompletionListener(onCompletionListener2);
            return;
        }
    }

    public void showNotification(Bundle bundle) {
        if (InstabugCore.getFeatureState((String)"PUSH_NOTIFICATION") == Feature.State.ENABLED && this.isInstabugNotification(bundle) && SynchronizationManager.getInstance() != null) {
            SynchronizationManager.getInstance().sync(false);
        }
    }

    public void showNotification(Map<String, String> map) {
        if (InstabugCore.getFeatureState((String)"PUSH_NOTIFICATION") == Feature.State.ENABLED && this.isInstabugNotification(map) && SynchronizationManager.getInstance() != null) {
            SynchronizationManager.getInstance().sync(false);
        }
    }

    public boolean isInstabugNotification(Bundle bundle) {
        block8: {
            Object object;
            block11: {
                JSONException jSONException2;
                block10: {
                    if (!bundle.containsKey("message")) break block11;
                    object = bundle.getString("message");
                    if (object == null) break block8;
                    object = new JSONObject((String)object).getString("IBGHost");
                    InstabugSDKLogger.d((String)"IBG-Core", (String)("IBGHost: " + (String)object));
                    if (object == null) break block8;
                    try {
                        if (Boolean.parseBoolean((String)object)) {
                            return true;
                        }
                        break block8;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (JSONException jSONException2) {
                        break block10;
                    }
                    InstabugSDKLogger.e((String)"IBG-Core", (String)"Something went wrong while showing notification", (Throwable)nullPointerException);
                    break block8;
                }
                InstabugSDKLogger.e((String)"IBG-Core", (String)"Parsing GCM response failed", (Throwable)jSONException2);
                break block8;
            }
            if (bundle.containsKey("IBGHost")) {
                object = bundle.getString("IBGHost");
                return object != null && Boolean.parseBoolean((String)object);
            }
        }
        return false;
    }

    public boolean isInstabugNotification(Map<String, String> map) {
        block7: {
            Object object;
            block10: {
                JSONException jSONException2;
                block9: {
                    if (!map.containsKey("message")) break block10;
                    object = map.get("message");
                    object = new JSONObject((String)object).getString("IBGHost");
                    if (object == null) break block7;
                    try {
                        if (Boolean.parseBoolean((String)object)) {
                            return true;
                        }
                        break block7;
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (JSONException jSONException2) {
                        break block9;
                    }
                    InstabugSDKLogger.e((String)"IBG-Core", (String)"Something went wrong while showing notification", (Throwable)nullPointerException);
                    break block7;
                }
                InstabugSDKLogger.e((String)"IBG-Core", (String)"Parsing GCM response failed", (Throwable)jSONException2);
                break block7;
            }
            if (map.containsKey("IBGHost")) {
                object = map.get("IBGHost");
                return object != null && Boolean.parseBoolean((String)object);
            }
        }
        return false;
    }
}

