/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.cache;

import android.content.Context;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.cache.ReadQueueCacheManager;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.ReadMessage;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.OnDiskCache;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

public abstract class CacheUtility {
    public static void prepareCache(final Context context) {
        PoolProvider.getSingleThreadExecutor((String)"chats-cache-executor").execute(new Runnable(){

            @Override
            public void run() {
                OnDiskCache onDiskCache;
                OnDiskCache onDiskCache2;
                OnDiskCache onDiskCache3 = onDiskCache2;
                onDiskCache2 = new OnDiskCache(context, "chats_disk_cache", "/chats.cache", Chat.class);
                CacheManager.getInstance().addCache((Cache)onDiskCache3);
                onDiskCache3 = onDiskCache;
                try {
                    onDiskCache = new OnDiskCache(context, "read_queue_disk_cache_key", "/read_queue.cache", ReadMessage.class);
                    CacheManager.getInstance().addCache((Cache)onDiskCache3);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("failed to prepare chat cache due to " + exception.getMessage()));
                }
            }
        });
    }

    public static void cleanupChats() {
        PoolProvider.getSingleThreadExecutor((String)"chats-cache-executor").execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatsCacheManager.cleanupChats();
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("failed to clean chat cache " + exception.getMessage()));
                }
            }
        });
    }

    public static void dumpCache() {
        PoolProvider.getSingleThreadExecutor((String)"chats-cache-executor").execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatsCacheManager.saveCacheToDisk();
                    ReadQueueCacheManager.saveCacheToDisk();
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("failed to dump chat cache " + exception.getMessage()));
                }
            }
        });
    }
}

