/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.PointF;
import com.instabug.chat.annotation.ControlButton;
import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.chat.annotation.shape.ArrowShape;
import com.instabug.chat.annotation.shape.Shape;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Stack;

public class MarkUpDrawable
implements Serializable {
    protected volatile Shape shape;
    protected Shape firstShape;
    protected DirectionRectF bounds;
    protected DirectionRectF lastBounds;
    private Stack<DirectionRectF> translationsStack;

    public MarkUpDrawable(Shape shape) {
        Stack stack;
        DirectionRectF directionRectF;
        DirectionRectF directionRectF2;
        Serializable serializable = directionRectF2;
        directionRectF2 = new DirectionRectF();
        v1.bounds = serializable;
        serializable = directionRectF;
        directionRectF = new DirectionRectF();
        v1.lastBounds = serializable;
        serializable = stack;
        stack = new Stack();
        v1.translationsStack = serializable;
        v1.shape = shape;
        v1.firstShape = shape;
    }

    private void addLastPosition(DirectionRectF directionRectF) {
        if (this.lastBounds != null) {
            this.translationsStack.push(new DirectionRectF(this.lastBounds));
        }
        this.lastBounds = directionRectF;
    }

    public void setBounds(DirectionRectF directionRectF) {
        this.bounds = directionRectF;
        this.lastBounds.set(directionRectF);
    }

    public boolean isTouched(PointF pointF) {
        if (this.lastBounds.isVisible()) {
            return this.shape.isTouched(pointF, this.bounds);
        }
        return false;
    }

    protected void draw(Canvas canvas) {
        if (serializable.lastBounds.isVisible()) {
            canvas.save();
            MarkUpDrawable markUpDrawable = serializable;
            Serializable serializable = markUpDrawable.bounds;
            serializable.shape.draw(canvas, (DirectionRectF)serializable, markUpDrawable.lastBounds);
            canvas.restore();
        }
    }

    public void onActionUp() {
        this.addLastPosition(new DirectionRectF(this.bounds));
    }

    public void setVisibility(boolean bl) {
        DirectionRectF directionRectF = new DirectionRectF(this.bounds);
        directionRectF.setVisibility(bl);
        this.addLastPosition(directionRectF);
    }

    public boolean back() {
        if (((AbstractCollection)serializable.translationsStack).size() > 0) {
            MarkUpDrawable markUpDrawable = serializable;
            markUpDrawable.lastBounds = markUpDrawable.translationsStack.pop();
            if (((AbstractCollection)markUpDrawable.translationsStack).size() == 0) {
                serializable.shape = serializable.firstShape;
            }
            MarkUpDrawable markUpDrawable2 = serializable;
            Serializable serializable = markUpDrawable2.lastBounds;
            serializable.shape.adjustBounds((DirectionRectF)serializable, markUpDrawable2.bounds, true);
            return true;
        }
        return false;
    }

    public void translateBy(int n, int n2) {
        MarkUpDrawable markUpDrawable = serializable;
        Serializable serializable = markUpDrawable.bounds;
        serializable.shape.translateBy((DirectionRectF)serializable, markUpDrawable.lastBounds, n, n2);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void adjustBounds(DirectionRectF directionRectF) {
        this.shape.adjustBounds(directionRectF, this.bounds, false);
    }

    public void drawControlButtons(Canvas canvas, ControlButton ... controlButtonArray) {
        this.shape.drawControlButtons(canvas, this.bounds, controlButtonArray);
    }

    public void drawBorder(Canvas canvas) {
        Canvas canvas2 = canvas;
        MarkUpDrawable markUpDrawable = markUpDrawable2;
        MarkUpDrawable markUpDrawable2 = markUpDrawable.bounds.getTopLeftPoint();
        canvas = markUpDrawable.bounds.getTopRightPoint();
        PointF pointF = markUpDrawable.bounds.getBottomRightPoint();
        PointF pointF2 = markUpDrawable.bounds.getBottomLeftPoint();
        markUpDrawable2.shape.drawBorder(canvas2, (PointF)markUpDrawable2, (PointF)canvas, pointF, pointF2);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setShape(Shape shape, DirectionRectF directionRectF) {
        this.addLastPosition(new DirectionRectF(directionRectF));
        this.shape = shape;
        if (shape instanceof ArrowShape) {
            this.bounds = directionRectF;
        }
    }

    public boolean isVisible() {
        return this.lastBounds.isVisible();
    }
}

