/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import com.instabug.bug.R;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.view.ViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ColorPickerPopUpView
extends View {
    private static final int DEFAULT_BACKGROUND_COLOR = Color.argb((int)255, (int)247, (int)247, (int)247);
    @Nullable
    private RectF bounds;
    private Orientation orientation;
    private int popUpBackgroundColor;
    @Nullable
    private OnColorSelectionListener onColorSelectionListener;
    private final InternalViewsAccessibilityHelper accessHelper;
    @Size(value=7L)
    private int[] colors;
    private int selectedColor;
    private List<CheckCircleColor> checkCircleColorList;

    public ColorPickerPopUpView(Context context) {
        this(context, null);
    }

    public ColorPickerPopUpView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public ColorPickerPopUpView(Context object, @Nullable AttributeSet attributeSet, int n) {
        InternalViewsAccessibilityHelper internalViewsAccessibilityHelper;
        ColorPickerPopUpView colorPickerPopUpView = object2;
        super(object, attributeSet, n);
        object = internalViewsAccessibilityHelper;
        internalViewsAccessibilityHelper = new InternalViewsAccessibilityHelper((View)object2);
        colorPickerPopUpView.accessHelper = object;
        int[] nArray = new int[7];
        Object object2 = nArray;
        nArray[0] = -65536;
        nArray[1] = -15925503;
        nArray[2] = -65028;
        nArray[3] = -15893761;
        nArray[4] = -33280;
        nArray[5] = -1024;
        nArray[6] = -4737097;
        colorPickerPopUpView.colors = (int[])object2;
        colorPickerPopUpView.init(attributeSet, n);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void init(@Nullable AttributeSet object, int n) {
        ColorPickerPopUpView colorPickerPopUpView = this;
        ViewCompat.setAccessibilityDelegate((View)colorPickerPopUpView, (AccessibilityDelegateCompat)colorPickerPopUpView.accessHelper);
        object = colorPickerPopUpView.getContext().obtainStyledAttributes(object, R.styleable.ColorPickerPopUpView, n, 0);
        Orientation orientation = Orientation.PORTRAIT;
        if (colorPickerPopUpView.getScreenOrientation() != orientation) {
            orientation = Orientation.LANDSCAPE;
        }
        ColorPickerPopUpView colorPickerPopUpView2 = this;
        this.orientation = orientation;
        object.recycle();
        colorPickerPopUpView2.popUpBackgroundColor = DEFAULT_BACKGROUND_COLOR;
        colorPickerPopUpView2.checkCircleColorList = new ArrayList<CheckCircleColor>();
        object = colorPickerPopUpView2.colors;
        int n2 = colorPickerPopUpView2.colors.length;
        for (int i = 0; i < n2; ++i) {
            AttributeSet attributeSet = object[i];
            this.checkCircleColorList.add(new CheckCircleColor((int)attributeSet));
        }
        this.setSelectedColor(0);
    }

    private Orientation getScreenOrientation() {
        if (this.getResources().getConfiguration().orientation == 2) {
            return Orientation.LANDSCAPE;
        }
        return Orientation.PORTRAIT;
    }

    private static int find(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return 0;
    }

    private void drawCircleCheckColor(Canvas canvas, CheckCircleColor checkCircleColor) {
        RectF rectF;
        CheckCircleColor checkCircleColor2 = checkCircleColor;
        ColorPickerPopUpView colorPickerPopUpView = checkCircleColor2.rect;
        int n = checkCircleColor2.color;
        RectF rectF2 = rectF;
        float f = ((RectF)colorPickerPopUpView).left;
        float f2 = ((RectF)colorPickerPopUpView).top;
        float f3 = f + (float)Math.floor(colorPickerPopUpView.height() + 0.5f);
        rectF = new RectF(f, f2, f3, ((RectF)colorPickerPopUpView).top + (float)Math.floor(colorPickerPopUpView.height() + 0.5f));
        Path path = new Path();
        path.addOval(rectF2, Path.Direction.CW);
        Paint paint = new Paint(1);
        Paint.Style style2 = Paint.Style.FILL;
        paint.setStyle(style2);
        paint.setColor(n);
        canvas.drawPath(path, paint);
        if (checkCircleColor.checkVisibility) {
            Path path2 = new Path();
            path2.moveTo(((RectF)colorPickerPopUpView).left + colorPickerPopUpView.height() * 0.20313f, ((RectF)colorPickerPopUpView).top + colorPickerPopUpView.height() * 0.51758f);
            path2.lineTo(((RectF)colorPickerPopUpView).left + colorPickerPopUpView.height() * 0.39844f, ((RectF)colorPickerPopUpView).top + colorPickerPopUpView.height() * 0.71875f);
            path2.lineTo(((RectF)colorPickerPopUpView).left + colorPickerPopUpView.height() * 0.79492f, ((RectF)colorPickerPopUpView).top + colorPickerPopUpView.height() * 0.33008f);
            path2.lineTo(((RectF)colorPickerPopUpView).left + colorPickerPopUpView.height() * 0.74805f, ((RectF)colorPickerPopUpView).top + colorPickerPopUpView.height() * 0.28125f);
            path2.lineTo(((RectF)colorPickerPopUpView).left + colorPickerPopUpView.height() * 0.39844f, ((RectF)colorPickerPopUpView).top + colorPickerPopUpView.height() * 0.625f);
            path2.lineTo(((RectF)colorPickerPopUpView).left + colorPickerPopUpView.height() * 0.25f, ((RectF)colorPickerPopUpView).top + colorPickerPopUpView.height() * 0.47266f);
            path2.lineTo(((RectF)colorPickerPopUpView).left + colorPickerPopUpView.height() * 0.20313f, ((RectF)colorPickerPopUpView).top + colorPickerPopUpView.height() * 0.51758f);
            path2.close();
            Paint paint2 = new Paint(1);
            paint2.setStyle(style2);
            paint2.setColor(-1);
            canvas.drawPath(path2, paint2);
        }
    }

    private void drawHorizontalBubbleView(Canvas canvas) {
        Paint paint;
        Path path;
        Object object = path;
        path = new Path();
        RectF rectF = this.bounds;
        if (rectF != null) {
            Path path2 = object;
            RectF rectF2 = rectF;
            float f = rectF2.left;
            object.moveTo(f, rectF2.top);
            object.lineTo(this.bounds.width(), this.bounds.top);
            object.lineTo(this.bounds.width(), this.bounds.height() + 200.0f);
            RectF rectF3 = this.bounds;
            object.lineTo(rectF3.left, rectF3.height() + 200.0f);
            RectF rectF4 = this.bounds;
            float f2 = rectF4.left;
            path2.lineTo(f2, rectF4.top);
            path2.close();
        }
        Canvas canvas2 = canvas;
        Path path3 = object;
        object = paint;
        Path path4 = object;
        path4(1);
        path4.setStyle(Paint.Style.FILL);
        paint.setColor(this.popUpBackgroundColor);
        canvas2.drawPath(path3, (Paint)object);
        canvas2.save();
        canvas2.restore();
        object = this.checkCircleColorList.iterator();
        while (object.hasNext()) {
            this.drawCircleCheckColor(canvas, (CheckCircleColor)object.next());
        }
    }

    private void setSelectedColor(int n) {
        this.selectedColor = this.colors[n];
        for (int i = 0; i < this.checkCircleColorList.size(); ++i) {
            CheckCircleColor checkCircleColor = this.checkCircleColorList.get(i);
            boolean bl = i == n;
            checkCircleColor.checkVisibility = bl;
        }
        ColorPickerPopUpView colorPickerPopUpView = this;
        colorPickerPopUpView.invalidate();
        OnColorSelectionListener onColorSelectionListener = colorPickerPopUpView.onColorSelectionListener;
        if (onColorSelectionListener != null) {
            onColorSelectionListener.onColorSelected(this.selectedColor, n);
        }
    }

    protected void onMeasure(int n, int n2) {
        ColorPickerPopUpView colorPickerPopUpView = this;
        super.onMeasure(n, n2);
        int n3 = colorPickerPopUpView.getMeasuredWidth();
        colorPickerPopUpView.setMeasuredDimension(n3, n3 * 55 / 426);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        float f = motionEvent2.getX();
        float f2 = motionEvent2.getY();
        if (MotionEventCompat.getActionMasked((MotionEvent)motionEvent) == 1) {
            for (int i = 0; i < this.checkCircleColorList.size(); ++i) {
                if (!this.checkCircleColorList.get(i).getHitArea().contains(f, f2)) continue;
                this.setSelectedColor(i);
                break;
            }
        }
        return true;
    }

    protected void onConfigurationChanged(Configuration object) {
        ColorPickerPopUpView colorPickerPopUpView = this;
        super.onConfigurationChanged(object);
        object = Orientation.PORTRAIT;
        if (colorPickerPopUpView.getScreenOrientation() != object) {
            object = Orientation.LANDSCAPE;
        }
        this.orientation = object;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        float f;
        super.onSizeChanged(n, n2, n3, n4);
        if (colorPickerPopUpView.orientation == Orientation.LANDSCAPE) {
            float f2 = (float)(n * 55) / 406.0f;
            if (InstabugDeviceProperties.isTablet((Context)colorPickerPopUpView.getContext())) {
                RectF rectF;
                RectF rectF2 = rectF;
                f = ViewUtils.convertDpToPx((Context)colorPickerPopUpView.getContext(), (float)110.0f);
                float f3 = n;
                rectF = new RectF(0.0f, f, f3, f2);
                colorPickerPopUpView.bounds = rectF2;
            } else {
                RectF rectF;
                RectF rectF3 = rectF;
                f = ViewUtils.convertDpToPx((Context)colorPickerPopUpView.getContext(), (float)50.0f);
                float f4 = n;
                rectF = new RectF(0.0f, f, f4, f2);
                colorPickerPopUpView.bounds = rectF3;
            }
        } else {
            float f5 = (float)(n * 55) / 420.0f;
            if (InstabugDeviceProperties.isTablet((Context)colorPickerPopUpView.getContext())) {
                RectF rectF;
                RectF rectF4 = rectF;
                f = ViewUtils.convertDpToPx((Context)colorPickerPopUpView.getContext(), (float)60.0f);
                float f6 = n;
                rectF = new RectF(0.0f, f, f6, f5);
                colorPickerPopUpView.bounds = rectF4;
            } else {
                RectF rectF;
                RectF rectF5 = rectF;
                f = ViewUtils.convertDpToPx((Context)colorPickerPopUpView.getContext(), (float)16.0f);
                float f7 = n;
                rectF = new RectF(0.0f, f, f7, f5);
                colorPickerPopUpView.bounds = rectF5;
            }
        }
        RectF rectF = colorPickerPopUpView.bounds;
        float f8 = rectF.left + (float)Math.floor(rectF.width() * 0.04429f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f9 = rectF.top + (float)Math.floor(rectF.height() * 0.2f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f10 = rectF.left + (float)Math.floor(rectF.width() * 0.09857f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        colorPickerPopUpView.checkCircleColorList.get((int)0).rect = new RectF(f8, f9, f10, rectF.top + (float)Math.floor(rectF.height() * 0.66504f + 0.5f));
        rectF = colorPickerPopUpView.bounds;
        float f11 = rectF.left + (float)Math.floor(rectF.width() * 0.18714f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f12 = rectF.top + (float)Math.floor(rectF.height() * 0.2f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f13 = rectF.left + (float)Math.floor(rectF.width() * 0.24143f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        colorPickerPopUpView.checkCircleColorList.get((int)1).rect = new RectF(f11, f12, f13, rectF.top + (float)Math.floor(rectF.height() * 0.66504f + 0.5f));
        rectF = colorPickerPopUpView.bounds;
        float f14 = rectF.left + (float)Math.floor(rectF.width() * 0.33f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f15 = rectF.top + (float)Math.floor(rectF.height() * 0.2f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f16 = rectF.left + (float)Math.floor(rectF.width() * 0.38429f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        colorPickerPopUpView.checkCircleColorList.get((int)2).rect = new RectF(f14, f15, f16, rectF.top + (float)Math.floor(rectF.height() * 0.66504f + 0.5f));
        rectF = colorPickerPopUpView.bounds;
        float f17 = rectF.left + (float)Math.floor(rectF.width() * 0.47286f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f18 = rectF.top + (float)Math.floor(rectF.height() * 0.2f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f19 = rectF.left + (float)Math.floor(rectF.width() * 0.52714f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        colorPickerPopUpView.checkCircleColorList.get((int)3).rect = new RectF(f17, f18, f19, rectF.top + (float)Math.floor(rectF.height() * 0.66504f + 0.5f));
        rectF = colorPickerPopUpView.bounds;
        float f20 = rectF.left + (float)Math.floor(rectF.width() * 0.61571f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f21 = rectF.top + (float)Math.floor(rectF.height() * 0.2f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f22 = rectF.left + (float)Math.floor(rectF.width() * 0.67f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        colorPickerPopUpView.checkCircleColorList.get((int)4).rect = new RectF(f20, f21, f22, rectF.top + (float)Math.floor(rectF.height() * 0.66504f + 0.5f));
        rectF = colorPickerPopUpView.bounds;
        float f23 = rectF.left + (float)Math.floor(rectF.width() * 0.75857f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f24 = rectF.top + (float)Math.floor(rectF.height() * 0.2f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f25 = rectF.left + (float)Math.floor(rectF.width() * 0.81286f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        colorPickerPopUpView.checkCircleColorList.get((int)5).rect = new RectF(f23, f24, f25, rectF.top + (float)Math.floor(rectF.height() * 0.66504f + 0.5f));
        rectF = colorPickerPopUpView.bounds;
        float f26 = rectF.left + (float)Math.floor(rectF.width() * 0.90143f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        float f27 = rectF.top + (float)Math.floor(rectF.height() * 0.2f + 0.5f);
        rectF = colorPickerPopUpView.bounds;
        ColorPickerPopUpView colorPickerPopUpView = colorPickerPopUpView.bounds;
        colorPickerPopUpView.checkCircleColorList.get((int)6).rect = new RectF(f26, f27, rectF.left + (float)Math.floor(rectF.width() * 0.95571f + 0.5f), ((RectF)colorPickerPopUpView).top + (float)Math.floor(colorPickerPopUpView.height() * 0.66504f + 0.5f));
    }

    protected void onDraw(Canvas canvas) {
        ColorPickerPopUpView colorPickerPopUpView = this;
        super.onDraw(canvas);
        colorPickerPopUpView.drawHorizontalBubbleView(canvas);
    }

    public void setColors(@Size(value=7L) int[] nArray) {
        this.colors = Arrays.copyOf(nArray, nArray.length);
    }

    public void setPopUpBackgroundColor(int n) {
        this.popUpBackgroundColor = n;
        this.invalidate();
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public int getSelectedColor() {
        return this.selectedColor;
    }

    public void setOnColorSelectionListener(@Nullable OnColorSelectionListener onColorSelectionListener) {
        this.onColorSelectionListener = onColorSelectionListener;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle2.putParcelable("instabug_color_picker", super.onSaveInstanceState());
        bundle.putInt("selected_color", this.selectedColor);
        return bundle;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            ColorPickerPopUpView colorPickerPopUpView = this;
            Bundle bundle = (Bundle)parcelable;
            this.selectedColor = bundle.getInt("selected_color");
            parcelable = bundle.getParcelable("instabug_color_picker");
            colorPickerPopUpView.setSelectedColor(ColorPickerPopUpView.find(colorPickerPopUpView.colors, this.selectedColor));
        }
        super.onRestoreInstanceState(parcelable);
    }

    public List<CheckCircleColor> getCheckCircleColorList() {
        return this.checkCircleColorList;
    }

    protected boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (this.accessHelper.dispatchHoverEvent(motionEvent)) {
            return true;
        }
        return super.dispatchHoverEvent(motionEvent);
    }

    private static class InternalViewsAccessibilityHelper
    extends ExploreByTouchHelper {
        private final ColorPickerPopUpView host;
        private final String[] colorsNames;

        public InternalViewsAccessibilityHelper(@NonNull View view) {
            super(view);
            this.host = (ColorPickerPopUpView)view;
            this.colorsNames = view.getContext().getResources().getStringArray(R.array.ibg_bug_annotation_colors_names_content_description);
        }

        protected void getVisibleVirtualViews(List<Integer> list) {
            int n = this.host.getCheckCircleColorList().size();
            for (int i = 0; i < n; ++i) {
                list.add(i);
            }
        }

        protected int getVirtualViewAt(float f, float f2) {
            return Math.min((int)(f / ((float)this.host.getWidth() / (float)this.host.getCheckCircleColorList().size())), this.host.getCheckCircleColorList().size());
        }

        protected void onPopulateNodeForVirtualView(int n, @NonNull AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            Rect rect;
            AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
            accessibilityNodeInfoCompat.setClassName((CharSequence)ColorPickerPopUpView.class.getSimpleName());
            accessibilityNodeInfoCompat2.setContentDescription((CharSequence)internalViewsAccessibilityHelper.colorsNames[n]);
            accessibilityNodeInfoCompat2.setRoleDescription((CharSequence)"Button");
            accessibilityNodeInfoCompat2.addAction(16);
            InternalViewsAccessibilityHelper internalViewsAccessibilityHelper = rect;
            internalViewsAccessibilityHelper.host.getCheckCircleColorList().get((int)n).rect.round(new Rect());
            accessibilityNodeInfoCompat.setBoundsInParent((Rect)internalViewsAccessibilityHelper);
        }

        protected boolean onPerformActionForVirtualView(int n, int n2, @Nullable Bundle bundle) {
            return false;
        }
    }

    public static enum Orientation {
        PORTRAIT,
        LANDSCAPE;

    }

    static class CheckCircleColor {
        RectF rect;
        int color;
        boolean checkVisibility;

        public CheckCircleColor(int n) {
            RectF rectF;
            CheckCircleColor checkCircleColor = rectF;
            rectF = new RectF();
            v1.rect = checkCircleColor;
            v1.color = n;
        }

        public RectF getHitArea() {
            RectF rectF;
            RectF rectF2 = rectF;
            rectF2();
            rectF2.set(this.rect);
            rectF.inset(-this.rect.width() / 3.0f, -this.rect.height() / 3.0f);
            return rectF;
        }
    }

    public static interface OnColorSelectionListener {
        public void onColorSelected(@ColorInt int var1, int var2);
    }
}

