/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.instabug.chat.annotation.ControlButton;
import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.chat.annotation.MarkUpDrawable;
import com.instabug.chat.annotation.MarkUpStack;
import com.instabug.chat.annotation.recognition.PathRecognizer;
import com.instabug.chat.annotation.recognition.ShapeSpecs$Type;
import com.instabug.chat.annotation.shape.ArrowShape;
import com.instabug.chat.annotation.shape.BlurredRectShape;
import com.instabug.chat.annotation.shape.OvalShape;
import com.instabug.chat.annotation.shape.PathShape;
import com.instabug.chat.annotation.shape.RectShape;
import com.instabug.chat.annotation.shape.Shape;
import com.instabug.chat.annotation.shape.ZoomedShape;
import com.instabug.chat.annotation.utility.AspectRatioCalculator;
import com.instabug.library.util.DrawingUtility;
import com.instabug.library.util.OrientationUtils;
import com.instabug.library.util.threading.PoolProvider;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"LI_LAZY_INIT_UPDATE_STATIC", "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public class AnnotationView
extends AppCompatImageView {
    @Nullable
    private static volatile MarkUpDrawable selectedMarkUpDrawable;
    private final GestureDetector gestureDetector;
    @Nullable
    private Path mPath;
    @Nullable
    private List<PointF> freeHandDrawingPoints;
    private Paint pathPaint;
    private int pathColor;
    private final LinkedHashMap<Path, Integer> paths;
    private float mX;
    private float mY;
    private boolean moved;
    @Nullable
    private volatile Drawable screenshot;
    private final PointF[] lastDrawing;
    @Nullable
    private Bitmap originalBitmap;
    @Nullable
    private Bitmap scaledBitmap;
    private int drawingLevel;
    private volatile boolean capturing;
    private final ControlButton topLeftButton;
    private final ControlButton bottomRightButton;
    private final ControlButton bottomLeftButton;
    private final ControlButton topRightButton;
    private final PointF touchedPoint;
    private volatile ActionMode actionMode;
    private DrawingMode drawingMode;
    @Nullable
    private volatile MarkUpStack currentMarkUpStack;
    private AspectRatioCalculator aspectRatioCalculator;
    @Nullable
    private volatile OnActionDownListener onActionDownListener;
    @Nullable
    private OnNewMagnifierAddingAbilityChangedListener onNewMagnifierAddingAbilityChangedListener;
    @Nullable
    private OnPathRecognizedListener onPathRecognizedListener;
    private boolean isTouching;
    @Nullable
    private Shape recognizedShape;
    @Nullable
    private DirectionRectF recognizedShapeRect;
    private volatile boolean orientationChanged;
    private final String ANNOTATION_TASK_KEY;
    int magnifiersCount;

    public AnnotationView(Context context) {
        this(context, null);
    }

    public AnnotationView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public AnnotationView(Context object, @Nullable AttributeSet pointF, int n) {
        GestureListener gestureListener;
        AnnotationView annotationView = this;
        super(object, (AttributeSet)pointF, n);
        annotationView.paths = new LinkedHashMap();
        annotationView.lastDrawing = new PointF[5];
        annotationView.touchedPoint = new PointF();
        annotationView.actionMode = ActionMode.NONE;
        annotationView.drawingMode = DrawingMode.NONE;
        annotationView.aspectRatioCalculator = new AspectRatioCalculator();
        annotationView.orientationChanged = false;
        annotationView.ANNOTATION_TASK_KEY = "IBG-ANNOTATION-TASK";
        annotationView.currentMarkUpStack = new MarkUpStack();
        Context context = object;
        object = gestureListener;
        gestureListener = new GestureListener();
        annotationView.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)object);
        new Paint(1).setColor(-65281);
        annotationView.topLeftButton = new ControlButton();
        annotationView.bottomRightButton = new ControlButton();
        annotationView.bottomLeftButton = new ControlButton();
        annotationView.topRightButton = new ControlButton();
        annotationView.initDrawing();
        for (int i = 0; i < ((PointF[])(pointF = this.lastDrawing)).length; ++i) {
            PointF pointF2;
            PointF pointF3 = pointF;
            pointF = pointF2;
            pointF2 = new PointF();
            pointF3[i] = pointF;
        }
    }

    private MarkUpStack getScaledDrawables() {
        MarkUpStack markUpStack;
        AnnotationView annotationView = this;
        annotationView.aspectRatioCalculator.setNewHeight(this.getHeight());
        annotationView.aspectRatioCalculator.setNewWidth(this.getWidth());
        if (annotationView.currentMarkUpStack == null) {
            MarkUpStack markUpStack2;
            markUpStack = markUpStack2;
            markUpStack2 = new MarkUpStack();
        } else {
            markUpStack = this.currentMarkUpStack;
        }
        if (markUpStack != null) {
            for (MarkUpDrawable markUpDrawable : markUpStack.getAll()) {
                DirectionRectF directionRectF;
                DirectionRectF directionRectF2 = directionRectF;
                directionRectF2();
                MarkUpDrawable markUpDrawable2 = markUpDrawable;
                float f = markUpDrawable2.bounds.top * this.aspectRatioCalculator.getFactorHeight();
                float f2 = markUpDrawable2.bounds.right * this.aspectRatioCalculator.getFactorWidth();
                float f3 = markUpDrawable2.bounds.bottom * this.aspectRatioCalculator.getFactorHeight();
                directionRectF.set(markUpDrawable.bounds.left * this.aspectRatioCalculator.getFactorWidth(), f, f2, f3);
                if (markUpDrawable.getShape() instanceof ArrowShape) {
                    ((ArrowShape)markUpDrawable.getShape()).updateTailAndHead(directionRectF2);
                }
                directionRectF2.setVisibility(markUpDrawable.bounds.isVisible());
                markUpDrawable.setBounds(new DirectionRectF(directionRectF2));
            }
        }
        this.currentMarkUpStack = markUpStack;
        return this.currentMarkUpStack;
    }

    private void initDrawing() {
        AnnotationView annotationView = this;
        this.pathPaint = new Paint();
        this.pathPaint.setAntiAlias(true);
        annotationView.pathPaint.setDither(true);
        annotationView.pathColor = -65536;
        annotationView.pathPaint.setColor(-65536);
        annotationView.pathPaint.setStyle(Paint.Style.STROKE);
        annotationView.pathPaint.setStrokeJoin(Paint.Join.ROUND);
        annotationView.pathPaint.setStrokeCap(Paint.Cap.ROUND);
        annotationView.pathPaint.setStrokeWidth(this.getContext().getResources().getDisplayMetrics().density * 4.0f);
    }

    private void touch_start(float f, float f2) {
        AnnotationView annotationView = this;
        annotationView.mPath = new Path();
        annotationView.freeHandDrawingPoints = new ArrayList<PointF>();
        ((AbstractMap)annotationView.paths).put(this.mPath, this.pathColor);
        annotationView.mPath.reset();
        annotationView.mPath.moveTo(f, f2);
        annotationView.freeHandDrawingPoints.add(new PointF(f, f2));
        this.mX = f;
        this.mY = f2;
        this.resetToCurrentPoint(f, f2);
    }

    private void resetToCurrentPoint(float f, float f2) {
        PointF[] pointFArray = pointFArray.lastDrawing;
        int n = pointFArray.lastDrawing.length;
        for (int i = 0; i < n; ++i) {
            PointF pointF = pointFArray[i];
            pointF.x = f;
            pointF.y = f2;
        }
    }

    private void touch_move(float f, float f2) {
        float f3 = Math.abs(f2 - ((AnnotationView)((Object)object)).mY);
        if (Math.abs(f - ((AnnotationView)((Object)object)).mX) >= 8.0f || f3 >= 8.0f) {
            Path path = ((AnnotationView)((Object)object)).mPath;
            if (path != null) {
                AnnotationView annotationView = object;
                float f4 = annotationView.mX;
                float f5 = annotationView.mY;
                float f6 = (f + f4) / 2.0f;
                float f7 = (f2 + f5) / 2.0f;
                path.quadTo(f4, f5, f6, f7);
            }
            ((AnnotationView)((Object)object)).mX = f;
            ((AnnotationView)((Object)object)).mY = f2;
            Object object = ((AnnotationView)((Object)object)).freeHandDrawingPoints;
            if (object != null) {
                PointF pointF;
                Object object2 = object;
                object = pointF;
                pointF = new PointF(f, f2);
                object2.add(object);
            }
        }
    }

    private void touch_up() {
        Path path = this.mPath;
        if (path != null && this.freeHandDrawingPoints != null) {
            DirectionRectF directionRectF;
            AnnotationView annotationView = this;
            float f = annotationView.mX;
            path.lineTo(f, annotationView.mY);
            PathMeasure pathMeasure = new PathMeasure(path, false);
            if (pathMeasure.getLength() < 20.0f) {
                ((AbstractMap)this.paths).remove(path);
                return;
            }
            MarkUpStack markUpStack = this.currentMarkUpStack;
            AnnotationView annotationView2 = this;
            float f2 = annotationView2.pathPaint.getStrokeWidth();
            Object object = annotationView2.pathPaint;
            List<PointF> list = annotationView2.freeHandDrawingPoints;
            Serializable serializable = selectedMarkUpDrawable = new MarkUpDrawable(new PathShape(path, f2, (Paint)object, list));
            object = directionRectF;
            path.computeBounds((RectF)new DirectionRectF(), true);
            if (serializable != null) {
                DirectionRectF directionRectF2;
                MarkUpDrawable markUpDrawable = serializable;
                serializable = directionRectF2;
                directionRectF2 = new DirectionRectF((DirectionRectF)object);
                markUpDrawable.setBounds((DirectionRectF)serializable);
            }
            if (markUpStack != null) {
                markUpStack.addOnTop(selectedMarkUpDrawable);
            }
            AnnotationView annotationView3 = this;
            ((AbstractMap)annotationView3.paths).remove(path);
            annotationView3.invalidate();
            this.recognizeShape((DirectionRectF)object);
        }
    }

    private synchronized void recognizeShape(DirectionRectF directionRectF) {
        if (annotationView3.mPath == null) {
            return;
        }
        PathRecognizer.Recognition recognition = new PathRecognizer().recognize(annotationView3.mPath);
        Shape shape = null;
        ShapeSpecs$Type shapeSpecs$Type = recognition.shapeType;
        ShapeSpecs$Type shapeSpecs$Type2 = ShapeSpecs$Type.ARROW;
        if (shapeSpecs$Type != shapeSpecs$Type2 && shapeSpecs$Type != ShapeSpecs$Type.LINE) {
            if (shapeSpecs$Type == ShapeSpecs$Type.RECT) {
                RectShape rectShape;
                PathRecognizer.Recognition recognition2 = recognition;
                float f = Math.max(directionRectF.width(), directionRectF.height()) / 2.0f;
                float f2 = f;
                float f3 = directionRectF.centerX() + f2;
                float f4 = directionRectF.centerY() - f2;
                f2 = directionRectF.centerY() + f2;
                directionRectF.set(directionRectF.centerX() - f, f4, f3, f2);
                f2 = recognition2.paddingPercent * directionRectF.width();
                int n = recognition2.angle;
                int n2 = n <= 20 ? 0 : (n >= 70 && n <= 110 ? 90 : (n >= 160 ? 180 : n));
                if (n2 != 0 && n2 != 180) {
                    if (n2 == 90) {
                        directionRectF.top += f2;
                        directionRectF.bottom -= f2;
                    } else if (n2 > 90 && n2 < 180) {
                        n2 -= 90;
                        directionRectF.top += f2;
                        directionRectF.bottom -= f2;
                    } else {
                        directionRectF.left += f2;
                        directionRectF.right -= f2;
                    }
                } else {
                    directionRectF.left += f2;
                    directionRectF.right -= f2;
                }
                if (n >= 20 && n <= 70 || n >= 110 && n <= 160) {
                    f2 = directionRectF.width() * 0.1f;
                    float f5 = directionRectF.height() * 0.1f;
                    directionRectF.left += f2;
                    directionRectF.right -= f2;
                    directionRectF.top += f5;
                    directionRectF.bottom -= f5;
                }
                shape = rectShape;
                rectShape = new RectShape(annotationView3.pathColor, annotationView3.pathPaint.getStrokeWidth(), n2);
            } else if (shapeSpecs$Type == ShapeSpecs$Type.OVAL) {
                OvalShape ovalShape;
                PathRecognizer.Recognition recognition3 = recognition;
                float f = Math.max(directionRectF.width(), directionRectF.height()) / 2.0f;
                float f6 = f;
                float f7 = directionRectF.centerX() + f6;
                float f8 = directionRectF.centerY() - f6;
                f6 = directionRectF.centerY() + f6;
                directionRectF.set(directionRectF.centerX() - f, f8, f7, f6);
                f6 = recognition3.paddingPercent * directionRectF.width();
                int n = recognition3.angle;
                if (n <= 20) {
                    n = 0;
                } else if (n >= 70 && n <= 110) {
                    n = 90;
                }
                if (n >= 90) {
                    n -= 90;
                    directionRectF.top += f6;
                    directionRectF.bottom -= f6;
                } else {
                    directionRectF.left += f6;
                    directionRectF.right -= f6;
                }
                OvalShape ovalShape2 = ovalShape;
                ovalShape = new OvalShape(annotationView3.pathColor, annotationView3.pathPaint.getStrokeWidth(), n);
                shape = ovalShape2;
            }
        } else {
            ArrowShape arrowShape;
            PointF pointF;
            PointF pointF2;
            float f = Math.max(directionRectF.width(), directionRectF.height()) / 2.0f;
            float f9 = directionRectF.centerX() - f;
            f = directionRectF.centerX() + f;
            PointF pointF3 = pointF2;
            pointF2 = new PointF(f9, directionRectF.centerY());
            PointF pointF4 = pointF;
            pointF = new PointF(f, directionRectF.centerY());
            DrawingUtility.rotatePoint((float)directionRectF.centerX(), (float)directionRectF.centerY(), (float)recognition.angle, (PointF)pointF3);
            DrawingUtility.rotatePoint((float)directionRectF.centerX(), (float)directionRectF.centerY(), (float)recognition.angle, (PointF)pointF4);
            shape = arrowShape;
            AnnotationView annotationView = annotationView3;
            int n = annotationView.pathColor;
            ((ArrowShape)shape)(pointF3, pointF4, n, annotationView.pathPaint.getStrokeWidth());
            arrowShape.setRecognitionAngle(recognition.angle);
            if (recognition.shapeType == shapeSpecs$Type2) {
                ((ArrowShape)shape).setType("arrow");
            }
            PointF pointF5 = pointF3;
            float f10 = Math.min(pointF5.x, pointF4.x);
            float f11 = Math.max(pointF5.x, pointF4.x);
            float f12 = Math.min(pointF5.y, pointF4.y);
            float f13 = Math.max(pointF5.y, pointF4.y);
            directionRectF.set(f10, f12, f11, f13);
        }
        AnnotationView annotationView = annotationView3;
        annotationView.recognizedShape = shape;
        annotationView.recognizedShapeRect = directionRectF;
        if (shape != null) {
            AnnotationView annotationView2 = annotationView3;
            AnnotationView annotationView3 = annotationView3.mPath;
            annotationView2.onPathRecognized((Path)annotationView3, shape.getPath(directionRectF));
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void setShape(Shape shape, DirectionRectF directionRectF) {
        MarkUpStack markUpStack = ((AnnotationView)((Object)markUpStack)).currentMarkUpStack;
        MarkUpDrawable markUpDrawable = selectedMarkUpDrawable;
        if (markUpDrawable != null && markUpStack != null && markUpDrawable.shape != null) {
            MarkUpDrawable markUpDrawable2 = markUpDrawable;
            markUpDrawable2.setShape(shape, directionRectF);
            markUpDrawable2.shape.setRecognized(true);
            markUpStack.onStateChangedMarkUpDrawable(selectedMarkUpDrawable);
        }
    }

    private void updateCroppedMarkUpDrawableBackground() {
        AnnotationView annotationView = this;
        MarkUpStack markUpStack = annotationView.currentMarkUpStack;
        MarkUpDrawable markUpDrawable = selectedMarkUpDrawable;
        if (annotationView.actionMode != ActionMode.DRAW && markUpStack != null && markUpDrawable != null) {
            for (int i = 1; i < markUpStack.size(); ++i) {
                MarkUpDrawable markUpDrawable2 = markUpStack.get(i);
                if (markUpStack.indexOf(markUpDrawable) > i || !(markUpDrawable2.getShape() instanceof ZoomedShape) || !markUpDrawable2.isVisible()) continue;
                ((ZoomedShape)markUpDrawable2.getShape()).setBackground(this.getScaledBitmap());
            }
        }
    }

    private synchronized void handleActionMode(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        float f = motionEvent2.getX();
        float f2 = motionEvent2.getY();
        MarkUpDrawable markUpDrawable = selectedMarkUpDrawable;
        switch (1.$SwitchMap$com$instabug$chat$annotation$AnnotationView$ActionMode[object.actionMode.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                DirectionRectF directionRectF;
                if (markUpDrawable == null) break;
                AnnotationView annotationView = object;
                Object object = directionRectF;
                directionRectF = new DirectionRectF();
                PointF pointF = annotationView.touchedPoint;
                float f3 = pointF.x;
                if (f < f3) {
                    ((RectF)object).left = (int)f;
                    ((RectF)object).right = (int)f3;
                } else {
                    Object object2 = object;
                    ((RectF)object2).left = (int)f3;
                    ((RectF)object2).right = (int)f;
                }
                f = pointF.y;
                if (f2 < f) {
                    ((RectF)object).top = (int)f2;
                    ((RectF)object).bottom = (int)f;
                } else {
                    Object object3 = object;
                    ((RectF)object3).top = (int)f;
                    ((RectF)object3).bottom = (int)f2;
                }
                markUpDrawable.setBounds((DirectionRectF)object);
                break;
            }
            case 5: {
                DirectionRectF directionRectF;
                Object object;
                if (markUpDrawable == null) break;
                if (markUpDrawable.getShape() instanceof ArrowShape) {
                    object = markUpDrawable.bounds;
                    ((ArrowShape)markUpDrawable.getShape()).adjustHeadPoint(f, f2, (DirectionRectF)object);
                    break;
                }
                DirectionRectF directionRectF2 = directionRectF;
                directionRectF = new DirectionRectF();
                DirectionRectF directionRectF3 = markUpDrawable.lastBounds;
                float f4 = directionRectF3.left;
                if (f < f4) {
                    directionRectF2.left = directionRectF3.right + (float)((int)(f - object.touchedPoint.x));
                    directionRectF2.right = directionRectF3.left;
                } else {
                    directionRectF2.left = f4;
                    directionRectF2.right = directionRectF3.right + (float)((int)(f - object.touchedPoint.x));
                }
                f4 = directionRectF3.bottom;
                if (f2 > f4) {
                    directionRectF2.top = f4;
                    directionRectF2.bottom = directionRectF3.top + (float)((int)(f2 - object.touchedPoint.y));
                } else {
                    directionRectF2.top = directionRectF3.top + (float)((int)(f2 - object.touchedPoint.y));
                    directionRectF2.bottom = f4;
                }
                markUpDrawable.adjustBounds(directionRectF2);
                if (!(markUpDrawable.getShape() instanceof RectShape)) break;
                object = markUpDrawable.bounds;
                ((RectShape)markUpDrawable.getShape()).adjustPoint1(f, f2, (DirectionRectF)object);
                break;
            }
            case 4: {
                DirectionRectF directionRectF;
                Object object;
                if (markUpDrawable == null) break;
                if (markUpDrawable.getShape() instanceof ArrowShape) {
                    object = markUpDrawable.bounds;
                    ((ArrowShape)markUpDrawable.getShape()).adjustTailPoint(f, f2, (DirectionRectF)object);
                    break;
                }
                DirectionRectF directionRectF4 = directionRectF;
                directionRectF = new DirectionRectF();
                DirectionRectF directionRectF5 = markUpDrawable.lastBounds;
                float f5 = directionRectF5.right;
                if (f > f5) {
                    directionRectF4.left = f5;
                    directionRectF4.right = directionRectF5.left + (float)((int)(f - object.touchedPoint.x));
                } else {
                    directionRectF4.left = directionRectF5.left + (float)((int)(f - object.touchedPoint.x));
                    directionRectF4.right = f5;
                }
                f5 = directionRectF5.bottom;
                if (f2 > f5) {
                    directionRectF4.top = f5;
                    directionRectF4.bottom = directionRectF5.top + (float)((int)(f2 - object.touchedPoint.y));
                } else {
                    directionRectF4.top = directionRectF5.top + (float)((int)(f2 - object.touchedPoint.y));
                    directionRectF4.bottom = f5;
                }
                markUpDrawable.adjustBounds(directionRectF4);
                if (!(markUpDrawable.getShape() instanceof RectShape)) break;
                object = markUpDrawable.bounds;
                ((RectShape)markUpDrawable.getShape()).adjustPoint0(f, f2, (DirectionRectF)object);
                break;
            }
            case 3: {
                DirectionRectF directionRectF;
                if (markUpDrawable == null) break;
                DirectionRectF directionRectF6 = directionRectF;
                directionRectF = new DirectionRectF();
                DirectionRectF directionRectF7 = markUpDrawable.lastBounds;
                float f6 = directionRectF7.right;
                if (f > f6) {
                    directionRectF6.left = f6;
                    directionRectF6.right = directionRectF7.left + (float)((int)(f - object.touchedPoint.x));
                } else {
                    directionRectF6.left = directionRectF7.left + (float)((int)(f - object.touchedPoint.x));
                    directionRectF6.right = f6;
                }
                f6 = directionRectF7.top;
                if (f2 < f6) {
                    directionRectF6.top = directionRectF7.bottom + (float)((int)(f2 - object.touchedPoint.y));
                    directionRectF6.bottom = directionRectF7.top;
                } else {
                    directionRectF6.top = f6;
                    directionRectF6.bottom = directionRectF7.bottom + (float)((int)(f2 - object.touchedPoint.y));
                }
                markUpDrawable.adjustBounds(directionRectF6);
                if (!(markUpDrawable.getShape() instanceof RectShape)) break;
                Object object = markUpDrawable.bounds;
                ((RectShape)markUpDrawable.getShape()).adjustPoint3(f, f2, (DirectionRectF)object);
                break;
            }
            case 2: {
                DirectionRectF directionRectF;
                if (markUpDrawable == null) break;
                DirectionRectF directionRectF8 = directionRectF;
                directionRectF = new DirectionRectF();
                DirectionRectF directionRectF9 = markUpDrawable.lastBounds;
                float f7 = directionRectF9.left;
                if (f < f7) {
                    directionRectF8.left = directionRectF9.right + (float)((int)(f - object.touchedPoint.x));
                    directionRectF8.right = directionRectF9.left;
                } else {
                    directionRectF8.left = f7;
                    directionRectF8.right = directionRectF9.right + (float)((int)(f - object.touchedPoint.x));
                }
                f7 = directionRectF9.top;
                if (f2 < f7) {
                    directionRectF8.top = directionRectF9.bottom + (float)((int)(f2 - object.touchedPoint.y));
                    directionRectF8.bottom = directionRectF9.top;
                } else {
                    directionRectF8.top = f7;
                    directionRectF8.bottom = directionRectF9.bottom + (float)((int)(f2 - object.touchedPoint.y));
                }
                markUpDrawable.adjustBounds(directionRectF8);
                if (!(markUpDrawable.getShape() instanceof RectShape)) break;
                Object object = markUpDrawable.bounds;
                ((RectShape)markUpDrawable.getShape()).adjustPoint2(f, f2, (DirectionRectF)object);
                break;
            }
            case 1: {
                if (markUpDrawable == null) break;
                PointF pointF = object.touchedPoint;
                int n = (int)(f - pointF.x);
                int n2 = (int)(f2 - pointF.y);
                markUpDrawable.translateBy(n, n2);
            }
        }
    }

    @Nullable
    private MarkUpDrawable getSelectedMarkUpDrawable() {
        MarkUpStack markUpStack = this.currentMarkUpStack;
        if (markUpStack != null) {
            for (int i = markUpStack.size() - 1; i >= 0; --i) {
                MarkUpDrawable markUpDrawable = markUpStack.get(i);
                if (!markUpDrawable.isTouched(this.touchedPoint)) continue;
                return markUpDrawable;
            }
        }
        return null;
    }

    private void addMarkUp(Shape shape, DirectionRectF directionRectF, Level level) {
        MarkUpDrawable markUpDrawable;
        AnnotationView annotationView = object;
        Object object = markUpDrawable;
        new MarkUpDrawable(shape).setBounds(directionRectF);
        annotationView.addMarkUp((MarkUpDrawable)object, level);
    }

    private void addMarkUp(MarkUpDrawable markUpDrawable, Level level) {
        this.getOriginalBitmap();
        selectedMarkUpDrawable = markUpDrawable;
        MarkUpStack markUpStack = this.currentMarkUpStack;
        if (markUpStack != null) {
            if (level == Level.LOW) {
                markUpStack.addOnBottom(markUpDrawable);
            } else {
                markUpStack.addOnTop(markUpDrawable);
            }
            this.invalidate();
        }
    }

    @Nullable
    private Bitmap getOriginalBitmap() {
        if (this.originalBitmap == null) {
            this.originalBitmap = this.toBitmap();
        }
        return this.originalBitmap;
    }

    private Bitmap toBitmap(int n) {
        Canvas canvas;
        annotationView2.drawingLevel = n;
        Bitmap bitmap = Bitmap.createBitmap((int)annotationView2.getWidth(), (int)annotationView2.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        AnnotationView annotationView = annotationView2;
        AnnotationView annotationView2 = canvas;
        canvas = new Canvas(bitmap);
        annotationView.capturing = true;
        annotationView.invalidate();
        annotationView.draw((Canvas)annotationView2);
        annotationView.capturing = false;
        annotationView.invalidate();
        return bitmap;
    }

    public static void setSelectedMarkUpDrawable(@Nullable MarkUpDrawable markUpDrawable) {
        selectedMarkUpDrawable = markUpDrawable;
    }

    private void checkNewMagnifierAddingAbility() {
        OnNewMagnifierAddingAbilityChangedListener onNewMagnifierAddingAbilityChangedListener = this.onNewMagnifierAddingAbilityChangedListener;
        if (onNewMagnifierAddingAbilityChangedListener != null) {
            if (this.magnifiersCount == 5) {
                onNewMagnifierAddingAbilityChangedListener.onAbilityChanged(false);
            }
            if (this.magnifiersCount == 4) {
                this.onNewMagnifierAddingAbilityChangedListener.onAbilityChanged(true);
            }
        }
    }

    private void refreshMarkupBackgroundIfPossible(MarkUpDrawable markUpDrawable) {
        if (markUpDrawable.getShape() instanceof ZoomedShape) {
            ((ZoomedShape)markUpDrawable.getShape()).setBackground(this.getScaledBitmap());
        } else if (markUpDrawable.getShape() instanceof BlurredRectShape) {
            PoolProvider.postOrderedIOTask((String)"IBG-ANNOTATION-TASK", () -> ((BlurredRectShape)markUpDrawable.getShape()).setBackground(this.getScaledBitmap()));
        }
    }

    @Nullable
    private Bitmap getScaledBitmap() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            Bitmap bitmap;
            if (this.scaledBitmap == null && (bitmap = this.originalBitmap) != null) {
                AnnotationView annotationView = this;
                int n = annotationView.getWidth();
                this.scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)annotationView.getHeight(), (boolean)true);
            }
            return this.scaledBitmap;
        }
        return null;
    }

    private void onPathRecognized(Path path, Path path2) {
        OnPathRecognizedListener onPathRecognizedListener = ((AnnotationView)((Object)onPathRecognizedListener)).onPathRecognizedListener;
        if (onPathRecognizedListener != null) {
            onPathRecognizedListener.onPathRecognized(path, path2);
        }
    }

    private /* synthetic */ void lambda$onTouchEvent$2(MarkUpStack markUpStack) {
        selectedMarkUpDrawable = new MarkUpDrawable(new BlurredRectShape(this.getOriginalBitmap(), this.getContext().getApplicationContext()));
        markUpStack.addOnBottom(selectedMarkUpDrawable);
        this.invalidate();
    }

    private /* synthetic */ void lambda$onTouchEvent$1(MarkUpStack markUpStack) {
        selectedMarkUpDrawable = new MarkUpDrawable(new OvalShape(this.pathColor, this.pathPaint.getStrokeWidth(), 0));
        markUpStack.addOnTop(selectedMarkUpDrawable);
        this.invalidate();
    }

    private /* synthetic */ void lambda$onTouchEvent$0(MarkUpStack markUpStack) {
        selectedMarkUpDrawable = new MarkUpDrawable(new RectShape(this.pathColor, this.pathPaint.getStrokeWidth(), 0));
        markUpStack.addOnTop(selectedMarkUpDrawable);
        this.invalidate();
    }

    protected void onAttachedToWindow() {
        AnnotationView annotationView = this;
        super.onAttachedToWindow();
        OrientationUtils.lockScreenOrientation((Context)annotationView.getContext());
    }

    protected void onMeasure(int n, int n2) {
        AnnotationView annotationView = this;
        super.onMeasure(n, n2);
        n = annotationView.getMeasuredWidth();
        n = n - this.getPaddingLeft() - this.getPaddingRight();
        n = n + this.getPaddingLeft() + this.getPaddingRight();
        annotationView.setMeasuredDimension(n, annotationView.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() + this.getPaddingTop() + this.getPaddingBottom());
    }

    public void setDrawingColor(int n) {
        this.pathColor = n;
        this.pathPaint.setColor(n);
    }

    protected synchronized void onSizeChanged(int n, int n2, int n3, int n4) {
        AnnotationView annotationView = this;
        super.onSizeChanged(n, n2, n3, n4);
        annotationView.getScaledDrawables();
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.originalBitmap = bitmap;
        super.setImageBitmap(bitmap);
    }

    synchronized void setRecognizedShape() {
        DirectionRectF directionRectF;
        Shape shape;
        if (selectedMarkUpDrawable != null && (shape = this.recognizedShape) != null && (directionRectF = this.recognizedShapeRect) != null) {
            AnnotationView annotationView = this;
            annotationView.setShape(shape, directionRectF);
            annotationView.invalidate();
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        Object object;
        AnnotationView annotationView = this;
        super.onDraw(canvas);
        Object object2 = annotationView.screenshot;
        if (object2 != null) {
            object2.draw(canvas);
        }
        if ((object2 = this.currentMarkUpStack) != null) {
            if (!this.capturing) {
                this.drawingLevel = ((MarkUpStack)object2).getAll().size();
            }
            object2 = ((MarkUpStack)object2).getAll();
            for (int i = 0; i < object2.size(); ++i) {
                object = (MarkUpDrawable)object2.get(i);
                this.refreshMarkupBackgroundIfPossible((MarkUpDrawable)object);
                ((MarkUpDrawable)object).draw(canvas);
            }
        }
        object2 = selectedMarkUpDrawable;
        if (!this.capturing && object2 != null) {
            if (this.isTouching) {
                ((MarkUpDrawable)object2).drawBorder(canvas);
            }
            AnnotationView annotationView2 = this;
            ControlButton controlButton = annotationView2.topLeftButton;
            object = annotationView2.topRightButton;
            ControlButton controlButton2 = annotationView2.bottomRightButton;
            ControlButton controlButton3 = annotationView2.bottomLeftButton;
            ControlButton[] controlButtonArray = new ControlButton[4];
            ControlButton[] controlButtonArray2 = controlButtonArray;
            controlButtonArray[0] = controlButton;
            controlButtonArray[1] = object;
            controlButtonArray[2] = controlButton2;
            controlButtonArray[3] = controlButton3;
            ((MarkUpDrawable)object2).drawControlButtons(canvas, controlButtonArray2);
        }
        if (!((AbstractMap)this.paths).isEmpty()) {
            Iterator<Map.Entry<Path, Integer>> iterator = this.paths.entrySet().iterator();
            do {
                Map.Entry<Path, Integer> entry = iterator.next();
                this.pathPaint.setColor(entry.getValue().intValue());
                object = entry.getKey();
                canvas.drawPath((Path)object, this.pathPaint);
            } while (iterator.hasNext());
        }
        if (this.orientationChanged && object2 != null) {
            this.orientationChanged = false;
            if (!((MarkUpDrawable)object2).shape.isRecognized()) {
                this.recognizeShape(((MarkUpDrawable)object2).bounds);
            }
        }
    }

    public synchronized boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.gestureDetector.onTouchEvent(motionEvent)) {
            return true;
        }
        int n = motionEvent.getActionMasked();
        MotionEvent motionEvent2 = motionEvent;
        float f = motionEvent2.getX();
        float f2 = motionEvent2.getY();
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    this.handleActionMode(motionEvent);
                    this.updateCroppedMarkUpDrawableBackground();
                    this.invalidate();
                }
            } else {
                this.isTouching = false;
                MarkUpStack markUpStack = this.currentMarkUpStack;
                MarkUpDrawable markUpDrawable = selectedMarkUpDrawable;
                if ((this.actionMode == ActionMode.DRAG || this.actionMode == ActionMode.RESIZE_BY_TOP_LEFT_BUTTON || this.actionMode == ActionMode.RESIZE_BY_TOP_RIGHT_BUTTON || this.actionMode == ActionMode.RESIZE_BY_BOTTOM_RIGHT_BUTTON || this.actionMode == ActionMode.RESIZE_BY_BOTTOM_LEFT_BUTTON) && markUpDrawable != null && markUpStack != null) {
                    markUpStack.onStateChangedMarkUpDrawable(selectedMarkUpDrawable);
                    markUpDrawable.onActionUp();
                }
                this.touchedPoint.set(f, f2);
                if (this.drawingMode != DrawingMode.DRAW_PATH) {
                    this.actionMode = ActionMode.NONE;
                    this.invalidate();
                }
            }
        } else {
            this.isTouching = true;
            this.getOriginalBitmap();
            Object object = this.onActionDownListener;
            if (object != null) {
                object.onActionDown();
            }
            this.touchedPoint.set(f, f2);
            if (this.bottomRightButton.isTouched(this.touchedPoint) && selectedMarkUpDrawable != null) {
                this.actionMode = ActionMode.RESIZE_BY_BOTTOM_RIGHT_BUTTON;
            } else if (this.bottomLeftButton.isTouched(this.touchedPoint) && selectedMarkUpDrawable != null) {
                this.actionMode = ActionMode.RESIZE_BY_BOTTOM_LEFT_BUTTON;
            } else if (this.topLeftButton.isTouched(this.touchedPoint) && selectedMarkUpDrawable != null) {
                this.actionMode = ActionMode.RESIZE_BY_TOP_LEFT_BUTTON;
            } else if (this.topRightButton.isTouched(this.touchedPoint) && selectedMarkUpDrawable != null) {
                this.actionMode = ActionMode.RESIZE_BY_TOP_RIGHT_BUTTON;
            } else {
                selectedMarkUpDrawable = this.getSelectedMarkUpDrawable();
                object = this.currentMarkUpStack;
                if (selectedMarkUpDrawable == null && object != null) {
                    int n2 = 1.$SwitchMap$com$instabug$chat$annotation$AnnotationView$DrawingMode[this.drawingMode.ordinal()];
                    if (n2 != 1) {
                        if (n2 != 2) {
                            if (n2 == 3) {
                                PoolProvider.postOrderedIOTask((String)"IBG-ANNOTATION-TASK", () -> this.lambda$onTouchEvent$2((MarkUpStack)object));
                            }
                        } else {
                            PoolProvider.postOrderedIOTask((String)"IBG-ANNOTATION-TASK", () -> this.lambda$onTouchEvent$1((MarkUpStack)object));
                        }
                    } else {
                        PoolProvider.postOrderedIOTask((String)"IBG-ANNOTATION-TASK", () -> this.lambda$onTouchEvent$0((MarkUpStack)object));
                    }
                    this.actionMode = ActionMode.DRAW;
                } else {
                    this.actionMode = ActionMode.DRAG;
                }
            }
            this.updateCroppedMarkUpDrawableBackground();
            this.invalidate();
        }
        if (this.actionMode != ActionMode.RESIZE_BY_TOP_LEFT_BUTTON && this.actionMode != ActionMode.RESIZE_BY_TOP_RIGHT_BUTTON && this.actionMode != ActionMode.RESIZE_BY_BOTTOM_RIGHT_BUTTON && this.actionMode != ActionMode.RESIZE_BY_BOTTOM_LEFT_BUTTON && this.actionMode != ActionMode.DRAG && this.actionMode == ActionMode.DRAW && this.drawingMode == DrawingMode.DRAW_PATH) {
            int n3 = motionEvent.getAction();
            if (n3 != 0) {
                if (n3 != 1) {
                    if (n3 == 2) {
                        this.moved = true;
                        this.touch_move(f, f2);
                        this.invalidate();
                    }
                } else {
                    this.touch_up();
                    if (!this.moved) {
                        this.performClick();
                    }
                    this.invalidate();
                }
            } else {
                this.moved = false;
                this.touch_start(f, f2);
            }
        }
        return true;
    }

    public void addMarkUp(Shape shape) {
        DirectionRectF directionRectF;
        AnnotationView annotationView = this;
        int n = Math.min(annotationView.getWidth(), this.getHeight()) / 2;
        int n2 = (annotationView.getWidth() - n) / 2;
        int n3 = (annotationView.getHeight() - n) / 2;
        DirectionRectF directionRectF2 = directionRectF;
        float f = n2;
        float f2 = n3 - 30;
        float f3 = n + n2;
        float f4 = n + n3 + 30;
        directionRectF = new DirectionRectF(f, f2, f3, f4);
        this.addMarkUp(shape, directionRectF2, Level.HIGH);
    }

    public void addMagnifier() {
        if (((AnnotationView)((Object)this)).magnifiersCount < 5) {
            AnnotationView annotationView = this;
            annotationView.addMarkUp(new ZoomedShape(((AnnotationView)((Object)this)).getScaledBitmap()));
            ++annotationView.magnifiersCount;
        }
        if (((AnnotationView)((Object)this)).magnifiersCount == 5 && (this = ((AnnotationView)((Object)this)).onNewMagnifierAddingAbilityChangedListener) != null) {
            this.onAbilityChanged(false);
        }
    }

    public void setScreenshot(@Nullable Drawable drawable2) {
        this.screenshot = drawable2;
    }

    @Nullable
    public Bitmap toBitmap() {
        if (this.getWidth() > 0 && this.getHeight() > 0 && this.currentMarkUpStack != null) {
            AnnotationView annotationView = this;
            return annotationView.toBitmap(annotationView.currentMarkUpStack.size());
        }
        return null;
    }

    public void setDrawingMode(DrawingMode drawingMode) {
        this.drawingMode = drawingMode;
    }

    public DrawingMode getDrawingMode() {
        return this.drawingMode;
    }

    public void undo() {
        if (this.currentMarkUpStack != null) {
            MarkUpDrawable markUpDrawable = this.currentMarkUpStack.undo();
            if (markUpDrawable != null && markUpDrawable.getShape() instanceof ZoomedShape) {
                AnnotationView annotationView = this;
                --annotationView.magnifiersCount;
                annotationView.checkNewMagnifierAddingAbility();
            }
            AnnotationView annotationView = this;
            AnnotationView.setSelectedMarkUpDrawable(null);
            annotationView.updateCroppedMarkUpDrawableBackground();
            annotationView.invalidate();
        }
    }

    public void setOnActionDownListener(@Nullable OnActionDownListener onActionDownListener) {
        this.onActionDownListener = onActionDownListener;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle2.putParcelable("superState", super.onSaveInstanceState());
        bundle2.putSerializable("aspectRatioCalculator", (Serializable)this.aspectRatioCalculator);
        bundle2.putSerializable("drawingMode", (Serializable)this.getDrawingMode());
        bundle2.putInt("drawingLevel", this.drawingLevel);
        bundle.putInt("magnifiersCount", this.magnifiersCount);
        return bundle;
    }

    public void setOnNewMagnifierAddingAbilityChangedListener(OnNewMagnifierAddingAbilityChangedListener onNewMagnifierAddingAbilityChangedListener) {
        this.onNewMagnifierAddingAbilityChangedListener = onNewMagnifierAddingAbilityChangedListener;
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            parcelable = (Bundle)parcelable;
            this.aspectRatioCalculator = (AspectRatioCalculator)parcelable.getSerializable("aspectRatioCalculator");
            this.drawingLevel = parcelable.getInt("drawingLevel");
            this.magnifiersCount = parcelable.getInt("magnifiersCount");
            this.drawingMode = (DrawingMode)parcelable.getSerializable("drawingMode");
            parcelable = parcelable.getParcelable("superState");
        }
        if (parcelable != null) {
            super.onRestoreInstanceState(parcelable);
        }
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.scaledBitmap = null;
        this.orientationChanged = true;
    }

    public void setOnPathRecognizedListener(@Nullable OnPathRecognizedListener onPathRecognizedListener) {
        this.onPathRecognizedListener = onPathRecognizedListener;
    }

    protected synchronized void onDetachedFromWindow() {
        AnnotationView annotationView = this;
        super.onDetachedFromWindow();
        annotationView.currentMarkUpStack = null;
        selectedMarkUpDrawable = null;
        OrientationUtils.unlockOrientation((Context)annotationView.getContext());
    }

    private static enum ActionMode {
        NONE,
        DRAG,
        RESIZE_BY_TOP_LEFT_BUTTON,
        RESIZE_BY_TOP_RIGHT_BUTTON,
        RESIZE_BY_BOTTOM_RIGHT_BUTTON,
        RESIZE_BY_BOTTOM_LEFT_BUTTON,
        DRAW;

    }

    public static enum DrawingMode implements Serializable
    {
        NONE,
        DRAW_PATH,
        DRAW_RECT,
        DRAW_CIRCLE,
        DRAW_BLUR,
        DRAW_ZOOM;

    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDoubleTap(MotionEvent object) {
            object = AnnotationView.this.currentMarkUpStack;
            MarkUpDrawable markUpDrawable = selectedMarkUpDrawable;
            if (markUpDrawable != null && object != null) {
                MarkUpDrawable markUpDrawable2 = markUpDrawable;
                ((MarkUpStack)object).onStateChangedMarkUpDrawable(selectedMarkUpDrawable);
                markUpDrawable2.setVisibility(false);
                if (markUpDrawable2.getShape() instanceof ZoomedShape) {
                    AnnotationView annotationView = AnnotationView.this;
                    --annotationView.magnifiersCount;
                    annotationView.checkNewMagnifierAddingAbility();
                }
                GestureListener gestureListener = this;
                selectedMarkUpDrawable = null;
                gestureListener.AnnotationView.this.updateCroppedMarkUpDrawableBackground();
                gestureListener.AnnotationView.this.invalidate();
            }
            return true;
        }
    }

    public static interface OnActionDownListener {
        public void onActionDown();
    }

    static enum Level {
        HIGH,
        LOW;

    }

    public static interface OnNewMagnifierAddingAbilityChangedListener {
        public void onAbilityChanged(boolean var1);
    }

    public static interface OnPathRecognizedListener {
        public void onPathRecognized(Path var1, Path var2);
    }
}

