/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat;

import android.os.Bundle;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.chat.ChatsDelegate;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.notification.NotificationManager;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import java.util.Map;

public abstract class RepliesWrapper {
    public static void show() {
        if (RepliesWrapper.isReadyToRun() && ChatsCacheManager.getValidChats().size() > 0) {
            ChatsDelegate.showChats();
        }
    }

    public static boolean hasChats() {
        return ChatsCacheManager.getValidChats().size() > 0;
    }

    public static void setRepliesState(Feature.State state) {
        Feature.State state2 = state;
        InstabugCore.setRepliesState((Feature.State)state2);
        InstabugCore.setPushNotificationState((Feature.State)state2);
    }

    public static void setNewMessageHandler(Runnable runnable) {
        if (RepliesWrapper.isReadyToRun()) {
            ChatsDelegate.setNewMessageHandler(runnable);
        }
    }

    public static void enableNotification(boolean bl) {
        if (RepliesWrapper.isReadyToRun()) {
            ChatsDelegate.enableNotification(bl);
        }
    }

    public static int getUnreadMessagesCount() {
        return ChatsDelegate.getUnreadMessagesCount();
    }

    public static void setPushNotificationRegistrationToken(String string2) {
        if (RepliesWrapper.isReadyToRun()) {
            ChatsDelegate.setPushNotificationRegistrationToken(string2);
        }
    }

    public static void showNotification(Bundle bundle) {
        if (RepliesWrapper.isMessagingServiceAvailable()) {
            ChatsDelegate.showNotification(bundle);
        }
    }

    public static void showNotification(Map<String, String> map) {
        if (RepliesWrapper.isMessagingServiceAvailable()) {
            ChatsDelegate.showNotification(map);
        }
    }

    public static void enableInAppNotificationSound(boolean bl) {
        if (RepliesWrapper.isReadyToRun()) {
            ChatsDelegate.enableInAppNotificationSound(bl);
        }
    }

    public static void setNotificationIcon(int n) {
        if (RepliesWrapper.isReadyToRun()) {
            ChatSettings.setNotificationIcon(n);
        }
    }

    public static boolean isInstabugNotification(Bundle bundle) {
        return NotificationManager.getInstance().isInstabugNotification(bundle);
    }

    public static boolean isInstabugNotification(Map<String, String> map) {
        return NotificationManager.getInstance().isInstabugNotification(map);
    }

    public static void enableSystemNotificationSound(boolean bl) {
        if (RepliesWrapper.isReadyToRun()) {
            ChatSettings.enableSystemNotificationSound(bl);
        }
    }

    public static void setPushNotificationChannelId(String string2) {
        if (RepliesWrapper.isReadyToRun()) {
            ChatSettings.setPushNotificationChannelId(string2);
        }
    }

    public static void enableConversationSound(boolean bl) {
        if (RepliesWrapper.isReadyToRun()) {
            ChatSettings.enableConversationSound(bl);
        }
    }

    private static boolean isReadyToRun() {
        return InstabugCore.isFeatureEnabled((String)"REPLIES") && !RepliesWrapper.isInForegroundWithNoSessionRunning();
    }

    public static void setState(Feature.State state) {
        RepliesWrapper.setRepliesState(state);
        InvocationManager.getInstance().notifyInvocationOptionChanged();
    }

    public static boolean isMessagingServiceAvailable() {
        return InstabugCore.isFeatureEnabled((String)"IN_APP_MESSAGING") && InstabugCore.isFeatureEnabled((String)"REPLIES");
    }

    private static boolean isInForegroundWithNoSessionRunning() {
        return InstabugCore.isAppOnForeground() && InstabugCore.getRunningSession() == null;
    }
}

