/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.floatingactionbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.instabug.bug.view.floatingactionbutton.FloatingActionButton;
import com.instabug.library.R;

public abstract class RecordingFloatingActionButton
extends FloatingActionButton {
    @Nullable
    private RecordingState recordingState;
    @Nullable
    private Paint textPaint;
    @Nullable
    private String text;
    private float strokeWidth;

    public RecordingFloatingActionButton(Context context) {
        this(context, null);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public RecordingFloatingActionButton(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    void init(Context context, @Nullable AttributeSet attributeSet) {
        RecordingFloatingActionButton recordingFloatingActionButton = this;
        RecordingFloatingActionButton recordingFloatingActionButton2 = this;
        super.init(context, attributeSet);
        this.textPaint = new Paint(1);
        this.textPaint.setColor(-1);
        recordingFloatingActionButton2.textPaint.setTextAlign(Paint.Align.CENTER);
        recordingFloatingActionButton2.textPaint.setTextSize(context.getResources().getDimension(R.dimen.instabug_fab_text_size));
        recordingFloatingActionButton2.strokeWidth = recordingFloatingActionButton2.getDimension(R.dimen.instabug_fab_circle_icon_stroke);
        recordingFloatingActionButton.setTypeface(ResourcesCompat.getFont((Context)context, (int)R.font.ibg_video_icon));
        recordingFloatingActionButton.setText("\ue900", false);
        recordingFloatingActionButton.setTextColor(-1);
        recordingFloatingActionButton.setGravity(17);
    }

    @Override
    Drawable getIconDrawable() {
        Shape shape;
        float f;
        float f2;
        if (this.getSize() == 0) {
            RecordingFloatingActionButton recordingFloatingActionButton = this;
            f2 = recordingFloatingActionButton.getDimension(R.dimen.instabug_fab_size_normal);
            f = recordingFloatingActionButton.getDimension(R.dimen.instabug_fab_icon_size_normal);
        } else {
            RecordingFloatingActionButton recordingFloatingActionButton = this;
            f2 = recordingFloatingActionButton.getDimension(R.dimen.instabug_fab_size_mini);
            f = recordingFloatingActionButton.getDimension(R.dimen.instabug_fab_icon_size_mini);
        }
        final float f3 = f / 2.0f;
        final float f4 = this.getDimension(R.dimen.instabug_fab_circle_icon_stroke);
        Shape shape2 = shape;
        shape = new Shape(){

            public void draw(Canvas canvas, Paint paint) {
                Paint paint2 = paint;
                paint2.setColor(-65536);
                paint2.setStyle(Paint.Style.FILL_AND_STROKE);
                paint.setStrokeWidth(f4);
                float f = f3;
                canvas.drawCircle(f, f, f2 / 2.0f, paint);
                if (RecordingFloatingActionButton.this.recordingState == RecordingState.RECORDING) {
                    RecordingFloatingActionButton.this.setText(null, false);
                } else {
                    RecordingFloatingActionButton.this.setText("\ue900", false);
                }
            }
        };
        ShapeDrawable shapeDrawable = new ShapeDrawable(shape2);
        shapeDrawable.getPaint().setAntiAlias(true);
        return shapeDrawable;
    }

    protected void onDraw(Canvas canvas) {
        RecordingFloatingActionButton recordingFloatingActionButton = object;
        super.onDraw(canvas);
        if (recordingFloatingActionButton.text != null && object.textPaint != null) {
            RecordingFloatingActionButton recordingFloatingActionButton2 = object;
            Canvas canvas2 = canvas;
            int n = canvas2.getWidth() / 2;
            Object object = object.text;
            float f = n;
            float f2 = (int)((float)canvas2.getHeight() / 2.0f - (object.textPaint.descent() + object.textPaint.ascent()) / 2.0f - object.strokeWidth);
            Paint paint = recordingFloatingActionButton2.textPaint;
            canvas.drawText((String)object, f, f2, paint);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setText(@Nullable String string2, boolean bl) {
        if (bl) {
            this.text = string2;
            this.invalidate();
        } else {
            super.setText((CharSequence)string2);
        }
    }

    public void setRecordingState(RecordingState recordingState) {
        this.recordingState = recordingState;
        this.updateBackground();
    }

    public static enum RecordingState {
        RECORDING,
        STOPPED;

    }
}

