/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.extrafields;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.R;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.ExtraReportField;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.InstabugThanksActivity;
import com.instabug.bug.view.extrafields.ExtraFieldsContract$View;
import com.instabug.bug.view.extrafields.ExtraFieldsPresenter;
import com.instabug.bug.view.reporting.ReportingContainerActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.KeyboardUtils;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.SimpleTextWatcher;
import com.instabug.library.util.ThemeApplier;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Locale;

public class ExtraFieldsFragment
extends InstabugBaseFragment<ExtraFieldsPresenter>
implements ExtraFieldsContract$View {
    @Nullable
    @VisibleForTesting
    String title;
    @Nullable
    List<ExtraReportField> extraReportFields;
    @Nullable
    private LinearLayout itemsLinearLayout;
    private long lastClickTime;
    private boolean isCommittingBug;
    @Nullable
    private BugReportingActivityCallback activityCallback;
    private String currentTitle = "";

    public static ExtraFieldsFragment newInstance(@Nullable String string2) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("title", string2);
        ExtraFieldsFragment extraFieldsFragment = new ExtraFieldsFragment();
        extraFieldsFragment.setArguments(bundle2);
        return extraFieldsFragment;
    }

    private void handleExtraFields() {
        Object object = this.presenter;
        if (object != null) {
            if ((object = ((ExtraFieldsPresenter)((Object)object)).getExtraReportFields()) != null && this.getContext() != null) {
                this.itemsLinearLayout = (LinearLayout)this.findViewById(R.id.linearLayout);
                for (int i = 0; i < object.size(); ++i) {
                    Object object2;
                    InstabugEditTextViewholder instabugEditTextViewholder;
                    int n = R.layout.ibg_bug_item_edittext;
                    LinearLayout linearLayout = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(n, (ViewGroup)this.itemsLinearLayout, false);
                    linearLayout.setId(i);
                    InstabugEditTextViewholder instabugEditTextViewholder2 = instabugEditTextViewholder;
                    if (new InstabugEditTextViewholder((View)linearLayout).getEditText() != null) {
                        CharSequence charSequence;
                        object2 = instabugEditTextViewholder2.getEditText();
                        if (((ExtraReportField)object.get(i)).isRequired()) {
                            StringBuilder stringBuilder;
                            charSequence = stringBuilder;
                            charSequence();
                            charSequence = stringBuilder.append((Object)((ExtraReportField)object.get(i)).getHint()).append(" *").toString();
                        } else {
                            charSequence = ((ExtraReportField)object.get(i)).getHint();
                        }
                        object2.setHint(charSequence);
                        if (((ExtraReportField)object.get(i)).getValue() != null) {
                            instabugEditTextViewholder2.getEditText().setText((CharSequence)((ExtraReportField)object.get(i)).getValue());
                        }
                        InstabugEditTextViewholder instabugEditTextViewholder3 = instabugEditTextViewholder2;
                        instabugEditTextViewholder3.getEditText().setId(i);
                        instabugEditTextViewholder3.getEditText().addTextChangedListener((TextWatcher)new CustomTextSwitcher(instabugEditTextViewholder2.getEditText()));
                        instabugEditTextViewholder3.getEditText().setImeOptions(6);
                        if (AccessibilityUtils.isTalkbackEnabled() && (object2 = instabugEditTextViewholder2.getEditText()) != null) {
                            AccessibilityDelegateCompat accessibilityDelegateCompat;
                            LinearLayout linearLayout2 = object2;
                            object2 = accessibilityDelegateCompat;
                            accessibilityDelegateCompat = new AccessibilityDelegateCompat((List)object, i){
                                final /* synthetic */ List val$extraReportFields;
                                final /* synthetic */ int val$finalIndex;
                                {
                                    this.val$extraReportFields = list;
                                    this.val$finalIndex = n;
                                }

                                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                                    1 v0 = extraReportField;
                                    super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                                    ExtraReportField extraReportField = (ExtraReportField)v0.val$extraReportFields.get(extraReportField.val$finalIndex);
                                    if (extraReportField != null && extraReportField.getFieldAccessibilityContentDescription() != null) {
                                        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                                        accessibilityNodeInfoCompat2.setText((CharSequence)extraReportField.getFieldAccessibilityContentDescription());
                                        accessibilityNodeInfoCompat2.setShowingHintText(true);
                                    }
                                }
                            };
                            ViewCompat.setAccessibilityDelegate((View)linearLayout2, (AccessibilityDelegateCompat)object2);
                        }
                    }
                    if ((object2 = this.itemsLinearLayout) != null) {
                        object2.addView((View)linearLayout);
                    }
                    this.applyTheme(instabugEditTextViewholder2);
                }
            }
            this.extraReportFields = object;
        }
    }

    public void onCreate(@Nullable Bundle object) {
        ExtraFieldsPresenter extraFieldsPresenter;
        ExtraFieldsFragment extraFieldsFragment = this;
        super.onCreate((Bundle)object);
        extraFieldsFragment.setHasOptionsMenu(true);
        if (extraFieldsFragment.getActivity() != null) {
            this.getActivity().getWindow().setSoftInputMode(2);
        }
        if (this.getArguments() != null) {
            this.title = this.getArguments().getString("title");
        }
        object = extraFieldsPresenter;
        extraFieldsPresenter = new ExtraFieldsPresenter(this);
        this.presenter = object;
        object = this.activityCallback;
        if (object != null) {
            this.currentTitle = object.getToolbarTitle();
            object = this.title;
            if (object != null) {
                this.activityCallback.setToolbarTitle((String)object);
            }
            this.activityCallback.setToolbarUpIconBack();
        }
    }

    public void onAttach(Context context) {
        ExtraFieldsFragment extraFieldsFragment = this;
        super.onAttach(context);
        if (extraFieldsFragment.getActivity() instanceof BugReportingActivityCallback) {
            try {
                this.activityCallback = (BugReportingActivityCallback)this.getActivity();
            }
            catch (Exception exception) {
                throw new RuntimeException("Must implement BugReportingActivityCallback");
            }
        }
    }

    protected int getLayout() {
        return R.layout.ibg_bug_lyt_extra_fields;
    }

    protected void initViews(View view, @Nullable Bundle bundle) {
        this.handleExtraFields();
    }

    protected void onDoneButtonClicked() {
        Object object = this.presenter;
        if (object != null) {
            if (!((ExtraFieldsPresenter)((Object)object)).validateExtraReportFields()) {
                return;
            }
            object = this.extraReportFields;
            if (object != null) {
                ((ExtraFieldsPresenter)this.presenter).appendExtraReportFieldsToMessage((List<ExtraReportField>)object);
            }
            this.isCommittingBug = true;
            if (this.getContext() != null) {
                LiveBugManager.getInstance().commit();
            } else {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"Couldn't commit the Bug due to Null context");
            }
            this.navigateToSuccessFragment();
        }
    }

    public void onStart() {
        ExtraFieldsFragment extraFieldsFragment = this;
        super.onStart();
        if (extraFieldsFragment.getActivity() instanceof ReportingContainerActivity) {
            ((ReportingContainerActivity)this.getActivity()).setToolbarNavigationContentDescription(R.string.ibg_core_extended_report_ic_close_content_description);
        }
    }

    @VisibleForTesting
    void applyTheme(InstabugEditTextViewholder instabugEditTextViewholder) {
        if (this.theme != null) {
            if (instabugEditTextViewholder != null) {
                ThemeApplier.applyPrimaryTextStyle((TextView)instabugEditTextViewholder.editText, (IBGTheme)this.theme);
                if (this.theme.getSecondaryTextColor() != 0 && instabugEditTextViewholder.editText != null) {
                    instabugEditTextViewholder.editText.setHintTextColor(this.theme.getSecondaryTextColor());
                }
            }
            if ((instabugEditTextViewholder = (LinearLayout)this.rootView.findViewById(R.id.linearLayout)) != null && this.theme.getBackgroundColor() != 0) {
                instabugEditTextViewholder.setBackgroundColor(this.theme.getBackgroundColor());
            }
        }
    }

    @Override
    public void clearError(int n) {
        new InstabugEditTextViewholder(this.findViewById(n)).reset();
    }

    public void navigateToSuccessFragment() {
        Runnable runnable;
        if (this.getActivity() != null) {
            KeyboardUtils.hide((Activity)this.getActivity());
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (BugSettings.getInstance().successDialogEnabled() && !ServiceLocator.getConfigurationsProvider().isBugReportingUsageExceeded()) {
                    2 this_ = this_.ExtraFieldsFragment.this.getActivity();
                    if (this_ != null) {
                        Intent intent;
                        Intent intent2 = intent;
                        intent = new Intent((Context)this_, InstabugThanksActivity.class);
                        this_.startActivityForResult(intent2, 3940);
                    }
                } else {
                    this_.ExtraFieldsFragment.this.finishActivity();
                }
            }
        };
        new Handler().postDelayed(runnable2, 200L);
    }

    @Override
    public void focusAndSetError(int n) {
        List<ExtraReportField> list = this.extraReportFields;
        if (list != null) {
            InstabugEditTextViewholder instabugEditTextViewholder;
            int n2 = R.string.instabug_err_invalid_extra_field;
            Object object = list.get(n).getHint();
            Object[] objectArray = new Object[1];
            Object object2 = objectArray;
            objectArray[0] = object;
            object2 = this.getLocalizedString(n2, (Object[])object2);
            object = instabugEditTextViewholder;
            if (new InstabugEditTextViewholder(this.findViewById(n)).getEditText() != null) {
                ((InstabugEditTextViewholder)((Object)object)).getEditText().requestFocus();
            }
            ((InstabugEditTextViewholder)((Object)object)).setError((String)object2);
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        Menu menu3 = menu2;
        menuInflater.inflate(R.menu.ibg_bug_menu_extended_reporting, menu2);
        menuInflater = menu3.findItem(R.id.instabug_bugreporting_send);
        MenuItem menuItem = menu3.findItem(R.id.instabug_bugreporting_next);
        if (menuItem != null) {
            menuItem.setVisible(false);
        }
        if (menuInflater != null) {
            menuInflater.setVisible(true);
            menuInflater.setTitle((CharSequence)this.getLocalizedString(R.string.ibg_report_send_content_description));
        }
        if (this.getContext() != null && LocaleUtils.isRTL((Locale)InstabugCore.getLocale((Context)this.getContext())) && (this = menu2.findItem(R.id.instabug_bugreporting_send)) != null && (this = this.getIcon()) != null) {
            menu2.findItem(R.id.instabug_bugreporting_send).setIcon(DrawableUtils.getRotateDrawable((Drawable)this, (float)180.0f));
        }
    }

    public void onDestroy() {
        BugReportingActivityCallback bugReportingActivityCallback = this.activityCallback;
        if (bugReportingActivityCallback != null) {
            bugReportingActivityCallback.setToolbarUpIconClose();
            this.activityCallback.setToolbarTitle(this.currentTitle);
        }
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (this.isCommittingBug) {
            return false;
        }
        if (SystemClock.elapsedRealtime() - this.lastClickTime < 1000L) {
            return false;
        }
        this.lastClickTime = SystemClock.elapsedRealtime();
        if (menuItem.getItemId() == R.id.instabug_bugreporting_send) {
            this.onDoneButtonClicked();
            return true;
        }
        if (menuItem.getItemId() == 16908332 && this.getActivity() != null) {
            this.getActivity().onBackPressed();
        }
        return false;
    }

    public void onDestroyView() {
        ExtraFieldsFragment extraFieldsFragment = this;
        super.onDestroyView();
        LinearLayout linearLayout = extraFieldsFragment.itemsLinearLayout;
        if (linearLayout != null) {
            linearLayout.clearFocus();
            this.itemsLinearLayout.removeAllViews();
        }
        this.itemsLinearLayout = null;
    }

    static class InstabugEditTextViewholder
    extends RecyclerView.ViewHolder {
        @Nullable
        private EditText editText;
        @Nullable
        private TextView error;
        @Nullable
        private View seperator;
        private int separatorColor = -1;

        public InstabugEditTextViewholder(View view) {
            super(view);
            if (view instanceof LinearLayout) {
                int n;
                view = (LinearLayout)view;
                for (int i = 0; i < view.getChildCount(); ++i) {
                    View view2 = view.getChildAt(i);
                    if (view2 instanceof EditText) {
                        this.editText = (EditText)view2;
                        continue;
                    }
                    if (view2 instanceof TextView) {
                        this.error = (TextView)view2;
                        continue;
                    }
                    this.seperator = view2;
                }
                if (SettingsManager.getInstance().getIBGTheme() != null) {
                    this.separatorColor = SettingsManager.getInstance().getIBGTheme().getSecondaryTextColor();
                }
                if ((n = this.separatorColor) != 0 && (this = this.seperator) != null) {
                    this.setBackgroundColor(n);
                }
            }
        }

        @Nullable
        public EditText getEditText() {
            return this.editText;
        }

        public void setError(String string2) {
            TextView textView = this.error;
            if (textView != null && this.seperator != null) {
                textView.setText((CharSequence)string2);
                this.seperator.setBackgroundColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.instabug_extrafield_error));
            }
        }

        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public void reset() {
            TextView textView = this.error;
            if (textView != null && this.seperator != null) {
                textView.setText(null);
                int n = this.separatorColor;
                if (n != 0) {
                    this.seperator.setBackgroundColor(n);
                } else {
                    this.seperator.setBackgroundColor(AttrResolver.resolveAttributeColor((Context)this.itemView.getContext(), (int)R.attr.ibg_bug_vus_separator_color));
                }
            }
        }
    }

    private class CustomTextSwitcher
    extends SimpleTextWatcher {
        private final WeakReference<EditText> mEditText;

        public CustomTextSwitcher(EditText editText) {
            WeakReference<EditText> weakReference;
            Object object = weakReference;
            weakReference = new WeakReference<EditText>(editText);
            v1.mEditText = object;
        }

        public void afterTextChanged(Editable editable) {
            CustomTextSwitcher customTextSwitcher = this;
            super.afterTextChanged(editable);
            EditText editText = (EditText)customTextSwitcher.mEditText.get();
            if (editText != null && (this = ((CustomTextSwitcher)((Object)this)).ExtraFieldsFragment.this.extraReportFields) != null) {
                ((ExtraReportField)this.get(editText.getId())).setValue(editable.toString());
            }
        }
    }
}

