/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.disclaimer;

import android.net.Uri;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.Bug;
import com.instabug.bug.utils.DisclaimersLinksUtils;
import com.instabug.bug.view.disclaimer.Disclaimer;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import java.util.ArrayList;

public abstract class DisclaimerHelper {
    public static boolean isDisclaimerUri(@Nullable Uri uri) {
        return uri != null && "instabug-bug".equals(uri.getScheme()) && "instabug-disclaimer.com".equals(uri.getHost()) && "/disclaimer".equals(uri.getPath());
    }

    public static ArrayList<Disclaimer> getDisclaimers() {
        ArrayList<Disclaimer> arrayList;
        ArrayList<Disclaimer> arrayList2 = arrayList;
        arrayList = new ArrayList<Disclaimer>();
        Bug bug = LiveBugManager.getInstance().getBug();
        if (bug != null && bug.getState() != null && (bug = bug.getState()) != null) {
            if (bug.getAppPackageName() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("bundle_id", bug.getAppPackageName()), arrayList2);
            }
            if (bug.getAppVersion() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("app_version", bug.getAppVersion()), arrayList2);
            }
            if (bug.getBatteryState() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("BATTERY", bug.getBatteryLevel() + "%, " + bug.getBatteryState()), arrayList2);
            }
            if (bug.getCarrier() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("carrier", bug.getCarrier()), arrayList2);
            }
            if (DisclaimerHelper.isConsoleLogsEnabled()) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("console_log", bug.getConsoleLog().toString()).setLog(true), arrayList2);
            }
            if (bug.getCurrentView() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("current_view", bug.getCurrentView()), arrayList2);
            }
            if (bug.getScreenDensity() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("density", bug.getScreenDensity()), arrayList2);
            }
            if (bug.getDevice() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("device", bug.getDevice()), arrayList2);
            }
            DisclaimerHelper.addDisclaimer(new Disclaimer("device_rooted", String.valueOf(bug.isDeviceRooted())), arrayList2);
            DisclaimerHelper.addDisclaimer(new Disclaimer("duration", String.valueOf(bug.getDuration())), arrayList2);
            if (bug.getUserEmail() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("email", bug.getUserEmail()), arrayList2);
            }
            if (bug.getInstabugLog() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("instabug_log", bug.getInstabugLog()).setLog(true), arrayList2);
            }
            if (bug.getLocale() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("locale", bug.getLocale()), arrayList2);
            }
            DisclaimerHelper.addDisclaimer(new Disclaimer("MEMORY", (float)bug.getUsedMemory() / 1000.0f + "/" + (float)bug.getTotalMemory() / 1000.0f + " GB"), arrayList2);
            if (bug.getNetworkLogs() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("network_log", bug.getNetworkLogs()).setLog(true), arrayList2);
            }
            if (bug.getScreenOrientation() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("orientation", bug.getScreenOrientation()), arrayList2);
            }
            if (bug.getOS() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("os", bug.getOS()), arrayList2);
            }
            DisclaimerHelper.addDisclaimer(new Disclaimer("reported_at", String.valueOf(bug.getReportedAt())), arrayList2);
            if (bug.getScreenSize() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("screen_size", bug.getScreenSize()), arrayList2);
            }
            if (bug.getSdkVersion() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("sdk_version", bug.getSdkVersion()), arrayList2);
            }
            DisclaimerHelper.addDisclaimer(new Disclaimer("STORAGE", (float)bug.getUsedStorage() / 1000.0f + "/" + (float)bug.getTotalStorage() / 1000.0f + " GB"), arrayList2);
            if (bug.getUserAttributes() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("user_attributes", bug.getUserAttributes()).setLog(true), arrayList2);
            }
            if (bug.getUserData() != null) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("user_data", bug.getUserData()).setLog(true), arrayList2);
            }
            if (DisclaimerHelper.isUserTrackingStepsEnabled()) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("user_steps", bug.getUserSteps().toString()).setLog(true), arrayList2);
            }
            if (ServiceLocator.getConfigurationsProvider().isReproStepsEnabled()) {
                DisclaimerHelper.addDisclaimer(new Disclaimer("user_repro_steps", bug.getVisualUserSteps()).setLog(true), arrayList2);
            }
            DisclaimerHelper.addDisclaimer(new Disclaimer("wifi_state", String.valueOf(bug.isWifiEnable())), arrayList2);
        }
        return arrayList2;
    }

    @VisibleForTesting
    static void addDisclaimer(Disclaimer disclaimer, ArrayList<Disclaimer> arrayList) {
        if (!(disclaimer.getValue() == null || disclaimer.getValue().isEmpty() || disclaimer.getValue().equals("{}") || disclaimer.getValue().equals("[]"))) {
            Disclaimer disclaimer2 = disclaimer;
            disclaimer2.setKey(disclaimer2.getKey().toUpperCase().replace('_', ' '));
            arrayList.add(disclaimer2);
        }
    }

    private static boolean isUserTrackingStepsEnabled() {
        return InstabugCore.getFeatureState((String)"TRACK_USER_STEPS") == Feature.State.ENABLED;
    }

    private static boolean isConsoleLogsEnabled() {
        return InstabugCore.getFeatureState((String)"CONSOLE_LOGS") == Feature.State.ENABLED;
    }

    public static Spanned getSpannedDisclaimer(String string2) {
        string2 = DisclaimerHelper.convertToHTML(string2);
        return Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)string2, (int)0) : Html.fromHtml((String)string2);
    }

    private static String convertToHTML(String string2) {
        return DisclaimersLinksUtils.convertToHTML(string2, "#metadata-screen", "instabug-bug://instabug-disclaimer.com/disclaimer");
    }
}

