/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.disclaimer;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.Nullable;
import com.instabug.bug.R;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.disclaimer.Disclaimer;
import com.instabug.bug.view.disclaimer.DisclaimerHelper;
import com.instabug.bug.view.disclaimer.DisclaimerListAdapter;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.SystemServiceUtils;

public class DisclaimerFragment
extends InstabugBaseFragment {
    @Nullable
    BugReportingActivityCallback activityCallback;
    @Nullable
    DisclaimerListAdapter disclaimerListAdapter;
    @Nullable
    ListView listView;
    @Nullable
    Callbacks listener;
    CharSequence currentTitle = "";

    public static DisclaimerFragment newInstance() {
        return new DisclaimerFragment();
    }

    private void openDisclaimerDetails(Disclaimer disclaimer) {
        Callbacks callbacks = ((DisclaimerFragment)((Object)callbacks)).listener;
        if (callbacks != null) {
            callbacks.openDisclaimerDetails(disclaimer);
        }
    }

    public void onAttach(Context context) {
        DisclaimerFragment disclaimerFragment = this;
        super.onAttach(context);
        if (disclaimerFragment.getActivity() instanceof BugReportingActivityCallback) {
            try {
                this.listener = (Callbacks)context;
                this.activityCallback = (BugReportingActivityCallback)this.getContext();
            }
            catch (ClassCastException classCastException) {
                throw new ClassCastException(context.toString() + " must implement DisclaimerFragment.Callbacks");
            }
        }
    }

    public void onCreate(@Nullable Bundle bundle) {
        DisclaimerFragment disclaimerFragment = this;
        super.onCreate(bundle);
        disclaimerFragment.setHasOptionsMenu(true);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        menu2.clear();
        super.onCreateOptionsMenu(menu2, menuInflater);
    }

    public void onDetach() {
        super.onDetach();
        this.activityCallback = null;
    }

    protected int getLayout() {
        return R.layout.instabug_lyt_disclaimer;
    }

    protected void initViews(View object, @Nullable Bundle object2) {
        if (this.getActivity() != null) {
            SystemServiceUtils.hideInputMethod((Activity)this.getActivity());
        }
        if (this.getContext() != null) {
            DisclaimerListAdapter disclaimerListAdapter;
            object = disclaimerListAdapter;
            disclaimerListAdapter = new DisclaimerListAdapter(this.getContext(), DisclaimerHelper.getDisclaimers());
            this.disclaimerListAdapter = object;
        }
        object = (ListView)this.findViewById(R.id.instabug_disclaimer_list);
        this.listView = object;
        if (object != null && (object2 = this.disclaimerListAdapter) != null) {
            object.setAdapter((ListAdapter)object2);
            this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> object, View view, int n, long l) {
                    object = DisclaimerFragment.this.disclaimerListAdapter;
                    if (object != null && (object = object.getItem(n)).isLog()) {
                        DisclaimerFragment.this.openDisclaimerDetails((Disclaimer)object);
                    }
                }
            });
        }
        if ((object = this.activityCallback) != null) {
            this.currentTitle = object.getToolbarTitle();
            this.activityCallback.setToolbarTitle(this.getLocalizedString(R.string.ib_str_report_data));
        }
    }

    public void onDestroy() {
        DisclaimerFragment disclaimerFragment = this;
        super.onDestroy();
        BugReportingActivityCallback bugReportingActivityCallback = disclaimerFragment.activityCallback;
        if (bugReportingActivityCallback != null) {
            bugReportingActivityCallback.setToolbarTitle(String.valueOf(this.currentTitle));
        }
    }

    public static interface Callbacks {
        public void openDisclaimerDetails(Disclaimer var1);
    }
}

