/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.annotation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.instabug.bug.R;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.annotation.AnnotationContract$View;
import com.instabug.bug.view.annotation.AnnotationPresenter;
import com.instabug.bug.view.reporting.ReportingContainerActivity;
import com.instabug.chat.annotation.AnnotationLayout;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.BitmapUtils;
import java.io.File;

public class BugAnnotationFragment
extends InstabugBaseFragment<AnnotationPresenter>
implements AnnotationContract$View {
    @Nullable
    private String title;
    private String currentTitle = "";
    @Nullable
    private Uri imageUri;
    @Nullable
    private AnnotationLayout mAnnotationLayout;
    @Nullable
    private Callbacks listener;
    @Nullable
    private BugReportingActivityCallback activityCallback;
    @Nullable
    private Bitmap bitmap;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static BugAnnotationFragment newInstance(String string2, Uri uri, @Nullable String string3) {
        Bundle bundle;
        BugAnnotationFragment bugAnnotationFragment = new BugAnnotationFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString("title", string2);
        bundle2.putParcelable("image_uri", (Parcelable)uri);
        bundle2.putString("name", string3);
        bugAnnotationFragment.setArguments(bundle2);
        return bugAnnotationFragment;
    }

    private static void setActionContainerBackground(View view) {
        if ((view = (LinearLayout)view.findViewById(R.id.instabug_annotation_actions_container)) != null) {
            view.setBackgroundColor(0);
        }
    }

    public void onCreate(@Nullable Bundle object) {
        AnnotationPresenter annotationPresenter;
        this.postponeEnterTransition();
        super.onCreate(object);
        this.setHasOptionsMenu(true);
        if (this.getArguments() != null) {
            this.title = this.getArguments().getString("title");
            this.imageUri = (Uri)this.getArguments().getParcelable("image_uri");
        }
        if ((object = this.activityCallback) != null) {
            this.currentTitle = object.getToolbarTitle();
            object = this.title;
            if (object != null) {
                this.activityCallback.setToolbarTitle((String)object);
            }
            this.activityCallback.setToolbarUpIconClose();
        }
        object = annotationPresenter;
        annotationPresenter = new AnnotationPresenter(this);
        this.presenter = object;
        if (this.getActivity() != null && (object = this.imageUri) != null && object.getPath() != null) {
            BitmapUtils.compressBitmapAndSave((Context)this.getActivity(), (File)new File(this.imageUri.getPath()));
            this.bitmap = BitmapUtils.getBitmapFromUri((Uri)this.imageUri);
        }
    }

    protected int getLayout() {
        return R.layout.ibg_bug_fragment_annotation;
    }

    protected void initViews(View view, @Nullable Bundle object) {
        Bitmap bitmap;
        object = (AnnotationLayout)this.findViewById(R.id.annotationLayout);
        if (object != null && this.getArguments() != null && this.getArguments().getString("name") != null && (bitmap = object.findViewById(R.id.instabug_annotation_image)) != null) {
            ViewCompat.setTransitionName((View)bitmap, (String)this.getArguments().getString("name"));
        }
        this.mAnnotationLayout = object;
        object = this.presenter;
        if (object != null && (bitmap = this.bitmap) != null) {
            ((AnnotationPresenter)((Object)object)).loadViewData(bitmap);
        }
        BugAnnotationFragment bugAnnotationFragment = this;
        bugAnnotationFragment.startPostponedEnterTransition();
        object = bugAnnotationFragment.theme;
        if (object != null && object.getBackgroundColor() != 0) {
            View view2 = view;
            view2.setBackgroundColor(this.theme.getBackgroundColor());
            BugAnnotationFragment.setActionContainerBackground(view2);
        }
    }

    public void onAttach(Context context) {
        BugAnnotationFragment bugAnnotationFragment = this;
        super.onAttach(context);
        bugAnnotationFragment.listener = (Callbacks)bugAnnotationFragment.getActivity();
        if (bugAnnotationFragment.getActivity() instanceof BugReportingActivityCallback) {
            try {
                this.activityCallback = (BugReportingActivityCallback)this.getActivity();
            }
            catch (Exception exception) {
                throw new RuntimeException("Must implement AnnotationFragment.Callbacks ");
            }
        }
    }

    public void onStart() {
        BugAnnotationFragment bugAnnotationFragment = this;
        super.onStart();
        if (bugAnnotationFragment.getActivity() instanceof ReportingContainerActivity) {
            ((ReportingContainerActivity)this.getActivity()).setToolbarNavigationContentDescription(R.string.ibg_core_annotation_ic_close_content_description);
        }
    }

    protected void onDoneButtonClicked() {
        AnnotationLayout annotationLayout;
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            return;
        }
        Callbacks callbacks = this.listener;
        if (callbacks != null && (annotationLayout = this.mAnnotationLayout) != null) {
            if (this.imageUri != null) {
                Callbacks callbacks2 = callbacks;
                callbacks = annotationLayout.getAnnotatedBitmap();
                callbacks2.onImageEditingDone((Bitmap)callbacks, this.imageUri);
            }
            FragmentActivity fragmentActivity2 = fragmentActivity;
            fragmentActivity2.getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
            fragmentActivity2.getSupportFragmentManager().popBackStack("annotation_fragment_for_bug", 1);
        }
    }

    @Override
    public void setAnnotationBitmap(Bitmap bitmap) {
        Object object = object.mAnnotationLayout;
        if (object != null) {
            ((AnnotationLayout)((Object)object)).setBitmap(bitmap);
        }
    }

    @Override
    public void showToastError() {
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        menu2.clear();
        menuInflater.inflate(R.menu.ibg_bug_instabug_bug_annoataion, menu2);
        MenuItem menuItem = menu2.findItem(R.id.instabug_bugreporting_annotaion_done);
        if (menuItem != null) {
            menuItem.setTitle(R.string.ibg_core_annotation_ic_done_content_description);
        }
        super.onCreateOptionsMenu(menu2, menuInflater);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.instabug_bugreporting_annotaion_done) {
            this.onDoneButtonClicked();
            return true;
        }
        if (menuItem.getItemId() == 16908332 && this.getActivity() != null) {
            this.getActivity().onBackPressed();
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void onDestroy() {
        BugReportingActivityCallback bugReportingActivityCallback = this.activityCallback;
        if (bugReportingActivityCallback != null) {
            bugReportingActivityCallback.setToolbarUpIconClose();
            this.activityCallback.setToolbarTitle(this.currentTitle);
        }
        super.onDestroy();
    }

    public static interface Callbacks {
        public void onImageEditingDone(@Nullable Bitmap var1, Uri var2);
    }
}

