/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.instabug.bug.R;
import com.instabug.bug.settings.BugSettings;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.model.Attachment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.KeyboardUtils;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.OnVideoFrameReady;
import com.instabug.library.util.VideoManipulationUtils;
import com.instabug.library.view.IconView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class AttachmentsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    int[] helperImages;
    private List<Attachment> attachmentList;
    @Nullable
    private ColorFilter colorFilter;
    private AttachmentOnClickListener onClickListener;
    @Nullable
    private ProgressBar videoProgressBar;
    @Nullable
    private ImageView videoPlayImageView;
    @Nullable
    private Context context;
    private int lastImgIndex;

    public AttachmentsAdapter(@Nullable Context context, @Nullable ColorFilter colorFilter, AttachmentOnClickListener attachmentOnClickListener) {
        ArrayList arrayList;
        int n;
        int n2;
        int n3;
        AttachmentsAdapter attachmentsAdapter = object;
        int[] nArray = new int[7];
        Object object = nArray;
        nArray[0] = n3 = R.drawable.ibg_bug_ic_edit;
        nArray[1] = n2 = R.drawable.ibg_bug_ic_magnify;
        nArray[2] = n = R.drawable.ibg_bug_ic_blur;
        nArray[3] = n3;
        nArray[4] = n2;
        nArray[5] = n;
        nArray[6] = n3;
        attachmentsAdapter.helperImages = (int[])object;
        attachmentsAdapter.lastImgIndex = -1;
        attachmentsAdapter.context = context;
        attachmentsAdapter.colorFilter = colorFilter;
        attachmentsAdapter.onClickListener = attachmentOnClickListener;
        attachmentsAdapter.setHasStableIds(true);
        object = arrayList;
        arrayList = new ArrayList();
        attachmentsAdapter.attachmentList = object;
    }

    private void bindImageAttachmentView(ImgViewHolder imgViewHolder, @NonNull Attachment object) {
        RelativeLayout relativeLayout;
        Object object2;
        if (object.getLocalPath() != null && imgViewHolder.imageView != null) {
            BitmapUtils.loadBitmap((String)object.getLocalPath(), (ImageView)imgViewHolder.imageView);
        }
        if ((object2 = imgViewHolder.imageView) != null) {
            object2.setTag(object);
            object2 = imgViewHolder.gridItem;
            if (object2 != null) {
                imgViewHolder.imageView.setOnClickListener(this.registerOnClickListener((View)object2, (Attachment)object));
            }
        }
        if ((object2 = imgViewHolder.editIcon) != null && (relativeLayout = imgViewHolder.gridItem) != null) {
            object2.setOnClickListener(this.registerOnClickListener((View)relativeLayout, (Attachment)object));
        }
        if ((object2 = imgViewHolder.gridItem) != null) {
            object2.setOnClickListener(this.registerOnClickListener((View)object2, (Attachment)object));
        }
        if ((object2 = imgViewHolder.removeAttachment) != null) {
            object2.setTag(object);
            IconView iconView = imgViewHolder.removeAttachment;
            iconView.setOnClickListener(this.registerOnClickListener((View)iconView, (Attachment)object));
            imgViewHolder.removeAttachment.setTextColor(SettingsManager.getInstance().getPrimaryColor());
        }
        if (object.getName() != null && (object2 = imgViewHolder.imageView) != null) {
            ViewCompat.setTransitionName((View)object2, (String)object.getName());
        }
        if ((object2 = imgViewHolder.squareLayout) != null) {
            this.setBorder((RelativeLayout)object2);
        }
        if (imgViewHolder.removeAttachment != null && imgViewHolder.removeAttachmentCircleView != null) {
            if (object.getType() == Attachment.Type.MAIN_SCREENSHOT && BugSettings.getInstance().isScreenshotRequired()) {
                imgViewHolder.removeAttachment.setVisibility(8);
                imgViewHolder.removeAttachmentCircleView.setVisibility(8);
            } else {
                imgViewHolder.removeAttachment.setVisibility(0);
                imgViewHolder.removeAttachmentCircleView.setVisibility(0);
            }
        }
        object = this.getImageContentDescription(imgViewHolder.getAdapterPosition());
        object2 = imgViewHolder.imageView;
        if (object2 != null) {
            object2.setContentDescription((CharSequence)object);
        }
        if (AccessibilityUtils.isTalkbackEnabled()) {
            object2 = imgViewHolder.editIcon;
            if (object2 != null) {
                ViewCompat.setImportantForAccessibility((View)object2, (int)2);
            }
            if ((object2 = imgViewHolder.gridItem) != null) {
                ViewCompat.setImportantForAccessibility((View)object2, (int)2);
                imgViewHolder.gridItem.setFocusable(false);
            }
            if ((object2 = imgViewHolder.imageView) != null) {
                AccessibilityDelegateCompat accessibilityDelegateCompat;
                ImageView imageView = object2;
                object2 = accessibilityDelegateCompat;
                accessibilityDelegateCompat = new AccessibilityDelegateCompat((String)object, imgViewHolder){
                    final /* synthetic */ String val$attachmentDescription;
                    final /* synthetic */ ImgViewHolder val$holder;
                    {
                        this.val$attachmentDescription = string2;
                        this.val$holder = imgViewHolder;
                    }

                    public void onInitializeAccessibilityNodeInfo(View view2, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                        1 v1 = this;
                        super.onInitializeAccessibilityNodeInfo(view2, accessibilityNodeInfoCompat);
                        accessibilityNodeInfoCompat2.setContentDescription((CharSequence)v1.val$attachmentDescription);
                        accessibilityNodeInfoCompat2.setRoleDescription((CharSequence)"");
                        view2.setOnFocusChangeListener((view, bl) -> {
                            if (bl) {
                                KeyboardUtils.hide((Activity)((Activity)AttachmentsAdapter.this.context));
                            }
                        });
                        accessibilityNodeInfoCompat.addAction(new AccessibilityNodeInfoCompat.AccessibilityActionCompat(16, (CharSequence)AttachmentsAdapter.this.getLocalizedString(R.string.ibg_bug_report_attachment_edit_content_description, this.val$holder.itemView.getContext())));
                    }
                };
                ViewCompat.setAccessibilityDelegate((View)imageView, (AccessibilityDelegateCompat)object2);
            }
            if (imgViewHolder.removeAttachment != null) {
                imgViewHolder.removeAttachment.setContentDescription((CharSequence)(this.getLocalizedString(R.string.ibg_bug_report_attachment_remove_content_description, imgViewHolder.itemView.getContext()) + " " + (String)object));
                ViewCompat.setAccessibilityDelegate((View)imgViewHolder.removeAttachment, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                    public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                        super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                        accessibilityNodeInfoCompat.setRoleDescription((CharSequence)"Button");
                    }
                });
            }
        }
    }

    private String getImageContentDescription(int n) {
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            if (object.getItemViewType(i) != 0) continue;
            ++n2;
        }
        Object object = n2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        return String.format(Locale.ENGLISH, "Image attachment number %d", objectArray2);
    }

    private void setBorder(RelativeLayout relativeLayout) {
        Context context = this.context;
        if (context != null) {
            Drawable drawable2 = context.getResources().getDrawable(R.drawable.ibg_bug_shape_attachment_border);
            drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(AttrResolver.resolveAttributeColor((Context)this.context, (int)R.attr.ibg_bug_attachment_border_color), PorterDuff.Mode.SRC_IN));
            relativeLayout.setBackgroundDrawable(drawable2);
        }
    }

    private void bindVideoAttachmentView(final VideoViewHolder videoViewHolder, Attachment object) {
        ColorFilter colorFilter;
        Object object2 = videoViewHolder.removeAttachment;
        if (object2 != null) {
            if ((object2 = object2.findViewById(R.id.instabug_btn_remove_attachment)) != null) {
                object2.setTag(object);
                object2.setOnClickListener(this.registerOnClickListener((View)videoViewHolder.removeAttachment, (Attachment)object));
            }
            videoViewHolder.removeAttachment.setTextColor(SettingsManager.getInstance().getPrimaryColor());
        }
        if ((object2 = videoViewHolder.videoPlayImageView) != null && (colorFilter = this.colorFilter) != null) {
            object2.setColorFilter(colorFilter);
        }
        if ((object2 = videoViewHolder.imageView) != null) {
            object2.setTag(object);
            object2 = videoViewHolder.gridItem;
            if (object2 != null) {
                videoViewHolder.imageView.setOnClickListener(this.registerOnClickListener((View)object2, (Attachment)object));
            }
        }
        if ((object2 = videoViewHolder.videoPlayImageView) != null && (colorFilter = videoViewHolder.gridItem) != null) {
            object2.setOnClickListener(this.registerOnClickListener((View)colorFilter, (Attachment)object));
        }
        if ((object2 = videoViewHolder.gridItem) != null) {
            object2.setOnClickListener(this.registerOnClickListener((View)object2, (Attachment)object));
        }
        AttachmentsAdapter attachmentsAdapter = this;
        attachmentsAdapter.videoPlayImageView = videoViewHolder.videoPlayImageView;
        attachmentsAdapter.videoProgressBar = videoViewHolder.videoProgressBar;
        if (object.getLocalPath() != null) {
            InstabugSDKLogger.v((String)"IBG-BR", (String)("Video path found, extracting it's first frame " + object.getLocalPath()));
            VideoManipulationUtils.extractFirstVideoFrame((String)object.getLocalPath(), (OnVideoFrameReady)new OnVideoFrameReady(){

                public void onReady(@Nullable Bitmap bitmap) {
                    if (bitmap != null && (this = videoViewHolder.imageView) != null) {
                        this.setImageBitmap(bitmap);
                    }
                }
            });
        } else {
            InstabugSDKLogger.v((String)"IBG-BR", (String)"Neither video path nor main screenshot found, using white background");
            object = videoViewHolder.imageView;
            if (object != null) {
                object.setImageResource(R.drawable.ibg_core_bg_card);
            }
            if ((object = this.videoProgressBar) != null && object.getVisibility() == 8) {
                this.videoProgressBar.setVisibility(0);
            }
            if ((object = this.videoPlayImageView) != null && object.getVisibility() == 0) {
                this.videoPlayImageView.setVisibility(8);
            }
        }
        object = videoViewHolder.squareLayout;
        if (object != null) {
            this.setBorder((RelativeLayout)object);
        }
        if (AccessibilityUtils.isTalkbackEnabled()) {
            object = this.getVideoContentDescription(videoViewHolder.getAdapterPosition());
            object2 = videoViewHolder.videoPlayImageView;
            if (object2 != null) {
                ViewCompat.setImportantForAccessibility((View)object2, (int)2);
            }
            if ((object2 = videoViewHolder.imageView) != null) {
                AccessibilityDelegateCompat accessibilityDelegateCompat;
                IconView iconView = object2;
                object2 = accessibilityDelegateCompat;
                accessibilityDelegateCompat = new AccessibilityDelegateCompat((String)object, videoViewHolder){
                    final /* synthetic */ String val$attachmentDescription;
                    final /* synthetic */ VideoViewHolder val$holder;
                    {
                        this.val$attachmentDescription = string2;
                        this.val$holder = videoViewHolder;
                    }

                    public void onInitializeAccessibilityNodeInfo(View view2, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                        4 v1 = this;
                        super.onInitializeAccessibilityNodeInfo(view2, accessibilityNodeInfoCompat);
                        accessibilityNodeInfoCompat2.setContentDescription((CharSequence)v1.val$attachmentDescription);
                        accessibilityNodeInfoCompat2.setRoleDescription((CharSequence)"");
                        view2.setOnFocusChangeListener((view, bl) -> {
                            if (bl) {
                                KeyboardUtils.hide((Activity)((Activity)AttachmentsAdapter.this.context));
                            }
                        });
                        accessibilityNodeInfoCompat.addAction(new AccessibilityNodeInfoCompat.AccessibilityActionCompat(16, (CharSequence)this.val$holder.itemView.getContext().getString(R.string.ibg_bug_report_video_play_content_description)));
                    }
                };
                ViewCompat.setAccessibilityDelegate((View)iconView, (AccessibilityDelegateCompat)object2);
            }
            if (videoViewHolder.removeAttachment != null) {
                videoViewHolder.removeAttachment.setContentDescription((CharSequence)(this.getLocalizedString(R.string.ibg_bug_report_attachment_remove_content_description, videoViewHolder.itemView.getContext()) + " " + (String)object));
                ViewCompat.setAccessibilityDelegate((View)videoViewHolder.removeAttachment, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                    public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                        super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                        accessibilityNodeInfoCompat.setRoleDescription((CharSequence)"Button");
                    }
                });
            }
        }
    }

    private String getVideoContentDescription(int n) {
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            if (object.getItemViewType(i) != 1) continue;
            ++n2;
        }
        Object object = n2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        return String.format(Locale.ENGLISH, "Video attachment number %d", objectArray2);
    }

    private View.OnClickListener registerOnClickListener(View view, @NonNull Attachment attachment) {
        return view2 -> this.onClickListener.onAttachmentClicked(view, attachment);
    }

    @NonNull
    public Attachment getItem(int n) {
        return this.attachmentList.get(n);
    }

    public long getItemId(int n) {
        return this.getItem(n).getId();
    }

    public int getItemCount() {
        List<Attachment> list = ((AttachmentsAdapter)((Object)list)).attachmentList;
        return list != null ? list.size() : 0;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int n) {
        if (n != 1) {
            return new ImgViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.ibg_bug_lyt_attachment_image, viewGroup, false));
        }
        return new VideoViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.ibg_bug_lyt_attachment_video, viewGroup, false));
    }

    @SuppressLint(value={"STARVATION"})
    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int n) {
        if (((AttachmentsAdapter)((Object)videoViewHolder)).getItemViewType(n) != 1) {
            AttachmentsAdapter attachmentsAdapter = videoViewHolder;
            viewHolder = (ImgViewHolder)viewHolder;
            attachmentsAdapter.bindImageAttachmentView((ImgViewHolder)viewHolder, attachmentsAdapter.getItem(n));
            int n2 = attachmentsAdapter.lastImgIndex;
            if (n2 != -1 && n == n2 && ((AttachmentsAdapter)((Object)videoViewHolder)).getItem(n).shouldAnimate()) {
                ((AttachmentsAdapter)((Object)videoViewHolder)).animate((ImgViewHolder)viewHolder);
                ((AttachmentsAdapter)((Object)videoViewHolder)).getItem(n).setShouldAnimate(false);
            }
        } else {
            AttachmentsAdapter attachmentsAdapter = videoViewHolder;
            VideoViewHolder videoViewHolder = (VideoViewHolder)viewHolder;
            attachmentsAdapter.bindVideoAttachmentView(videoViewHolder, attachmentsAdapter.getItem(n));
        }
    }

    public int getItemViewType(int n) {
        List<Attachment> list = this.attachmentList;
        if (list != null && list.size() != 0 && this.attachmentList.get(n).getType() != null) {
            switch (6.$SwitchMap$com$instabug$library$model$Attachment$Type[this.attachmentList.get(n).getType().ordinal()]) {
                default: {
                    return 0;
                }
                case 4: 
                case 5: 
                case 6: 
            }
            return 1;
        }
        return super.getItemViewType(n);
    }

    public void animate(ImgViewHolder imgViewHolder) {
        AnimationDrawable animationDrawable;
        AnimationDrawable animationDrawable2 = animationDrawable;
        animationDrawable = new AnimationDrawable();
        int[] nArray = attachmentsAdapter.helperImages;
        int n = attachmentsAdapter.helperImages.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            Context context = attachmentsAdapter.context;
            if (context == null) continue;
            Drawable drawable2 = AppCompatResources.getDrawable((Context)context, (int)n2);
            if (drawable2 != null) {
                animationDrawable2.addFrame(drawable2, 1500);
                continue;
            }
            animationDrawable2.stop();
        }
        AnimationDrawable animationDrawable3 = animationDrawable2;
        animationDrawable3.setEnterFadeDuration(200);
        animationDrawable3.setOneShot(true);
        AttachmentsAdapter attachmentsAdapter = imgViewHolder.editIcon;
        if (attachmentsAdapter != null) {
            attachmentsAdapter.setImageDrawable((Drawable)animationDrawable2);
            imgViewHolder.editIcon.post(() -> animationDrawable2.start());
        }
    }

    @Nullable
    public ProgressBar getVideoProgressBar() {
        return this.videoProgressBar;
    }

    @Nullable
    public ImageView getVideoPlayImageView() {
        return this.videoPlayImageView;
    }

    public void addAttachment(Attachment attachment) {
        this.attachmentList.add(attachment);
    }

    public void clearAttachments() {
        this.attachmentList.clear();
    }

    public void removeAttachment(Attachment attachment) {
        this.attachmentList.remove(attachment);
    }

    public void setLastImageIndex(int n) {
        this.lastImgIndex = n;
    }

    public List<Attachment> getDataset() {
        return this.attachmentList;
    }

    public String getLocalizedString(@StringRes int n, Context context) {
        return LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)context), (int)n, (Context)context);
    }

    public static interface AttachmentOnClickListener {
        public void onAttachmentClicked(View var1, Attachment var2);
    }

    public static class ImgViewHolder
    extends RecyclerView.ViewHolder {
        @Nullable
        RelativeLayout gridItem;
        @Nullable
        RelativeLayout squareLayout;
        @Nullable
        ImageView imageView;
        @Nullable
        ImageView editIcon;
        @Nullable
        IconView removeAttachment;
        @Nullable
        View removeAttachmentCircleView;

        public ImgViewHolder(View view) {
            super(view);
            this.imageView = (ImageView)view.findViewById(R.id.instabug_img_attachment);
            this.editIcon = (ImageView)view.findViewById(R.id.instabug_btn_image_edit_attachment);
            this.gridItem = (RelativeLayout)view.findViewById(R.id.instabug_attachment_img_item);
            this.removeAttachment = (IconView)view.findViewById(R.id.instabug_btn_remove_attachment);
            this.squareLayout = (RelativeLayout)view.findViewById(R.id.instabug_attachemnt_thumb_background);
            this.removeAttachmentCircleView = view.findViewById(R.id.instabug_btn_remove_attachment_circle);
        }
    }

    public static class VideoViewHolder
    extends RecyclerView.ViewHolder {
        @Nullable
        RelativeLayout gridItem;
        @Nullable
        RelativeLayout squareLayout;
        @Nullable
        ProgressBar videoProgressBar;
        @Nullable
        IconView removeAttachment;
        @Nullable
        ImageView videoPlayImageView;
        @Nullable
        ImageView imageView;

        public VideoViewHolder(View view) {
            super(view);
            videoViewHolder.gridItem = (RelativeLayout)view.findViewById(R.id.instabug_attachment_video_item);
            videoViewHolder.imageView = (ImageView)view.findViewById(R.id.instabug_img_video_attachment);
            videoViewHolder.removeAttachment = (IconView)view.findViewById(R.id.instabug_btn_remove_attachment);
            videoViewHolder.videoProgressBar = (ProgressBar)view.findViewById(R.id.instabug_attachment_progress_bar);
            videoViewHolder.videoPlayImageView = (ImageView)view.findViewById(R.id.instabug_btn_video_play_attachment);
            videoViewHolder.squareLayout = (RelativeLayout)view.findViewById(R.id.instabug_attachemnt_thumb_background);
            VideoViewHolder videoViewHolder = videoViewHolder.videoProgressBar;
            if (videoViewHolder != null) {
                videoViewHolder.getIndeterminateDrawable().setColorFilter(InstabugCore.getPrimaryColor(), PorterDuff.Mode.MULTIPLY);
            }
        }
    }
}

