/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.utils;

import android.content.Context;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.Bug;
import com.instabug.bug.testingreport.ReportUploadingStateEventBus;
import com.instabug.bug.utils.BugUtils;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.internal.storage.operation.DeleteUriDiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperationCallback;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\tH\u0002\u001a\f\u0010\u0010\u001a\u00020\t*\u00020\tH\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\tH\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0014"}, d2={"deleteAttachment", "", "attachment", "Lcom/instabug/library/model/Attachment;", "bugId", "", "deleteAttachmentFromDb", "deleteBug", "bug", "Lcom/instabug/bug/model/Bug;", "context", "Landroid/content/Context;", "logAttachmentDeleted", "isDeleted", "", "delete", "deleteAttachments", "deleteBugAndStateFile", "deleteBugFolder", "deleteStateFile", "instabug-bug_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nDeleteBugsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteBugsUtil.kt\ncom/instabug/bug/utils/DeleteBugsUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n766#3:114\n857#3,2:115\n1855#3,2:117\n*S KotlinDebug\n*F\n+ 1 DeleteBugsUtil.kt\ncom/instabug/bug/utils/DeleteBugsUtilKt\n*L\n81#1:114\n81#1:115,2\n82#1:117,2\n*E\n"})
public abstract class DeleteBugsUtilKt {
    public static final void deleteBug(@NotNull Bug bug, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)bug, (String)"bug");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            DeleteBugsUtilKt.deleteBugAndStateFile(DeleteBugsUtilKt.deleteAttachments(bug), context);
        }
        catch (Exception exception) {
            InstabugCore.reportError((Throwable)exception, (String)("couldn't delete Bug " + bug.getId()));
        }
    }

    public static final void deleteBugAndStateFile(@NotNull Bug bug, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)bug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        State state = bug.getState();
        if (state != null && state.getUri() != null) {
            DeleteBugsUtilKt.deleteStateFile(bug, context);
        } else {
            InstabugSDKLogger.i((String)"IBG-BR", (String)"No state file found. deleting the bug");
            DeleteBugsUtilKt.delete(bug);
            ReportUploadingStateEventBus.INSTANCE.post(1);
        }
    }

    public static final void deleteStateFile(@NotNull Bug bug, @NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)bug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        InstabugSDKLogger.v((String)"IBG-BR", (String)("attempting to delete state file for bug with id: " + bug.getId()));
        DiskUtils diskUtils = DiskUtils.with((Context)context2);
        State state = bug.getState();
        Intrinsics.checkNotNull((Object)state);
        diskUtils.deleteOperation((DiskOperation)new DeleteUriDiskOperation(state.getUri())).executeAsync((DiskOperationCallback)new DiskOperationCallback<Boolean>(bug){
            final /* synthetic */ Bug $this_deleteStateFile;
            {
                this.$this_deleteStateFile = bug;
            }

            public void onSuccess(@Nullable Boolean bl) {
                DeleteBugsUtilKt.access$delete(this.$this_deleteStateFile);
                ReportUploadingStateEventBus.INSTANCE.post(1);
            }

            public void onFailure(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"t");
                InstabugSDKLogger.e((String)"IBG-BR", (String)("Deleting attachment file failed due to: " + throwable.getMessage()), (Throwable)throwable);
                ReportUploadingStateEventBus.INSTANCE.post(1);
            }
        });
    }

    private static final void delete(Bug bug) {
        String string2 = bug.getId();
        if (string2 != null) {
            DeleteBugsUtilKt.deleteBugFolder(bug);
            ServiceLocator.getBugReportsDbHelper().delete(string2);
        }
    }

    private static final void deleteBugFolder(Bug object) {
        object = BugUtils.getBugAttachmentFolder(Instabug.getApplicationContext(), ((Bug)object).getId());
        if (object != null) {
            new File((String)object).delete();
        }
    }

    private static final Bug deleteAttachments(Bug bug) {
        ArrayList arrayList = bug.getAttachments();
        if (arrayList != null) {
            ArrayList arrayList2;
            ArrayList arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = new ArrayList();
            for (Object t : arrayList3) {
                if (((Attachment)t).getLocalPath() == null) continue;
                arrayList.add(t);
            }
            for (Attachment attachment : arrayList) {
                Intrinsics.checkNotNullExpressionValue((Object)attachment, (String)"it");
                DeleteBugsUtilKt.deleteAttachment(attachment, bug.getId());
            }
        }
        return bug;
    }

    public static final void deleteAttachment(@NotNull Attachment attachment, @Nullable String string2) {
        Attachment attachment2 = attachment;
        Intrinsics.checkNotNullParameter((Object)attachment2, (String)"attachment");
        String string3 = attachment2.getLocalPath();
        if (string3 != null) {
            DeleteBugsUtilKt.logAttachmentDeleted(new File(string3).delete());
        }
        DeleteBugsUtilKt.deleteAttachmentFromDb(attachment, string2);
    }

    private static final void deleteAttachmentFromDb(Attachment attachment, String string2) {
        if (attachment.getId() != -1L) {
            AttachmentsDbHelper.delete((long)attachment.getId());
        } else if (attachment.getName() != null && string2 != null) {
            AttachmentsDbHelper.delete((String)attachment.getName(), (String)string2);
        }
    }

    private static final void logAttachmentDeleted(boolean bl) {
        if (bl) {
            InstabugSDKLogger.v((String)"IBG-BR", (String)"uploadingBugAttachmentRequest succeeded, attachment file deleted successfully");
        }
    }

    public static final /* synthetic */ void access$delete(Bug bug) {
        DeleteBugsUtilKt.delete(bug);
    }
}

