/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.settings;

import android.annotation.SuppressLint;
import android.text.Spanned;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.model.ExtraReportField;
import com.instabug.bug.model.ReportCategory;
import com.instabug.bug.settings.AttachmentsTypesParams;
import com.instabug.bug.settings.ReportTypesManager;
import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.internal.video.ScreenRecordingEvent;
import com.instabug.library.internal.video.customencoding.VideoEncoderConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerSessionSettings {
    @Nullable
    private static PerSessionSettings perSessionSettings;
    private AttachmentsTypesParams attachmentsTypesParams;
    @Nullable
    private List<ReportCategory> reportCategories;
    private boolean commentFieldRequired = false;
    @Nullable
    private Spanned disclaimerText;
    private List<ExtraReportField> extraReportFields;
    @Nullable
    private ExtendedBugReport.State extendedBugReportState;
    @Nullable
    private String extendedBugReportHint1;
    @Nullable
    private String extendedBugReportHint2;
    @Nullable
    private String extendedBugReportHint3;
    private boolean screenshotRequired = false;
    @Nullable
    private OnSdkDismissCallback onSdkDismissCallback;
    private Feature.State bugReportingState = Feature.State.ENABLED;
    private boolean isEmailEnabled = true;
    private boolean isEmailFieldRequired = true;
    private boolean shouldShowSuccessDialog = true;
    private ReportTypesManager reportTypesManager;
    private final Map<String, Integer> reportTypesMinCharLimits;
    @Nullable
    private VideoEncoderConfig videoEncoderConfig;
    @Nullable
    private ScreenRecordingEvent recordReadyEvent = null;
    int welcomeScreenState = 0;

    private PerSessionSettings() {
        this.attachmentsTypesParams = new AttachmentsTypesParams();
        this.extraReportFields = new ArrayList<ExtraReportField>();
        this.reportTypesManager = ReportTypesManager.getInstance();
        this.reportTypesMinCharLimits = new HashMap<String, Integer>();
    }

    private static void init() {
        perSessionSettings = new PerSessionSettings();
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static synchronized PerSessionSettings getInstance() {
        if (perSessionSettings == null) {
            PerSessionSettings.init();
        }
        return perSessionSettings;
    }

    @Nullable
    public List<ReportCategory> getReportCategories() {
        return this.reportCategories;
    }

    public AttachmentsTypesParams getAttachmentsTypesParams() {
        return this.attachmentsTypesParams;
    }

    public PerSessionSettings setAttachmentsTypesParams(AttachmentsTypesParams attachmentsTypesParams) {
        this.attachmentsTypesParams = attachmentsTypesParams;
        return this;
    }

    @Nullable
    public OnSdkDismissCallback getOnSdkDismissCallback() {
        return this.onSdkDismissCallback;
    }

    public void setOnSdkDismissCallback(@Nullable OnSdkDismissCallback onSdkDismissCallback) {
        this.onSdkDismissCallback = onSdkDismissCallback;
    }

    public void setCommentFieldRequired(boolean bl) {
        this.commentFieldRequired = bl;
    }

    public boolean isCommentFieldRequired() {
        return this.commentFieldRequired;
    }

    @Nullable
    public Spanned getDisclaimerText() {
        return this.disclaimerText;
    }

    public void setDisclaimerText(@Nullable Spanned spanned) {
        this.disclaimerText = spanned;
    }

    public List<ExtraReportField> getExtraReportFields() {
        return this.extraReportFields;
    }

    void setExtendedBugReportState(@Nullable ExtendedBugReport.State state) {
        this.extendedBugReportState = state;
    }

    ExtendedBugReport.State getExtendedBugReportState() {
        Object object = object.extendedBugReportState;
        if (object == null) {
            object = ExtendedBugReport.State.DISABLED;
        }
        return object;
    }

    void setExtendedBugReportHints(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        PerSessionSettings perSessionSettings = this;
        perSessionSettings.extendedBugReportHint1 = string2;
        perSessionSettings.extendedBugReportHint2 = string3;
        perSessionSettings.extendedBugReportHint3 = string4;
    }

    @Nullable
    String getExtendedBugReportHint1() {
        return this.extendedBugReportHint1;
    }

    @Nullable
    String getExtendedBugReportHint2() {
        return this.extendedBugReportHint2;
    }

    @Nullable
    String getExtendedBugReportHint3() {
        return this.extendedBugReportHint3;
    }

    boolean isScreenshotRequired() {
        return this.screenshotRequired;
    }

    void setScreenshotRequired(boolean bl) {
        this.screenshotRequired = bl;
    }

    public void setBugReportingState(Feature.State state) {
        this.bugReportingState = state;
    }

    public boolean isBugReportingStateEnabled() {
        return this.bugReportingState == Feature.State.ENABLED;
    }

    public void setEmailFieldVisibility(boolean bl) {
        this.isEmailEnabled = bl;
    }

    public boolean isEmailFieldVisible() {
        return this.isEmailEnabled;
    }

    public boolean isEmailFieldRequired() {
        return this.isEmailFieldRequired;
    }

    public void setEmailFieldRequired(boolean bl) {
        this.isEmailFieldRequired = bl;
    }

    public void setSuccessDialogEnabled(boolean bl) {
        this.shouldShowSuccessDialog = bl;
    }

    public boolean successDialogEnabled() {
        return this.shouldShowSuccessDialog;
    }

    public void setReportTypeStatus(String string2, boolean bl) {
        this.reportTypesManager.setReportTypeStatus(string2, bl);
    }

    public boolean getReportTypeStatus(String string2) {
        return this.reportTypesManager.getReportTypeOptionStatus(string2);
    }

    public void setReportTypeCommentMinCharLimit(String string2, int n) {
        this.reportTypesMinCharLimits.put(string2, n);
    }

    public int getReportTypeMinCommentCharLimit(String string2) {
        Integer n = ((PerSessionSettings)((Object)n)).reportTypesMinCharLimits.get(string2);
        return n != null ? n : 0;
    }

    public void setWelcomeScreenState(int n) {
        this.welcomeScreenState = n;
    }

    public int getWelcomeScreenState() {
        return this.welcomeScreenState;
    }

    public void setVideoEncoderConfig(@NonNull VideoEncoderConfig videoEncoderConfig) {
        this.videoEncoderConfig = videoEncoderConfig;
    }

    @Nullable
    public VideoEncoderConfig getVideoEncoderConfig() {
        return this.videoEncoderConfig;
    }

    @Nullable
    public ScreenRecordingEvent getRecordReadyEvent() {
        return this.recordReadyEvent;
    }

    public void setRecordReadyEvent(@Nullable ScreenRecordingEvent screenRecordingEvent) {
        this.recordReadyEvent = screenRecordingEvent;
    }
}

