/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.onboardingbugreporting;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.instabug.bug.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.view.ViewUtils;
import java.util.Locale;

public class OnboardingPagerFragment
extends InstabugBaseFragment {
    @Nullable
    private String title;
    @Nullable
    private String subtitle;
    @DrawableRes
    private int imgRes;
    private boolean shouldSetLivePadding = false;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static OnboardingPagerFragment newInstance(@DrawableRes int n, @Nullable String string2, @Nullable String string3) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putInt("img", n);
        bundle2.putString("title", string2);
        bundle2.putString("subtitle", string3);
        OnboardingPagerFragment onboardingPagerFragment = new OnboardingPagerFragment();
        onboardingPagerFragment.setArguments(bundle2);
        return onboardingPagerFragment;
    }

    public static OnboardingPagerFragment newInstance(int n, @Nullable String string2, @Nullable String string3, boolean bl) {
        OnboardingPagerFragment onboardingPagerFragment = OnboardingPagerFragment.newInstance(n, string2, string3);
        if (onboardingPagerFragment.getArguments() != null) {
            onboardingPagerFragment.getArguments().putBoolean("setLivePadding", bl);
        }
        return onboardingPagerFragment;
    }

    public void onCreate(@Nullable Bundle bundle) {
        OnboardingPagerFragment onboardingPagerFragment = this;
        super.onCreate(bundle);
        if (onboardingPagerFragment.getArguments() != null) {
            OnboardingPagerFragment onboardingPagerFragment2 = this;
            onboardingPagerFragment2.title = onboardingPagerFragment2.getArguments().getString("title");
            onboardingPagerFragment2.subtitle = onboardingPagerFragment2.getArguments().getString("subtitle");
            onboardingPagerFragment2.imgRes = onboardingPagerFragment2.getArguments().getInt("img");
            onboardingPagerFragment2.shouldSetLivePadding = onboardingPagerFragment2.getArguments().getBoolean("setLivePadding");
        }
    }

    protected int getLayout() {
        return R.layout.ib_bug_reporting_lyt_onboarding_pager_fragment;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected void initViews(View view, @Nullable Bundle bundle) {
        OnboardingPagerFragment onboardingPagerFragment = this;
        view = (TextView)onboardingPagerFragment.findViewById(R.id.ib_bg_tv_title);
        bundle = (TextView)onboardingPagerFragment.findViewById(R.id.ib_bg_tv_subtitle);
        ImageView imageView = (ImageView)onboardingPagerFragment.findViewById(R.id.ib_bg_img_onboarding);
        RelativeLayout relativeLayout = (RelativeLayout)onboardingPagerFragment.findViewById(R.id.ib_bg_lyt_onboarding_pager_fragment);
        Context context = this.getContext();
        if (relativeLayout != null && context != null) {
            if (LocaleUtils.isRTL((Locale)InstabugCore.getLocale((Context)context))) {
                relativeLayout.setRotation(180.0f);
            }
            if (this.shouldSetLivePadding) {
                Context context2 = context;
                int n = ViewUtils.convertDpToPx((Context)context2, (float)16.0f);
                int n2 = ViewUtils.convertDpToPx((Context)context2, (float)24.0f);
                int n3 = ViewUtils.convertDpToPx((Context)context2, (float)16.0f);
                int n4 = ViewUtils.convertDpToPx((Context)context2, (float)16.0f);
                relativeLayout.setPadding(n, n2, n3, n4);
            }
        }
        if (view != null) {
            view.setText((CharSequence)this.title);
        }
        if (bundle != null) {
            bundle.setText((CharSequence)this.subtitle);
        }
        if (imageView != null) {
            ImageView imageView2 = imageView;
            ImageView imageView3 = imageView;
            imageView3.setImageResource(this.imgRes);
            imageView3.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
            int n = -ViewUtils.convertDpToPx((Context)context, (float)1.0f);
            try {
                imageView2.setPadding(n, n, n, n);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)("something went wrong" + exception.getMessage()));
            }
        }
    }
}

