/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.invoker;

import android.annotation.SuppressLint;
import android.content.Context;
import com.instabug.bug.invocation.InvocationListener;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.invocation.invoker.AbstractInvoker;
import com.instabug.bug.invocation.util.ShakeDetector;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

public class ShakeInvoker
implements AbstractInvoker<Void>,
ShakeDetector.OnShakeDetectedListener {
    private ShakeDetector shakeDetector;
    private InvocationListener invocationListener;
    private volatile boolean active;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public ShakeInvoker(Context context, InvocationListener object) {
        ShakeDetector shakeDetector;
        this.invocationListener = object;
        object = shakeDetector;
        shakeDetector = new ShakeDetector(context, this);
        this.shakeDetector = object;
    }

    @Override
    public void listen() {
        this.shakeDetector.start();
        this.active = true;
        InstabugSDKLogger.d((String)"IBG-Core", (String)"Shake invoker: listen");
    }

    @Override
    public void sleep() {
        this.shakeDetector.stop();
        this.active = false;
        InstabugSDKLogger.d((String)"IBG-Core", (String)"Shake invoker: sleep");
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void handle(Void void_) {
    }

    @Override
    public void onShakeDetected() {
        PoolProvider.postIOTask(() -> {
            InstabugSDKLogger.d((String)"IBG-Core", (String)"Shake detected, invoking SDK");
            InvocationManager.getInstance().setLastUsedInvoker(this);
            this.invocationListener.onInvocationRequested();
        });
    }

    public void setShakingThreshold(int n) {
        this.shakeDetector.setAccelerationThreshold(n);
    }
}

