/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video.customencoding;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.bug.internal.video.customencoding.Encoder;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

@TargetApi(value=21)
abstract class BaseEncoder
implements Encoder {
    @Nullable
    private final String mCodecName;
    @Nullable
    private MediaCodec mEncoder;
    @Nullable
    private Callback mCallback;
    private final MediaCodec.Callback mCodecCallback;

    BaseEncoder(@Nullable String string2) {
        MediaCodec.Callback callback;
        MediaCodec.Callback callback2 = callback;
        callback = new MediaCodec.Callback(){

            public void onInputBufferAvailable(@NonNull MediaCodec mediaCodec, int n) {
                if (BaseEncoder.this.mCallback != null) {
                    BaseEncoder.this.mCallback.onInputBufferAvailable(BaseEncoder.this, n);
                }
            }

            public void onOutputBufferAvailable(@NonNull MediaCodec mediaCodec, int n, @NonNull MediaCodec.BufferInfo bufferInfo) {
                if (BaseEncoder.this.mCallback != null) {
                    BaseEncoder.this.mCallback.onOutputBufferAvailable(BaseEncoder.this, n, bufferInfo);
                }
            }

            public void onError(@NonNull MediaCodec mediaCodec, @NonNull MediaCodec.CodecException codecException) {
                if (BaseEncoder.this.mCallback != null) {
                    BaseEncoder.this.mCallback.onError(BaseEncoder.this, (Exception)codecException);
                }
            }

            public void onOutputFormatChanged(@NonNull MediaCodec mediaCodec, @NonNull MediaFormat mediaFormat) {
                if (BaseEncoder.this.mCallback != null) {
                    BaseEncoder.this.mCallback.onOutputFormatChanged(BaseEncoder.this, mediaFormat);
                }
            }
        };
        this.mCodecCallback = callback2;
        this.mCodecName = string2;
    }

    /*
     * WARNING - void declaration
     */
    private MediaCodec createEncoder(String string2) {
        block4: {
            void var2_5;
            String string3 = this.mCodecName;
            if (string3 == null) break block4;
            try {
                return MediaCodec.createByCodecName((String)string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            InstabugSDKLogger.e((String)"IBG-Core", (String)("Create MediaCodec by name '" + this.mCodecName + "' failure! " + var2_5.getMessage()));
        }
        return MediaCodec.createEncoderByType((String)string2);
    }

    void setCallback(Callback callback) {
        if (this.mEncoder == null) {
            this.mCallback = callback;
            return;
        }
        throw new IllegalStateException("mEncoder is not null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void prepare() {
        if (Looper.myLooper() != null && Looper.myLooper() != Looper.getMainLooper()) {
            Exception exception2;
            MediaFormat mediaFormat;
            block5: {
                MediaCodec mediaCodec;
                block4: {
                    if (this.mEncoder != null) {
                        throw new IllegalStateException("prepared!");
                    }
                    BaseEncoder baseEncoder = this;
                    mediaFormat = baseEncoder.createMediaFormat();
                    mediaCodec = baseEncoder.createEncoder(mediaFormat.getString("mime"));
                    try {
                        if (baseEncoder.mCallback == null) break block4;
                        mediaCodec.setCallback(this.mCodecCallback);
                    }
                    catch (Exception exception2) {
                        break block5;
                    }
                }
                mediaCodec.configure(mediaFormat, null, null, 1);
                this.onEncoderConfigured(mediaCodec);
                mediaCodec.start();
                this.mEncoder = mediaCodec;
                return;
            }
            InstabugSDKLogger.e((String)"IBG-Core", (String)("Configure codec failure!\n  with format" + mediaFormat), (Throwable)exception2);
            throw exception2;
        }
        throw new IllegalStateException("should run in a HandlerThread");
    }

    protected void onEncoderConfigured(MediaCodec mediaCodec) {
    }

    protected abstract MediaFormat createMediaFormat();

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected final MediaCodec getEncoder() {
        return Objects.requireNonNull(this.mEncoder, "doesn't prepare()");
    }

    @Nullable
    public final ByteBuffer getOutputBuffer(int n) {
        try {
            return this.getEncoder().getOutputBuffer(n);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-Core", (String)("Something went wrong while calling getOutputBuffer. " + exception.getMessage()), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    public final ByteBuffer getInputBuffer(int n) {
        try {
            return this.getEncoder().getInputBuffer(n);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-Core", (String)("Something went wrong while calling getInputBuffer. " + exception.getMessage()), (Throwable)exception);
            return null;
        }
    }

    public final void queueInputBuffer(int n, int n2, int n3, long l, int n4) {
        try {
            this.getEncoder().queueInputBuffer(n, n2, n3, l, n4);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-Core", (String)("Something went wrong while calling queueInputBuffer. " + exception.getMessage()), (Throwable)exception);
        }
    }

    public final void releaseOutputBuffer(int n) {
        try {
            this.getEncoder().releaseOutputBuffer(n, false);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-Core", (String)("Something went wrong while calling releaseOutputBuffer. " + exception.getMessage()), (Throwable)exception);
        }
    }

    public void stop() {
        BaseEncoder baseEncoder = baseEncoder.mEncoder;
        if (baseEncoder != null) {
            try {
                baseEncoder.stop();
            }
            catch (IllegalStateException illegalStateException) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)("Something went wrong while stopping the encoder. " + illegalStateException.getMessage()), (Throwable)illegalStateException);
            }
        }
    }

    public void release() {
        MediaCodec mediaCodec = this.mEncoder;
        if (mediaCodec != null) {
            mediaCodec.release();
            this.mEncoder = null;
        }
    }

    static abstract class Callback
    implements Encoder.Callback {
        Callback() {
        }

        void onInputBufferAvailable(BaseEncoder baseEncoder, int n) {
        }

        abstract void onOutputFormatChanged(BaseEncoder var1, MediaFormat var2);

        abstract void onOutputBufferAvailable(BaseEncoder var1, int var2, MediaCodec.BufferInfo var3);
    }
}

