/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.BugsCoreEventsHandler;
import com.instabug.bug.ReportingPluginWrapper;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.internal.video.ScreenRecordingService;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.network.NormalBugsUploaderJob;
import com.instabug.bug.network.ProactiveReportsBugsUploaderJob;
import com.instabug.bug.onboardingbugreporting.utils.WelcomeMessageHelperApiImp;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.settings.PerSessionSettings;
import com.instabug.bug.utils.CleanUpUtils;
import com.instabug.bug.view.actionList.service.FetchReportCategoriesJob;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.frustratingexperience.FrustratingExperienceEvent;
import com.instabug.library.frustratingexperience.FrustratingExperienceEventBus;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.video.ScreenRecordingEvent;
import com.instabug.library.internal.video.ScreenRecordingServiceData;
import com.instabug.library.internal.video.ScreenRecordingServiceEventBus;
import com.instabug.library.invocation.InvocationManagerContract;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tokenmapping.MappedTokenChangedEventBus;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;

public class BugPlugin
extends Plugin {
    public static final String SCREEN_RECORDING_EVENT_NAME = "SendDataToRecordingService";
    @Nullable
    private IBGCompositeDisposable disposables;
    @Nullable
    @VisibleForTesting
    IBGDisposable mappedTokenChangedDisposable;

    private void initInvocationManager() {
        CoreServiceLocator.setInvocationManagerContract((InvocationManagerContract)InvocationManager.getInstance());
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(InstabugFloatingButtonEdge.RIGHT);
        InvocationManager.getInstance().notifyPrimaryColorChanged();
        InvocationManager.getInstance().setInstabugInvocationEvent(InstabugCore.getInvocationEvents());
    }

    private void subscribeOnCoreEvents() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            this.getOrCreateCompositeDisposables().add(this.subscribeToCoreEvents());
        }
    }

    @NonNull
    private IBGDisposable subscribeToCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(iBGSdkCoreEvent -> {
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (weakReference != null) {
                BugsCoreEventsHandler.handleCoreEvents((Context)weakReference.get(), iBGSdkCoreEvent);
            }
        });
    }

    private void subscribeOnMappedTokenChangedEvent() {
        if (this.mappedTokenChangedDisposable == null) {
            this.mappedTokenChangedDisposable = MappedTokenChangedEventBus.INSTANCE.subscribe(bl -> {
                FetchReportCategoriesJob.getInstance().resetLastFetchTimeout();
                FetchReportCategoriesJob.getInstance().start();
            });
        }
    }

    private void subscribeOnFrustratingExperienceEventBus() {
        this.getOrCreateCompositeDisposables().add(FrustratingExperienceEventBus.INSTANCE.subscribe(frustratingExperienceEvent -> ServiceLocator.getFrustratingExperienceEventsHandler().handle((FrustratingExperienceEvent)frustratingExperienceEvent)));
    }

    private void unsubscribeFromMappedTokenChangedEvents() {
        IBGDisposable iBGDisposable = this.mappedTokenChangedDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.mappedTokenChangedDisposable = null;
        }
    }

    private void loadAndApplyCachedReproConfigurations() {
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null) {
            settingsManager = settingsManager.getReproConfigurations();
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (settingsManager != null && weakReference != null) {
                BugsCoreEventsHandler.handleCoreEvents((Context)weakReference.get(), (IBGSdkCoreEvent)new IBGSdkCoreEvent.ReproState(settingsManager.getModesMap()));
            }
        }
    }

    private void unSubscribeFromEvents() {
        BugPlugin bugPlugin = bugPlugin.disposables;
        if (bugPlugin != null) {
            bugPlugin.dispose();
        }
    }

    private IBGCompositeDisposable getOrCreateCompositeDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    public void init(Context context) {
        Context context2 = context;
        this.initInvocationManager();
        ServiceLocator.getConfigurationsProvider().restoreFromCache();
        ServiceLocator.getReproProxy().evaluate((ReproConfigurationsProvider)ServiceLocator.getConfigurationsProvider());
        ServiceLocator.getReproScreenshotsCacheDir().addWatcher(4);
        ServiceLocator.getHubDataWatcher().addWatcher(4);
        CleanUpUtils.cleanupUnsentBugsFiles(context2);
        super.init(context2);
    }

    public void wake() {
        ServiceLocator.getReproScreenshotsCacheDir().consentOnCleansing(4);
        ServiceLocator.getHubDataWatcher().consentOnCleansing(4);
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        ScreenRecordingEvent screenRecordingEvent = perSessionSettings.getRecordReadyEvent();
        if (screenRecordingEvent != null) {
            PoolProvider.postMainThreadTask(() -> ScreenRecordingEventBus.getInstance().post((Object)screenRecordingEvent));
            perSessionSettings.setRecordReadyEvent(null);
        }
    }

    public void sleep() {
    }

    public void initDefaultPromptOptionAvailabilityState() {
        ReportingPluginWrapper.initDefaultPromptOptionAvailabilityState();
    }

    public ArrayList<PluginPromptOption> getPromptOptions() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return ReportingPluginWrapper.getPromptOptions((Context)this.contextWeakReference.get());
        }
        return new ArrayList<PluginPromptOption>();
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPluginOptions(boolean bl) {
        InstabugSDKLogger.d((String)"IBG-BR", (String)"[BugPlugin#getPluginOptions] Getting plugin options");
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return ReportingPluginWrapper.getReportingOptions(bl, (Context)this.contextWeakReference.get());
        }
        InstabugSDKLogger.d((String)"IBG-BR", (String)"[BugPlugin#getPluginOptions] No options, returning null");
        return null;
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((String)"BUG_REPORTING");
    }

    public void stop() {
        BugPlugin bugPlugin = this;
        ReportingPluginWrapper.release();
        bugPlugin.unSubscribeFromEvents();
        bugPlugin.unsubscribeFromMappedTokenChangedEvents();
        InvocationManager.getInstance().sleep();
        ScreenRecordingServiceEventBus.unregisterHandler((String)SCREEN_RECORDING_EVENT_NAME);
        BugsCoreEventsHandler.unsubscribeFromProductAnalyticsCollector();
    }

    public void start(Context context) {
        if (Instabug.isEnabled() && BugSettings.getInstance().isBugReportingStateEnabled() && BugSettings.getInstance().getWelcomeMessageState() != 2) {
            new WelcomeMessageHelperApiImp().showIntroMessage();
        }
        BugPlugin bugPlugin = this;
        this.loadAndApplyCachedReproConfigurations();
        ReportingPluginWrapper.init(context);
        bugPlugin.subscribeOnCoreEvents();
        bugPlugin.subscribeOnMappedTokenChangedEvent();
        NormalBugsUploaderJob.getInstance().start();
        ProactiveReportsBugsUploaderJob.getInstance().start();
        InvocationManager.getInstance().listen();
        bugPlugin.retrieveIntentFromPermissionsActivity();
        bugPlugin.subscribeOnFrustratingExperienceEventBus();
        BugsCoreEventsHandler.subscribeToProductAnalyticsCollector();
    }

    public void retrieveIntentFromPermissionsActivity() {
        ScreenRecordingServiceEventBus.registerHandler((String)SCREEN_RECORDING_EVENT_NAME, screenRecordingServiceData -> {
            Context context = screenRecordingServiceData.getContext();
            if (context != null && screenRecordingServiceData.getResultOk() != null && screenRecordingServiceData.isSent() != null && screenRecordingServiceData.getMediaProjectionIntent() != null) {
                ScreenRecordingServiceData screenRecordingServiceData2 = screenRecordingServiceData;
                int n = screenRecordingServiceData2.getResultOk();
                Intent intent = screenRecordingServiceData2.getMediaProjectionIntent();
                ScreenRecordingService.startScreenRecordingService(context, ScreenRecordingService.newIntent(screenRecordingServiceData.getContext(), n, intent, screenRecordingServiceData.isSent()));
            }
        });
    }

    public long getLastActivityTime() {
        return BugSettings.getInstance().getLastBugTime();
    }

    public void onLocaleChanged(Locale locale, Locale locale2) {
        super.onLocaleChanged(locale, locale2);
        FetchReportCategoriesJob.getInstance().start();
    }
}

