package com.instabug.chat.ui;

import android.content.Intent;

import com.instabug.chat.model.Attachment;
import com.instabug.library.core.ui.BaseContract;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

public class ChatContract {

    interface View extends BaseContract.View<AppCompatActivity> {

        @ChatActivityLauncher.ChatProcess
        int getChatProcess(Intent intent);

        @Nullable
        String getChatProcessChatNumber();

        @Nullable
        Attachment getChatProcessChatAttachment();

        boolean shouldEnabledComposeButton();

        void showChatsFragment();

        void showChatFragment(String chatId);

        void showChatFragment(String chatId, Attachment attachment);
    }

    interface Presenter extends BaseContract.Presenter {

        void handleChatProcess(@ChatActivityLauncher.ChatProcess int currentProcess);

        void handleOpenChatRequest(String ChatNumber);

        void handleOnSdkDismissed();

        void dismissSystemNotification();
    }
}
