package com.instabug.bug.view.visualusersteps.visitedscreens;

import android.content.Context;

import com.instabug.bug.model.VisitedScreen;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.library.core.ui.BaseContract;

import java.util.ArrayList;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

/**
 * Created by Barakat on 05/05/2019
 */
public class VisualUserStepsListContract {
    interface View extends BaseContract.View<Fragment> {

        void showPreparingDialog();

        void dismissPreparingDialog();

        void onStepItemDelete(int position, VisitedScreen item);

        void onStepItemClick(@NonNull VisualUserStepArgs args);

        void populateVisualUserSteps(ArrayList<VisitedScreen> visualUserSteps);
    }

    interface Presenter extends BaseContract.Presenter {

        void getVisualUserSteps();

        void release();

        void deleteVisualUserStep(Context context, int position, VisitedScreen visitedScreen);
    }
}
