package com.instabug.bug.view.reporting.frustratingexperience

import android.os.Bundle
import android.view.View
import com.instabug.bug.Constants
import com.instabug.bug.R
import com.instabug.bug.di.ServiceLocator
import com.instabug.bug.view.reporting.BaseReportingFragment
import com.instabug.bug.view.reporting.IBaseReportingView

class FrustratingExperienceFragment : BaseReportingFragment() {

    companion object {
        @JvmStatic
        fun newInstance(message: String?) = FrustratingExperienceFragment().apply {
            if(message != null) {
                val args = Bundle()
                args.putString(Constants.EXTRA_REPORTING_MESSAGE, message)
                arguments = args
            }
        }

        const val TAG = "FrustratingExperienceFragment"
    }

    override fun initViews(rootView: View?, savedInstanceState: Bundle?) {
        super.initViews(rootView, savedInstanceState)

        reproStepsDisclaimerTextView.visibility = View.GONE
    }

    override fun createPresenter(): IBaseReportingView.Presenter? =
        ServiceLocator.getReportingPresenter(this)

    override fun provideDefaultHintMessage(): String =
        getLocalizedString(R.string.IBGFrustratingExperienceHint)


    override fun provideDefaultTitle(): String =
        getLocalizedString(R.string.frustrating_experience_header)

    override fun getCloseButtonContentDescription(): Int =
        R.string.ibg_core_ic_close_frustrating_experience_content_description;

    override fun getSendButtonContentDescriptionTitle(): Int =
        R.string.ibg_frustrating_experience_send_content_description;

}
