package com.instabug.bug.settings;

import android.annotation.SuppressLint;

import com.instabug.bug.Constants;

import java.util.HashMap;
import java.util.Map;

/**
 * This manager is singleton to manage report types which defined {@link com.instabug.bug.Constants.ReportType}
 */
public class ReportTypesManager {

    private static ReportTypesManager mReportTypeManagerInstance;
    private Map<String, Boolean> reportTypeOptionsStatus;
    private boolean defaultStatus = true;

    private ReportTypesManager() {
        setupReportsStatus();
    }

    public static ReportTypesManager getInstance() {
        if (mReportTypeManagerInstance == null)
            mReportTypeManagerInstance = new ReportTypesManager();
        return mReportTypeManagerInstance;
    }

    /**
     * This method to initialize report types with their default status.
     */
    private void setupReportsStatus() {
        reportTypeOptionsStatus = new HashMap<>();
        reportTypeOptionsStatus.put(Constants.ReportType.FEEDBACK, defaultStatus);
        reportTypeOptionsStatus.put(Constants.ReportType.BUG, defaultStatus);
        reportTypeOptionsStatus.put(Constants.ReportType.ASK_QUESTION, defaultStatus);
    }

    public void setReportTypeStatus(@Constants.ReportType String reportType, boolean reportTypeStatus) {
        reportTypeOptionsStatus.put(reportType, reportTypeStatus);
    }

    @SuppressLint("ERADICATE_NULLABLE_DEREFERENCE")
    public boolean getReportTypeOptionStatus(@Constants.ReportType String reportType) {
        return reportTypeOptionsStatus.get(reportType);
    }
}
