/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.base;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewStub;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.core.graphics.Insets;
import com.instabug.bug.R;
import com.instabug.chat.util.ViewUtilsKt;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.SystemServiceUtils;
import com.instabug.library.util.ThemeApplier;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public abstract class ToolbarFragment<P extends BaseContract.Presenter>
extends InstabugBaseFragment<P> {
    @Nullable
    protected ImageButton toolbarImageButtonDone;
    @Nullable
    protected ImageButton toolbarImageButtonClose;
    @Nullable
    private View instabugToolbar;
    @Nullable
    private TextView titleTextView;

    private void fitSystemWindow(View view) {
        if (Build.VERSION.SDK_INT > 34 && (toolbarFragment = toolbarFragment.findViewById(R.id.status_bar_filler)) != null && view != null) {
            ToolbarFragment toolbarFragment = arg_0 -> ToolbarFragment.lambda$fitSystemWindow$1((View)toolbarFragment, arg_0);
            ViewUtilsKt.addSystemWindowInsetToPadding(view, true, false, true, true, (Function1<? super Insets, Unit>)toolbarFragment);
        }
    }

    private void initToolbarViews() {
        ToolbarFragment toolbarFragment = this;
        toolbarFragment.toolbarImageButtonDone = (ImageButton)toolbarFragment.findViewById(R.id.instabug_btn_toolbar_right);
        toolbarFragment.instabugToolbar = toolbarFragment.findViewById(R.id.instabug_toolbar);
        toolbarFragment.titleTextView = (TextView)toolbarFragment.findViewById(R.id.instabug_fragment_title);
        ImageButton imageButton = toolbarFragment.toolbarImageButtonDone;
        if (imageButton != null) {
            imageButton.setOnClickListener(view -> {
                view = this.getActivity();
                if (view != null) {
                    SystemServiceUtils.hideInputMethod((Activity)view);
                }
                this.onDoneButtonClicked();
            });
        }
        this.toolbarImageButtonClose = imageButton = (ImageButton)this.findViewById(R.id.instabug_btn_toolbar_left);
        if (imageButton != null) {
            imageButton.setOnClickListener(view -> this.onCloseButtonClicked());
        }
        ToolbarFragment toolbarFragment2 = this;
        toolbarFragment2.styleToolbar();
        toolbarFragment2.makeToolBarFitSystemWidow(toolbarFragment2.instabugToolbar);
    }

    private void makeToolBarFitSystemWidow(View view) {
        if (view != null && Build.VERSION.SDK_INT > 34) {
            ViewUtilsKt.addSystemWindowInsetToPadding(view, true, false, true, false);
        }
    }

    private void styleToolbar() {
        View view = this.instabugToolbar;
        if (view != null) {
            view.setBackgroundColor(InstabugCore.getPrimaryColor());
        }
        ThemeApplier.applyTitleStyle((TextView)this.titleTextView, (IBGTheme)this.getIBGTheme());
    }

    private static /* synthetic */ Unit lambda$fitSystemWindow$1(View view, Insets insets) {
        View view2 = view;
        view2.setVisibility(0);
        view2.getLayoutParams().height = Math.max(insets.top, 0);
        view2.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
        return Unit.INSTANCE;
    }

    @CallSuper
    protected void initViews(View view2, @Nullable Bundle bundle) {
        ToolbarFragment toolbarFragment = this;
        toolbarFragment.initToolbarViews();
        ViewStub viewStub2 = (ViewStub)toolbarFragment.findViewById(R.id.instabug_content);
        if (viewStub2 != null) {
            ViewStub viewStub3 = viewStub2;
            viewStub2.setLayoutResource(this.getContentLayout());
            viewStub3.setOnInflateListener((viewStub, view) -> this.fitSystemWindow(view));
            viewStub3.inflate();
        }
        ToolbarFragment toolbarFragment2 = this;
        toolbarFragment2.initContentViews(view2, bundle);
        toolbarFragment2.setTitle(toolbarFragment2.getTitle());
        ThemeApplier.setScreenBackground((View)view2, (IBGTheme)toolbarFragment2.getIBGTheme());
    }

    protected int getLayout() {
        return R.layout.instabug_fragment_toolbar;
    }

    @LayoutRes
    protected abstract int getContentLayout();

    protected abstract void initContentViews(View var1, @Nullable Bundle var2);

    protected void setTitle(String string2) {
        if (this.rootView == null) {
            return;
        }
        if ((this = (TextView)this.findViewById(R.id.instabug_fragment_title)) != null) {
            this.setText(string2);
        }
    }

    protected abstract String getTitle();

    protected abstract void onDoneButtonClicked();

    protected void onCloseButtonClicked() {
        if ((this = this.getActivity()) != null) {
            ToolbarFragment toolbarFragment = this;
            SystemServiceUtils.hideInputMethod((Activity)toolbarFragment);
            toolbarFragment.onBackPressed();
        } else {
            Log.w((String)"ToolbarFragment", (String)"onCloseButtonClicked can't be executed due to null getActivity() reference");
        }
    }

    @Nullable
    protected IBGTheme getIBGTheme() {
        BaseContract.Presenter presenter = this.presenter;
        return presenter != null && presenter.getTheme() != null ? this.presenter.getTheme() : null;
    }
}

