/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.annotation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.bug.R;
import com.instabug.chat.annotation.AnnotationLayout;
import com.instabug.chat.ui.annotation.AnnotationContract$Presenter;
import com.instabug.chat.ui.annotation.AnnotationContract$View;
import com.instabug.chat.ui.annotation.AnnotationPresenter;
import com.instabug.chat.ui.base.ToolbarFragment;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.view.IBGProgressDialog;

@SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE", "ERADICATE_FIELD_NOT_INITIALIZED"})
public class ChatAnnotationFragment
extends ToolbarFragment<AnnotationContract$Presenter>
implements AnnotationContract$View {
    private String title;
    private String chatId;
    private String attachmentType;
    private Uri imageUri;
    @Nullable
    private AnnotationLayout annotationLayout;
    private Callbacks callbacks;
    @Nullable
    private IBGProgressDialog preparingProgressDialog;

    public static ChatAnnotationFragment newInstance(String string2, String string3, Uri uri, String string4) {
        Bundle bundle;
        ChatAnnotationFragment chatAnnotationFragment = new ChatAnnotationFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString("title", string2);
        bundle2.putString("chat_id", string3);
        bundle2.putParcelable("image_uri", (Parcelable)uri);
        bundle2.putString("attachment_type", string4);
        chatAnnotationFragment.setArguments(bundle2);
        return chatAnnotationFragment;
    }

    public void onCreate(@Nullable Bundle object) {
        AnnotationPresenter annotationPresenter;
        ChatAnnotationFragment chatAnnotationFragment = this;
        super.onCreate(object);
        if (chatAnnotationFragment.getActivity() != null && this.getActivity().getSupportFragmentManager().findFragmentByTag("chat_fragment") != null) {
            this.callbacks = (Callbacks)this.getActivity().getSupportFragmentManager().findFragmentByTag("chat_fragment");
        }
        if (this.getArguments() != null) {
            ChatAnnotationFragment chatAnnotationFragment2 = this;
            chatAnnotationFragment2.title = chatAnnotationFragment2.getArguments().getString("title");
            chatAnnotationFragment2.chatId = chatAnnotationFragment2.getArguments().getString("chat_id");
            chatAnnotationFragment2.attachmentType = chatAnnotationFragment2.getArguments().getString("attachment_type");
            chatAnnotationFragment2.imageUri = (Uri)chatAnnotationFragment2.getArguments().getParcelable("image_uri");
        }
        object = annotationPresenter;
        annotationPresenter = new AnnotationPresenter(this);
        this.presenter = object;
    }

    @Override
    protected int getContentLayout() {
        return R.layout.instabug_fragment_annotation;
    }

    @Override
    protected void initContentViews(View view, @Nullable Bundle object) {
        object = (ImageButton)view.findViewById(R.id.instabug_btn_toolbar_right);
        if (object != null) {
            object.setImageResource(R.drawable.ibg_chat_ic_send);
        }
        object = (AnnotationLayout)view.findViewById(R.id.annotationLayout);
        chatAnnotationFragment2.annotationLayout = object;
        if (object != null) {
            ((AnnotationLayout)((Object)object)).setBaseImage(chatAnnotationFragment2.imageUri, null);
        }
        ChatAnnotationFragment chatAnnotationFragment = chatAnnotationFragment2;
        ChatAnnotationFragment chatAnnotationFragment2 = (LinearLayout)view.findViewById(R.id.instabug_annotation_actions_container);
        view = chatAnnotationFragment.theme;
        if (view != null && view.getBackgroundColor() != 0 && chatAnnotationFragment2 != null) {
            chatAnnotationFragment2.setBackgroundColor(0);
        }
    }

    @Override
    protected String getTitle() {
        return this.title;
    }

    @Override
    protected void onDoneButtonClicked() {
        AnnotationLayout annotationLayout;
        BaseContract.Presenter presenter = chatAnnotationFragment2.presenter;
        if (presenter != null && (annotationLayout = chatAnnotationFragment2.annotationLayout) != null) {
            ChatAnnotationFragment chatAnnotationFragment = chatAnnotationFragment2;
            ChatAnnotationFragment chatAnnotationFragment2 = annotationLayout.getAnnotatedBitmap();
            ((AnnotationContract$Presenter)presenter).saveAnnotatedImage((Bitmap)chatAnnotationFragment2, chatAnnotationFragment.imageUri);
        }
    }

    @Override
    protected void onCloseButtonClicked() {
        Callbacks callbacks = ((ChatAnnotationFragment)((Object)string2)).callbacks;
        if (callbacks != null) {
            ChatAnnotationFragment chatAnnotationFragment = string2;
            String string2 = chatAnnotationFragment.chatId;
            callbacks.onImageEditingCancelled(string2, chatAnnotationFragment.imageUri);
        }
    }

    @Override
    public void showPreparingDialog() {
        if (this.getActivity() != null && this.preparingProgressDialog != null) {
            this.preparingProgressDialog = new IBGProgressDialog.Builder().setMessage(this.getLocalizedString(R.string.instabug_str_dialog_message_preparing)).build((Context)this.getActivity());
            this.preparingProgressDialog.show();
        }
    }

    @Override
    public void finish() {
        Object object = this.preparingProgressDialog;
        if (object != null && object.isShowing()) {
            this.preparingProgressDialog.dismiss();
        }
        if ((object = this.callbacks) != null) {
            IBGProgressDialog iBGProgressDialog = object;
            ChatAnnotationFragment chatAnnotationFragment = this;
            object = chatAnnotationFragment.chatId;
            Uri uri = chatAnnotationFragment.imageUri;
            String string2 = chatAnnotationFragment.attachmentType;
            iBGProgressDialog.onImageEditingDone((String)object, uri, string2);
        }
        if (this.getActivity() != null) {
            ChatAnnotationFragment chatAnnotationFragment = this;
            chatAnnotationFragment.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
            chatAnnotationFragment.getActivity().getSupportFragmentManager().popBackStack("annotation_fragment_for_chat", 1);
        }
    }

    public static interface Callbacks {
        public void onImageEditingDone(String var1, Uri var2, String var3);

        public void onImageEditingCancelled(String var1, Uri var2);
    }
}

