/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.instabug.bug.R;
import com.instabug.chat.ChatPlugin;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.ui.ChatContract$Presenter;
import com.instabug.chat.ui.ChatContract$View;
import com.instabug.chat.ui.ChatPresenter;
import com.instabug.chat.ui.chat.ChatFragment;
import com.instabug.chat.ui.chats.ChatsFragment;
import com.instabug.chat.util.ChatThemeResolver;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BaseFragmentActivity;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.OrientationUtils;
import com.instabug.library.util.StatusBarUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ChatActivity
extends BaseFragmentActivity<ChatContract$Presenter>
implements _InstabugActivity,
ChatContract$View,
ChatsFragment.Callbacks {
    protected void onNewIntent(Intent object) {
        super.onNewIntent(object);
        if (this.getChatProcess((Intent)object) == 161 && (object = object.getStringExtra("chat_number")) != null) {
            this.openChat((String)object);
        }
    }

    @SuppressLint(value={"STARVATION"})
    public void onCreate(@Nullable Bundle object) {
        ChatPresenter chatPresenter;
        ChatPlugin chatPlugin = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class);
        if (chatPlugin != null) {
            chatPlugin.setState(1);
        }
        ChatActivity chatActivity = this;
        super.onCreate(object);
        OrientationUtils.handelOrientation((Context)chatActivity);
        if (SettingsManager.getInstance().getTheme() != null) {
            this.setTheme(ChatThemeResolver.resolveTheme(SettingsManager.getInstance().getTheme()));
        }
        ChatActivity chatActivity2 = this;
        object = chatPresenter;
        chatActivity2.presenter = new ChatPresenter(this);
        ChatActivity chatActivity3 = this;
        ((ChatContract$Presenter)object).handleChatProcess(chatActivity3.getChatProcess(chatActivity3.getIntent()));
        chatActivity2.getSupportFragmentManager().addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                ChatActivity.this.changeAccessibilityImportance();
            }
        });
        chatActivity2.setTitle("");
        if (!InstabugCore.isFullScreen()) {
            StatusBarUtils.darkenStatusBarColor((Activity)this, (int)InstabugCore.getPrimaryColor());
        }
    }

    protected void onResume() {
        ChatActivity chatActivity = chatActivity2;
        super.onResume();
        ChatActivity chatActivity2 = chatActivity.presenter;
        if (chatActivity2 != null) {
            ((ChatContract$Presenter)((Object)chatActivity2)).dismissSystemNotification();
        }
    }

    public void changeAccessibilityImportance() {
        ArrayList arrayList;
        List list = arrayList2.getSupportFragmentManager().getFragments();
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (Fragment fragment : list) {
            if (fragment.getView() == null) continue;
            arrayList2.add(fragment);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            Fragment fragment;
            fragment = ((Fragment)arrayList2.get(i)).getView();
            if (fragment == null) continue;
            if (i == arrayList2.size() - 1) {
                ViewCompat.setImportantForAccessibility((View)fragment, (int)1);
                if (Build.VERSION.SDK_INT < 16) {
                    fragment.sendAccessibilityEvent(8);
                    continue;
                }
                fragment.sendAccessibilityEvent(32768);
                continue;
            }
            ViewCompat.setImportantForAccessibility((View)fragment, (int)4);
        }
    }

    protected int getLayout() {
        return R.layout.instabug_activity;
    }

    protected void initViews() {
    }

    public void onStop() {
        super.onStop();
        ChatPlugin chatPlugin = (ChatPlugin)InstabugCore.getXPlugin(ChatPlugin.class);
        if (chatPlugin != null && chatPlugin.getState() != 2) {
            chatPlugin.setState(0);
        }
    }

    protected void onDestroy() {
        ChatActivity chatActivity = this;
        OrientationUtils.unlockOrientation((Context)chatActivity);
        IBGCoreEventPublisher.post((IBGSdkCoreEvent)IBGSdkCoreEvent.ForegroundAvailable.INSTANCE);
        super.onDestroy();
    }

    @Override
    public void showChatsFragment() {
        Fragment fragment;
        if (!(this.isFinishing() || (fragment = this.getSupportFragmentManager().findFragmentByTag("chats_fragment")) instanceof ChatsFragment && fragment.isResumed())) {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.instabug_fragment_container, (Fragment)ChatsFragment.newInstance(this.shouldEnabledComposeButton()), "chats_fragment").commit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void showChatFragment(String object) {
        IllegalStateException illegalStateException2;
        block4: {
            ChatActivity chatActivity;
            ChatActivity chatActivity2;
            if (chatActivity4.isFinishing()) return;
            try {
                ChatActivity chatActivity3 = chatActivity4;
                chatActivity2 = chatActivity3;
                chatActivity = chatActivity3;
                chatActivity3.getSupportFragmentManager().executePendingTransactions();
            }
            catch (IllegalStateException illegalStateException2) {}
            int n = R.id.instabug_fragment_container;
            object = ChatFragment.newInstance((String)object);
            ChatActivity chatActivity4 = chatActivity.getSupportFragmentManager().beginTransaction().add(n, (Fragment)object, "chat_fragment");
            if (chatActivity2.getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container) == null) break block4;
            chatActivity4.addToBackStack("chat_fragment");
        }
        chatActivity4.commitAllowingStateLoss();
        return;
        InstabugSDKLogger.e((String)"IBG-BR", (String)("Couldn't show Chat fragment due to " + illegalStateException2.getMessage()));
    }

    @Override
    public void showChatFragment(String string2, Attachment attachment) {
        if (!this.isFinishing()) {
            ChatActivity chatActivity = this;
            chatActivity.getSupportFragmentManager().executePendingTransactions();
            int n = R.id.instabug_fragment_container;
            FragmentTransaction fragmentTransaction = chatActivity.getSupportFragmentManager().beginTransaction().add(n, (Fragment)ChatFragment.newInstance(string2, attachment), "chat_fragment");
            if (chatActivity.getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container) != null) {
                fragmentTransaction.addToBackStack("chat_fragment");
            }
            fragmentTransaction.commit();
        }
    }

    public int getChatProcess(Intent intent) {
        switch (intent.getIntExtra("chat_process", -1)) {
            default: {
                return 160;
            }
            case 164: {
                return 164;
            }
            case 162: {
                return 162;
            }
            case 161: 
        }
        return 161;
    }

    @Override
    @Nullable
    public String getChatProcessChatNumber() {
        return this.getIntent().getStringExtra("chat_number");
    }

    @Override
    @Nullable
    public Attachment getChatProcessChatAttachment() {
        return (Attachment)this.getIntent().getSerializableExtra("attachment");
    }

    public boolean shouldEnabledComposeButton() {
        return (this = this.getIntent().getExtras()) != null && this.getBoolean("compose");
    }

    @Override
    public void openChat(String string2) {
        ChatActivity chatActivity = chatActivity.presenter;
        if (chatActivity != null) {
            ((ChatContract$Presenter)((Object)chatActivity)).handleOpenChatRequest(string2);
        }
    }

    public void finish() {
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null) {
            ((ChatContract$Presenter)presenter).handleOnSdkDismissed();
        }
        super.finish();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected void onActivityResult(int n, int n2, @Nullable Intent intent) {
        ChatActivity chatActivity = iterator;
        super.onActivityResult(n, n2, intent);
        Iterator iterator = chatActivity.getSupportFragmentManager().getFragments().iterator();
        while (iterator.hasNext()) {
            ((Fragment)iterator.next()).onActivityResult(n, n2, intent);
        }
    }
}

