/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.screenrecording;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.instabug.bug.internal.video.InternalScreenRecordHelper;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.eventbus.ChatTriggeringEventBus;
import com.instabug.chat.eventbus.TriggeredChat;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.Message;
import com.instabug.chat.network.InstabugMessageUploaderJob;
import com.instabug.chat.ui.ChatActivityLauncher;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.internal.video.ScreenRecordingContract;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.functions.Consumer;
import java.util.ArrayList;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class ExternalScreenRecordHelper
implements ScreenRecordingContract {
    private static ExternalScreenRecordHelper INSTANCE;
    private String chatId;
    @Nullable
    private String messageId;
    @Nullable
    private Disposable disposable;
    @Nullable
    private Disposable chatTriggeringDisposable;

    public static ExternalScreenRecordHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExternalScreenRecordHelper();
        }
        return INSTANCE;
    }

    private void setChatId(String string2) {
        this.chatId = string2;
    }

    private void startWithHangingChat(@Nullable Uri uri) {
        if (uri != null) {
            ExternalScreenRecordHelper externalScreenRecordHelper = this;
            externalScreenRecordHelper.attachFileToChat(externalScreenRecordHelper.chatId, uri);
            this.updateHangingChat(uri);
        }
        if ((uri = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity()) != null) {
            Uri uri2 = uri;
            uri2.startActivity(ChatActivityLauncher.chatProcessIntent((Context)uri2, this.chatId));
        }
    }

    private void attachFileToChat(String inMemoryCache, Uri uri) {
        Message message = new Message(UserManagerWrapper.getUserName(), UserManagerWrapper.getUserEmail(), InstabugCore.getPushNotificationToken()).setChatId((String)inMemoryCache).setBody("").setMessagedAt(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds()).setReadAt(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds()).setDirection(Message.Direction.INBOUND);
        if (uri != null) {
            Attachment attachment;
            Message message2 = message;
            ExternalScreenRecordHelper externalScreenRecordHelper = object;
            Object object = attachment;
            ((Attachment)object)();
            ((Attachment)object).setName(uri.getLastPathSegment());
            attachment.setLocalPath(uri.getPath());
            attachment.setType("extra_video");
            attachment.setState("offline");
            attachment.setVideoEncoded(false);
            externalScreenRecordHelper.assignHangingMessageId(message.getId());
            message2.setMessageState(Message.MessageState.STAY_OFFLINE);
            message2.getAttachments().add((Attachment)object);
        }
        if ((object = ChatsCacheManager.getChat((String)inMemoryCache)) != null && ((Chat)object).getMessages() != null) {
            if (((Chat)object).getChatState() == Chat.ChatState.WAITING_ATTACHMENT_MESSAGE) {
                ((Chat)object).setChatState(Chat.ChatState.SENT);
            } else if (((Chat)object).getChatState() != Chat.ChatState.SENT) {
                ((Chat)object).setChatState(Chat.ChatState.READY_TO_BE_SENT);
            }
            ((Chat)object).getMessages().add(message);
            inMemoryCache = ChatsCacheManager.getCache();
            if (inMemoryCache != null) {
                inMemoryCache.put((Object)((Chat)object).getId(), object);
            }
        }
    }

    private void assignHangingMessageId(String string2) {
        this.messageId = string2;
    }

    private void updateHangingChat(Uri uri) {
        Chat chat = ChatsCacheManager.getChat(inMemoryCache.chatId);
        if (chat != null) {
            ArrayList<Message> arrayList = chat.getMessages();
            String string2 = inMemoryCache.messageId;
            for (int i = 0; i < arrayList.size(); ++i) {
                Message message = (Message)arrayList.get(i);
                InstabugSDKLogger.d((String)"IBG-Core", (String)("getting message with ID: " + message.getId()));
                if (!message.getId().equals(string2)) continue;
                super.updateHangingAttachment(message, uri);
                message.setMessageState(Message.MessageState.READY_TO_BE_SENT);
            }
            InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
            if (inMemoryCache != null) {
                inMemoryCache.put((Object)chat.getId(), (Object)chat);
            }
            InstabugSDKLogger.d((String)"IBG-Core", (String)"video is encoded and updated in its message");
            if (Instabug.getApplicationContext() != null) {
                InstabugMessageUploaderJob.getInstance().start();
            }
        } else {
            InstabugSDKLogger.e((String)"IBG-Core", (String)"Hanging Chat is null and can't be updated");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateHangingAttachment(Message cacheable2, Uri uri) {
        for (Attachment attachment : cacheable2.getAttachments()) {
            void var2_4;
            if (attachment.getType() == null || !attachment.getType().equals("extra_video")) continue;
            Attachment attachment2 = attachment;
            InstabugSDKLogger.d((String)"IBG-Core", (String)"Setting attachment type to Video");
            attachment.setName(var2_4.getLastPathSegment());
            attachment2.setLocalPath(var2_4.getPath());
            attachment2.setVideoEncoded(true);
            return;
        }
    }

    private void unsubscribe() {
        Disposable disposable = this.disposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.disposable.dispose();
        }
        if ((disposable = this.chatTriggeringDisposable) != null && !disposable.isDisposed()) {
            this.chatTriggeringDisposable.dispose();
        }
    }

    public void start(final String string2) {
        this.chatId = string2;
        InternalScreenRecordHelper.getInstance().init();
        Disposable disposable = this.disposable;
        if (disposable == null || disposable.isDisposed()) {
            this.disposable = ScreenRecordingEventBus.getInstance().subscribe(screenRecordingEvent -> {
                if (screenRecordingEvent.getStatus() == 2) {
                    ExternalScreenRecordHelper externalScreenRecordHelper = this;
                    externalScreenRecordHelper.startWithHangingChat(screenRecordingEvent.getVideoUri());
                    externalScreenRecordHelper.clear();
                } else if (screenRecordingEvent.getStatus() == 0) {
                    ExternalScreenRecordHelper externalScreenRecordHelper = this;
                    externalScreenRecordHelper.startWithHangingChat(screenRecordingEvent.getVideoUri());
                    InternalScreenRecordHelper.getInstance().release();
                    externalScreenRecordHelper.clear();
                } else if (screenRecordingEvent.getStatus() == 4) {
                    ExternalScreenRecordHelper externalScreenRecordHelper = this;
                    externalScreenRecordHelper.startWithHangingChat(null);
                    InternalScreenRecordHelper.getInstance().release();
                    externalScreenRecordHelper.clear();
                }
            });
        }
        this.chatTriggeringDisposable = ChatTriggeringEventBus.getInstance().subscribe((Consumer)new Consumer<TriggeredChat>(){

            public void accept(TriggeredChat triggeredChat) {
                if (string2.equalsIgnoreCase(triggeredChat.getOldChatId())) {
                    ExternalScreenRecordHelper.this.setChatId(triggeredChat.getNewChatId());
                }
            }
        });
    }

    public boolean isRecording() {
        return InternalScreenRecordHelper.getInstance().isRecording();
    }

    @Nullable
    public Uri getAutoScreenRecordingFileUri() {
        return InternalScreenRecordHelper.getInstance().getAutoScreenRecordingFileUri();
    }

    public void delete() {
        InternalScreenRecordHelper.getInstance().delete();
    }

    public void clear() {
        this.unsubscribe();
        InternalScreenRecordHelper.getInstance().clear();
    }

    public boolean isEnabled() {
        return InternalScreenRecordHelper.getInstance().isEnabled();
    }
}

