/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.network;

import androidx.annotation.Nullable;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.eventbus.ChatTimeUpdatedEventBus;
import com.instabug.chat.eventbus.ChatTriggeringEventBus;
import com.instabug.chat.eventbus.TriggeredChat;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.Message;
import com.instabug.chat.network.service.MessagingService;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;

public class InstabugMessageUploaderJob
extends InstabugNetworkJob {
    @Nullable
    private static InstabugMessageUploaderJob INSTANCE;

    public static synchronized InstabugMessageUploaderJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugMessageUploaderJob();
        }
        return INSTANCE;
    }

    private InstabugMessageUploaderJob() {
    }

    private static void uploadChats() {
        InstabugSDKLogger.v((String)"IBG-BR", (String)("Found " + ChatsCacheManager.getOfflineChats().size() + " offline chats in cache"));
        for (final Chat chat : ChatsCacheManager.getOfflineChats()) {
            if (chat.getChatState() != null && ((Object)((Object)chat.getChatState())).equals((Object)Chat.ChatState.READY_TO_BE_SENT) && chat.getMessages().size() > 0) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)("Uploading offline Chat: " + chat));
                MessagingService.getInstance().triggerChat(chat.getState(), new Request.Callbacks<String, Throwable>(){

                    public void onSucceeded(@Nullable String object) {
                        if (object != null) {
                            2 v0 = this;
                            String string2 = v0.chat.getId();
                            ChatTriggeringEventBus.getInstance().post(new TriggeredChat(string2, (String)object));
                            InstabugSDKLogger.v((String)"IBG-BR", (String)("Updating local chat with id: " + string2 + ", with synced chat with id: " + (String)object));
                            v0.chat.setId((String)object);
                            v0.chat.setChatState(Chat.ChatState.LOGS_READY_TO_BE_UPLOADED);
                            object = ChatsCacheManager.getCache();
                            if (object != null) {
                                InMemoryCache<String, Chat> inMemoryCache = object;
                                2 v2 = this;
                                object.delete((Object)string2);
                                object = v2.chat.getId();
                                inMemoryCache.put(object, (Object)v2.chat);
                            }
                            ChatsCacheManager.saveCacheToDisk();
                            InstabugMessageUploaderJob.uploadChatLogs(chat);
                        }
                    }

                    public void onFailed(Throwable throwable) {
                        InstabugSDKLogger.e((String)"IBG-BR", (String)("Something went wrong while triggering offline chat with id: " + chat.getId()), (Throwable)throwable);
                    }
                });
                continue;
            }
            if (chat.getChatState() == null || !((Object)((Object)chat.getChatState())).equals((Object)Chat.ChatState.LOGS_READY_TO_BE_UPLOADED)) continue;
            InstabugSDKLogger.d((String)"IBG-BR", (String)("chat: " + chat.toString() + " already uploaded but has unsent logs, uploading now"));
            InstabugMessageUploaderJob.uploadChatLogs(chat);
        }
    }

    private static void uploadMessages(List<Message> list) {
        InstabugSDKLogger.v((String)"IBG-BR", (String)("Found " + list.size() + " offline messages in cache"));
        for (int i = 0; i < list.size(); ++i) {
            final Message message = list.get(i);
            if (message.getMessageState() == Message.MessageState.READY_TO_BE_SENT) {
                Request.Callbacks<String, Throwable> callbacks;
                InstabugSDKLogger.d((String)"IBG-BR", (String)("Uploading message: " + list.get(i)));
                Request.Callbacks<String, Throwable> callbacks2 = callbacks;
                callbacks = new Request.Callbacks<String, Throwable>(){

                    /*
                     * WARNING - void declaration
                     */
                    public void onSucceeded(@Nullable String inMemoryCache) {
                        block11: {
                            if (inMemoryCache != null && !inMemoryCache.equals((Object)"") && !inMemoryCache.equals((Object)"null")) {
                                InstabugSDKLogger.d((String)"IBG-BR", (String)"Send message Request succeeded");
                                Chat chat = ChatsCacheManager.getChat(message.getChatId());
                                if (chat != null) {
                                    3 v0 = this;
                                    chat.getMessages().remove(message);
                                    v0.message.setId((String)inMemoryCache);
                                    if (v0.message.getAttachments().size() == 0) {
                                        message.setMessageState(Message.MessageState.READY_TO_BE_SYNCED);
                                    } else {
                                        message.setMessageState(Message.MessageState.SENT);
                                    }
                                    InstabugSDKLogger.v((String)"IBG-BR", (String)("Caching sent message:" + message.toString()));
                                    chat.getMessages().add(message);
                                    inMemoryCache = ChatsCacheManager.getCache();
                                    if (inMemoryCache != null) {
                                        inMemoryCache.put((Object)chat.getId(), (Object)chat);
                                    }
                                    ChatsCacheManager.saveCacheToDisk();
                                    if (message.getAttachments().size() == 0) {
                                        ChatSettings.setLastChatTime(Calendar.getInstance(Locale.ENGLISH).getTime().getTime());
                                        ChatTimeUpdatedEventBus.getInstance().post(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
                                    } else {
                                        void var0_3;
                                        try {
                                            InstabugMessageUploaderJob.uploadAttachments(message);
                                            break block11;
                                        }
                                        catch (FileNotFoundException fileNotFoundException) {
                                        }
                                        catch (JSONException jSONException) {
                                            // empty catch block
                                        }
                                        InstabugSDKLogger.e((String)"IBG-BR", (String)("Something went wrong while uploading messageattach attachments " + var0_3.getMessage()));
                                    }
                                } else {
                                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Chat is null so can't remove message from it");
                                }
                            }
                        }
                    }

                    public void onFailed(Throwable throwable) {
                        InstabugSDKLogger.e((String)"IBG-BR", (String)"Something went wrong while uploading cached message", (Throwable)throwable);
                    }
                };
                MessagingService.getInstance().sendMessage(message, callbacks2);
                continue;
            }
            if (message.getMessageState() != Message.MessageState.SENT) continue;
            InstabugSDKLogger.d((String)"IBG-BR", (String)("Uploading message's attachments : " + list.get(i)));
            try {
                InstabugMessageUploaderJob.uploadAttachments(message);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            InstabugSDKLogger.e((String)"IBG-BR", (String)("Something went wrong while uploading message attachments " + ((Throwable)((Object)message)).getMessage()));
        }
    }

    private static void uploadAttachments(final Message message) {
        Request.Callbacks<Boolean, Message> callbacks;
        InstabugSDKLogger.d((String)"IBG-BR", (String)("Found " + message.getAttachments().size() + " attachments related to message: " + message.getBody()));
        Request.Callbacks<Boolean, Message> callbacks2 = callbacks;
        callbacks = new Request.Callbacks<Boolean, Message>(){

            public void onSucceeded(@Nullable Boolean serializable) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"Message attachments uploaded successfully");
                serializable = ChatsCacheManager.getChat(inMemoryCache.message.getChatId());
                if (serializable != null) {
                    ((Chat)serializable).getMessages().remove(inMemoryCache.message);
                    inMemoryCache.message.setMessageState(Message.MessageState.READY_TO_BE_SYNCED);
                    for (int i = 0; i < inMemoryCache.message.getAttachments().size(); ++i) {
                        inMemoryCache.message.getAttachments().get(i).setState("synced");
                    }
                    InstabugSDKLogger.v((String)"IBG-BR", (String)("Caching sent message:" + inMemoryCache.message.toString()));
                    ((Chat)serializable).getMessages().add(inMemoryCache.message);
                    InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
                    if (inMemoryCache != null) {
                        inMemoryCache.put((Object)((Chat)serializable).getId(), (Object)serializable);
                    }
                    ChatsCacheManager.saveCacheToDisk();
                    ChatSettings.setLastChatTime(Calendar.getInstance(Locale.ENGLISH).getTime().getTime());
                    ChatTimeUpdatedEventBus.getInstance().post(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
                } else {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Chat is null so can't remove message from it");
                }
            }

            public void onFailed(Message message2) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"Something went wrong while uploading message attachments");
            }
        };
        MessagingService.getInstance().uploadMessageAttachments(message, callbacks2);
    }

    private static void uploadChatLogs(final Chat chat) {
        Request.Callbacks<Boolean, Chat> callbacks;
        InstabugSDKLogger.d((String)"IBG-BR", (String)("START uploading all logs related to this chat id = " + chat.getId()));
        Request.Callbacks<Boolean, Chat> callbacks2 = callbacks;
        callbacks = new Request.Callbacks<Boolean, Chat>(){

            public void onSucceeded(@Nullable Boolean bl) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"chat logs uploaded successfully, changing its state");
                chat.setChatState(Chat.ChatState.SENT);
                ChatsCacheManager.saveCacheToDisk();
            }

            public void onFailed(Chat chat2) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"Something went wrong while uploading chat logs");
            }
        };
        MessagingService.getInstance().uploadChatLogs(chat, callbacks2);
    }

    public void start() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (Instabug.getApplicationContext() != null) {
                    try {
                        InstabugMessageUploaderJob.uploadChats();
                        InstabugMessageUploaderJob.uploadMessages(ChatsCacheManager.getOfflineMessages());
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e((String)"IBG-BR", (String)("Error " + exception.getMessage() + " occurred while uploading messages"), (Throwable)exception);
                    }
                } else {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Context was null while uploading messages");
                }
            }
        };
        this.enqueueJob("CHATS", runnable2);
    }
}

