/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.model;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class Attachment
implements Cacheable,
Serializable {
    @Nullable
    private String name;
    @Nullable
    private String localPath;
    @Nullable
    private String url;
    @Nullable
    private String type;
    @Nullable
    private String state;
    private boolean isVideoEncoded;
    @Nullable
    private String duration;

    public Attachment() {
        Attachment attachment = this;
        attachment.isVideoEncoded = false;
        attachment.setType("not_available");
        attachment.setState("not_available");
    }

    public static JSONArray toJson(ArrayList<Attachment> arrayList) {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            jSONArray2.put((Object)new JSONObject(arrayList.get(i).toJson()));
        }
        return jSONArray2;
    }

    public static ArrayList<Attachment> fromJson(JSONArray jSONArray) {
        ArrayList<Attachment> arrayList;
        ArrayList<Attachment> arrayList2 = arrayList;
        arrayList = new ArrayList<Attachment>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            Attachment attachment;
            Attachment attachment2 = attachment;
            attachment2();
            attachment.fromJson(jSONArray.getJSONObject(i).toString());
            arrayList2.add(attachment);
        }
        return arrayList2;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public Attachment setName(@Nullable String string2) {
        this.name = string2;
        return this;
    }

    @Nullable
    public String getLocalPath() {
        return this.localPath;
    }

    public Attachment setLocalPath(@Nullable String string2) {
        this.localPath = string2;
        return this;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public Attachment setUrl(String string2) {
        this.url = string2;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public Attachment setType(String string2) {
        this.type = string2;
        return this;
    }

    public boolean isVideoEncoded() {
        return this.isVideoEncoded;
    }

    public Attachment setVideoEncoded(boolean bl) {
        this.isVideoEncoded = bl;
        return this;
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String getFileType() {
        String string2 = MimeTypeMap.getFileExtensionFromUrl((String)this.getName());
        if (string2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
            string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
            if (string2 == null || string2.equals("")) {
                string2 = this.getType();
            }
            return string2;
        }
        return this.getType();
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    public Attachment setState(String string2) {
        this.state = string2;
        return this;
    }

    @Nullable
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(@Nullable String string2) {
        this.duration = string2;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject.put("name", (Object)this.getName()).put("local_path", (Object)this.getLocalPath()).put("url", (Object)this.getUrl()).put("type", (Object)this.getType()).put("video_encoded", this.isVideoEncoded()).put("duration", (Object)this.getDuration());
        if (this.getState() != null) {
            jSONObject2.put("attachment_state", (Object)this.getState().toString());
        }
        return jSONObject2.toString();
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void fromJson(String string2) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject(string2).has("name")) {
            this.setName(jSONObject2.getString("name"));
        }
        if (jSONObject2.has("local_path")) {
            this.setLocalPath(jSONObject2.getString("local_path"));
        }
        if (jSONObject2.has("url")) {
            this.setUrl(jSONObject2.getString("url"));
        }
        if (jSONObject2.has("type")) {
            string2 = jSONObject2.getString("type");
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1830389646: {
                    if (!string2.equals("video_gallery")) break;
                    n = 6;
                    break;
                }
                case 1710800780: {
                    if (!string2.equals("extra_video")) break;
                    n = 5;
                    break;
                }
                case 1698911340: {
                    if (!string2.equals("extra_image")) break;
                    n = 4;
                    break;
                }
                case 112202875: {
                    if (!string2.equals("video")) break;
                    n = 3;
                    break;
                }
                case 100313435: {
                    if (!string2.equals("image")) break;
                    n = 2;
                    break;
                }
                case 93166550: {
                    if (!string2.equals("audio")) break;
                    n = 1;
                    break;
                }
                case -831439762: {
                    if (!string2.equals("image_gallery")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    this.setType("not_available");
                    break;
                }
                case 6: {
                    this.setType("video_gallery");
                    break;
                }
                case 5: {
                    this.setType("extra_video");
                    break;
                }
                case 4: {
                    this.setType("extra_image");
                    break;
                }
                case 3: {
                    this.setType("video");
                    break;
                }
                case 2: {
                    this.setType("image");
                    break;
                }
                case 1: {
                    this.setType("audio");
                    break;
                }
                case 0: {
                    this.setType("image_gallery");
                }
            }
        }
        if (jSONObject2.has("attachment_state")) {
            string2 = jSONObject2.getString("attachment_state");
            string2.hashCode();
            if (!string2.equals("offline")) {
                if (!string2.equals("synced")) {
                    this.setState("not_available");
                } else {
                    this.setState("synced");
                }
            } else {
                this.setState("offline");
            }
        }
        if (jSONObject2.has("video_encoded")) {
            this.setVideoEncoded(jSONObject2.getBoolean("video_encoded"));
        }
        if (jSONObject2.has("duration")) {
            this.setDuration(jSONObject2.getString("duration"));
        }
    }

    @NonNull
    public String toString() {
        return "Name: " + this.getName() + ", Local Path: " + this.getLocalPath() + ", Type: " + this.getType() + ", Url: " + this.getUrl() + ", Attachment State: " + this.getState();
    }

    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION"})
    public boolean equals(Object object) {
        if (object != null && object instanceof Attachment) {
            return String.valueOf(((Attachment)(object = (Attachment)object)).getName()).equals(String.valueOf(this.getName())) && String.valueOf(((Attachment)object).getLocalPath()).equals(String.valueOf(this.getLocalPath())) && String.valueOf(((Attachment)object).getUrl()).equals(String.valueOf(this.getUrl())) && ((Attachment)object).getType() != null && this.getType() != null && ((Attachment)object).getType().equals(this.getType()) && ((Attachment)object).getState() != null && this.getState() != null && ((Attachment)object).getState().equals(this.getState()) && ((Attachment)object).isVideoEncoded() == this.isVideoEncoded() && String.valueOf(((Attachment)object).getDuration()).equals(String.valueOf(this.getDuration()));
        }
        return false;
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return -1;
    }
}

