/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.bug.R;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;

public class ShapeSuggestionsLayout
extends LinearLayout {
    private float cornerRadius;
    @Nullable
    private OnShapeSuggestionSelectedListener onShapeSuggestionSelectedListener;
    private boolean hidden;
    private final Runnable hideRunnable;
    @Nullable
    private Handler hideHandler;

    public ShapeSuggestionsLayout(Context context) {
        this(context, null);
    }

    public ShapeSuggestionsLayout(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public ShapeSuggestionsLayout(Context context, @Nullable AttributeSet object, int n) {
        Handler handler;
        Runnable runnable;
        ShapeSuggestionsLayout shapeSuggestionsLayout = shapeSuggestionsLayout2;
        super(context, object, n);
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                ShapeSuggestionsLayout.this.hide();
            }
        };
        shapeSuggestionsLayout.hideRunnable = object;
        ShapeSuggestionsLayout shapeSuggestionsLayout2 = handler;
        handler = new Handler();
        shapeSuggestionsLayout.hideHandler = shapeSuggestionsLayout2;
        shapeSuggestionsLayout.init(context);
    }

    private void init(Context context) {
        GradientDrawable gradientDrawable;
        ShapeSuggestionsLayout shapeSuggestionsLayout = this;
        shapeSuggestionsLayout.setVisibility(4);
        shapeSuggestionsLayout.setGravity(17);
        context = context.getResources().getDisplayMetrics();
        this.cornerRadius = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)context);
        int n = (int)TypedValue.applyDimension((int)1, (float)1.5f, (DisplayMetrics)context);
        GradientDrawable gradientDrawable2 = gradientDrawable;
        gradientDrawable2();
        gradientDrawable2.setColor(AttrResolver.getBackgroundColor((Context)this.getContext()));
        gradientDrawable2.setCornerRadius(this.cornerRadius);
        gradientDrawable.setStroke(n, AttrResolver.getDividerColor((Context)this.getContext()));
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground((Drawable)gradientDrawable2);
        } else {
            this.setBackgroundDrawable((Drawable)gradientDrawable2);
        }
    }

    private void selectChild(int n) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setBackgroundColor(0);
        }
        this.getChildAt(n).setBackgroundColor(AttrResolver.getDividerColor((Context)this.getContext()));
    }

    protected void onConfigurationChanged(Configuration configuration) {
        ShapeSuggestionsLayout shapeSuggestionsLayout = this;
        super.onConfigurationChanged(configuration);
        if (!shapeSuggestionsLayout.hidden) {
            ShapeSuggestionsLayout shapeSuggestionsLayout2 = this;
            shapeSuggestionsLayout2.hide();
            shapeSuggestionsLayout2.show();
        }
    }

    public void setOnShapeSelectedListener(OnShapeSuggestionSelectedListener onShapeSuggestionSelectedListener) {
        this.onShapeSuggestionSelectedListener = onShapeSuggestionSelectedListener;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void show() {
        if (!this.hidden) {
            return;
        }
        ShapeSuggestionsLayout shapeSuggestionsLayout = this;
        shapeSuggestionsLayout.hidden = false;
        shapeSuggestionsLayout.setVisibility(0);
        shapeSuggestionsLayout.animate().alpha(1.0f).setDuration(400L).setListener(null);
        if (shapeSuggestionsLayout.hideHandler != null && !AccessibilityUtils.isTalkbackEnabled()) {
            this.hideHandler.postDelayed(this.hideRunnable, 3000L);
        }
    }

    protected void onDetachedFromWindow() {
        ShapeSuggestionsLayout shapeSuggestionsLayout = this;
        super.onDetachedFromWindow();
        Handler handler = shapeSuggestionsLayout.hideHandler;
        if (handler != null) {
            handler.removeCallbacks(this.hideRunnable);
            this.hideHandler = null;
        }
    }

    void hide() {
        Handler handler = this.hideHandler;
        if (handler != null) {
            handler.removeCallbacks(this.hideRunnable);
        }
        if (this.hidden) {
            return;
        }
        this.hidden = true;
        this.animate().alpha(0.0f).setDuration(400L).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                2 v0 = this;
                v0.ShapeSuggestionsLayout.this.setVisibility(4);
                v0.ShapeSuggestionsLayout.this.removeAllViews();
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
    }

    public void addShapeSuggestion(@StringRes int n, Path path) {
        ShapeSuggestionsLayout shapeSuggestionsLayout = this;
        ShapeSuggestionsLayout shapeSuggestionsLayout2 = this;
        Context context = shapeSuggestionsLayout2.getContext();
        int n2 = AttrResolver.getTintingColor((Context)shapeSuggestionsLayout2.getContext());
        PathView pathView = shapeSuggestionsLayout2.new PathView(context, path, n2);
        pathView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                3 v0 = this;
                int n = v0.ShapeSuggestionsLayout.this.indexOfChild(view);
                v0.ShapeSuggestionsLayout.this.selectChild(n);
                if (v0.ShapeSuggestionsLayout.this.onShapeSuggestionSelectedListener != null) {
                    ShapeSuggestionsLayout.this.onShapeSuggestionSelectedListener.onShapeSelected(n);
                }
                ShapeSuggestionsLayout.this.hide();
            }
        });
        pathView.setFocusable(true);
        pathView.setClickable(true);
        pathView.setContentDescription(this.getContext().getString(n));
        ViewCompat.setAccessibilityDelegate((View)pathView, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setRoleDescription((CharSequence)"Button");
            }
        });
        shapeSuggestionsLayout.addView(pathView);
        shapeSuggestionsLayout.selectChild(0);
    }

    static interface OnShapeSuggestionSelectedListener {
        public void onShapeSelected(int var1);
    }

    private final class PathView
    extends View {
        private Path path;
        @Nullable
        private Path resizedPath;
        private Paint paint;
        @Nullable
        private RectF viewBounds;
        @ColorInt
        private int backgroundColor;
        @ColorInt
        private int pathColor;

        public PathView(Context context, Path path, int n) {
            Paint paint;
            super(context);
            this.path = path;
            ShapeSuggestionsLayout.this = paint;
            super(1);
            this.paint = ShapeSuggestionsLayout.this;
            paint.setStrokeWidth(4.0f);
            this.pathColor = n;
        }

        protected void onMeasure(int n, int n2) {
            RectF rectF;
            float f;
            PathView pathView = this;
            super.onMeasure(n, n2);
            n = (int)pathView.getResources().getDimension(R.dimen.instabug_path_view_margin);
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)pathView.getLayoutParams();
            int n3 = n;
            layoutParams.setMargins(n3, n3, n3, n3);
            pathView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            n = (int)pathView.getResources().getDimension(R.dimen.instabug_path_view_dimen);
            pathView.setMeasuredDimension(n, n);
            float f2 = f = (float)n;
            pathView.viewBounds = new RectF(0.0f, 0.0f, f2, f2);
            RectF rectF2 = rectF;
            new RectF(this.viewBounds).inset(8.0f, 8.0f);
            pathView.resizedPath = pathView.resizePath(pathView.path, rectF2);
        }

        protected void onDraw(Canvas canvas) {
            PathView pathView = this;
            super.onDraw(canvas);
            pathView.paint.setColor(this.backgroundColor);
            pathView.paint.setStyle(Paint.Style.FILL);
            RectF rectF = pathView.viewBounds;
            if (rectF != null) {
                PathView pathView2 = this;
                float f = pathView2.ShapeSuggestionsLayout.this.cornerRadius;
                float f2 = pathView2.ShapeSuggestionsLayout.this.cornerRadius;
                Paint paint = pathView2.paint;
                canvas.drawRoundRect(rectF, f, f2, paint);
            }
            PathView pathView3 = this;
            pathView3.paint.setColor(this.pathColor);
            pathView3.paint.setStyle(Paint.Style.STROKE);
            rectF = pathView3.resizedPath;
            if (rectF != null) {
                canvas.drawPath((Path)rectF, this.paint);
            }
        }

        public void setBackgroundColor(@ColorInt int n) {
            this.backgroundColor = n;
            this.invalidate();
        }

        public Path resizePath(Path path, RectF rectF) {
            Matrix matrix;
            RectF rectF2;
            Path path2 = new Path(path);
            PathView pathView = rectF2;
            rectF2 = new RectF();
            path2.computeBounds((RectF)pathView, true);
            path = matrix;
            Matrix.ScaleToFit scaleToFit = Matrix.ScaleToFit.CENTER;
            new Matrix().setRectToRect((RectF)pathView, rectF, scaleToFit);
            path2.transform((Matrix)path);
            return path2;
        }
    }
}

