/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.reporting;

import android.net.Uri;
import com.instabug.bug.BugPlugin;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.view.BugReportingContract$View;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.internal.video.ScreenRecordingEvent;
import com.instabug.library.model.Attachment;
import io.reactivexport.disposables.CompositeDisposable;
import io.reactivexport.functions.Consumer;
import java.lang.ref.Reference;

public class BaseReportingContainerPresenter
extends BasePresenter<BugReportingContract$View>
implements BaseContract.Presenter {
    private final CompositeDisposable compositeDisposable = new CompositeDisposable();

    public BaseReportingContainerPresenter(final BugReportingContract$View bugReportingContract$View) {
        super((BaseContract.View)bugReportingContract$View);
        this.compositeDisposable.add(InstabugStateEventBus.getInstance().getEventObservable().subscribe((Consumer)new Consumer<InstabugState>(){

            public void accept(InstabugState object) {
                if (object == InstabugState.DISABLED) {
                    object = (BugPlugin)InstabugCore.getXPlugin(BugPlugin.class);
                    if (object != null) {
                        object.setState(0);
                    }
                    ScreenRecordingEventBus.getInstance().post((Object)new ScreenRecordingEvent(3, null));
                    bugReportingContract$View.dismissReport();
                }
            }
        }));
    }

    private void prepareAskAQuestion() {
        if (LiveBugManager.getInstance().getBug() == null) {
            return;
        }
        LiveBugManager.getInstance().getBug().setType("ask a question");
        Object object = LiveBugManager.getInstance().getBug().getInitialScreenshotPath();
        if (!LiveBugManager.getInstance().getBug().hasMainScreenshot() && object != null) {
            LiveBugManager.getInstance().getBug().addAttachment(Uri.parse((String)object), Attachment.Type.MAIN_SCREENSHOT);
        }
        if ((object = this.view) != null && (object = (BugReportingContract$View)((Reference)object).get()) != null) {
            object.startAskQuestion();
        }
        this.handlePoweredByFooter();
    }

    private void prepareFrustratingExperience() {
        if (LiveBugManager.getInstance().getBug() == null) {
            return;
        }
        LiveBugManager.getInstance().getBug().setType("Frustrating experience");
        Object object = LiveBugManager.getInstance().getBug().getInitialScreenshotPath();
        if (!LiveBugManager.getInstance().getBug().hasMainScreenshot() && object != null) {
            LiveBugManager.getInstance().getBug().addAttachment(Uri.parse((String)object), Attachment.Type.MAIN_SCREENSHOT);
        }
        if ((object = this.view) != null && (object = (BugReportingContract$View)((Reference)object).get()) != null) {
            object.startFrustratingExperience();
        }
        this.handlePoweredByFooter();
    }

    public void handleBugProcess(int n) {
        Object object = this.view;
        if (object != null && (object = (BugReportingContract$View)((Reference)object).get()) != null) {
            switch (n) {
                default: {
                    break;
                }
                case 167: {
                    object.startWithHangingBug();
                    break;
                }
                case 164: {
                    this.prepareFrustratingExperience();
                    break;
                }
                case 163: {
                    this.prepareAskAQuestion();
                    break;
                }
                case 162: {
                    object.startBugReporter();
                    break;
                }
                case 161: {
                    object.startFeedbackSender();
                }
            }
        }
    }

    public void handlePoweredByFooter() {
        Object object = ((BasePresenter)object).view;
        if (object != null && (object = (BugReportingContract$View)((Reference)object).get()) != null) {
            object.handlePoweredByFooter();
        }
    }

    public void startNavigation() {
        Object object = ((BasePresenter)object).view;
        if (object != null && (object = (BugReportingContract$View)((Reference)object).get()) != null && LiveBugManager.getInstance().getBug() != null) {
            String string2 = LiveBugManager.getInstance().getBug().getType();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1621082316: {
                    if (!string2.equals("ask a question")) break;
                    n = 2;
                    break;
                }
                case 253684815: {
                    if (!string2.equals("not-available")) break;
                    n = 4;
                    break;
                }
                case 97908: {
                    if (!string2.equals("bug")) break;
                    n = 0;
                    break;
                }
                case -191501435: {
                    if (!string2.equals("feedback")) break;
                    n = 1;
                    break;
                }
                case -1562738717: {
                    if (!string2.equals("Frustrating experience")) break;
                    n = 3;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    object.startFrustratingExperience();
                    break;
                }
                case 2: {
                    object.startAskQuestion();
                    break;
                }
                case 1: {
                    object.navigateToFeedback();
                    break;
                }
                case 0: {
                    object.navigateToBugReporting();
                }
            }
        }
    }

    public void onDestroy() {
        BaseReportingContainerPresenter baseReportingContainerPresenter = this;
        super.onDestroy();
        CompositeDisposable compositeDisposable = baseReportingContainerPresenter.compositeDisposable;
        if (compositeDisposable != null && !compositeDisposable.isDisposed()) {
            this.compositeDisposable.dispose();
        }
    }
}

