/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.actionList.service;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.settings.BugSettings;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.TaskDebouncer;
import com.instabug.library.util.TimeUtils;
import org.json.JSONArray;
import org.json.JSONException;

public class FetchReportCategoriesJob
extends InstabugNetworkJob {
    @Nullable
    private static FetchReportCategoriesJob INSTANCE;
    private final TaskDebouncer taskDebouncer;
    private final NetworkManager networkManager = ServiceLocator.getNetworkManager();

    private FetchReportCategoriesJob() {
        this.taskDebouncer = ServiceLocator.getTaskDebouncer();
    }

    public static synchronized FetchReportCategoriesJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FetchReportCategoriesJob();
        }
        return INSTANCE;
    }

    private void getReportCategories(final @NonNull String string2) {
        Request.Callbacks<RequestResponse, Throwable> callbacks;
        InstabugSDKLogger.d((String)"IBG-BR", (String)"Getting report categories for this application");
        Request request = new Request.Builder().endpoint("/application_categories").method("GET").addParameter(new RequestParameter("locale", (Object)string2)).hasUuid(false).build();
        Request.Callbacks<RequestResponse, Throwable> callbacks2 = callbacks;
        callbacks = new Request.Callbacks<RequestResponse, Throwable>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onSucceeded(RequestResponse requestResponse) {
                JSONException jSONException2;
                block3: {
                    InstabugSDKLogger.d((String)"IBG-BR", (String)("getReportCategories request Succeeded, Response code: " + requestResponse.getResponseCode()));
                    InstabugSDKLogger.v((String)"IBG-BR", (String)("getReportCategories request Succeeded, Response body: " + requestResponse.getResponseBody()));
                    FetchReportCategoriesJob.setLastFetchedTime(System.currentTimeMillis());
                    ServiceLocator.getConfigurationsProvider().setLastFetchedLocale(string22.string2);
                    String string22 = (String)requestResponse.getResponseBody();
                    if (string22 == null) return;
                    try {
                        if (new JSONArray(string22).length() == 0) {
                            FetchReportCategoriesJob.onGetResponse(null);
                            return;
                        }
                    }
                    catch (JSONException jSONException2) {
                        break block3;
                    }
                    FetchReportCategoriesJob.onGetResponse(string22);
                    return;
                }
                jSONException2.printStackTrace();
            }

            public void onFailed(Throwable throwable) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"getReportCategories request got error", (Throwable)throwable);
            }
        };
        this.networkManager.doRequest("CORE", 1, request, (Request.Callbacks)callbacks2);
    }

    @VisibleForTesting
    public static long getLastFetchedAt() {
        return BugSettings.getInstance().getReportCategoriesLastFetchedTime();
    }

    @VisibleForTesting
    static void setLastFetchedTime(long l) {
        BugSettings.getInstance().setReportCategoriesLastFetchedTime(l);
    }

    @Nullable
    private static String getCurrentLocale() {
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            return LocaleUtils.getCurrentLocaleResolved((Context)context);
        }
        return null;
    }

    private static boolean shouldFetch(@Nullable String string2) {
        String string3 = ServiceLocator.getConfigurationsProvider().getLastFetchedLocale();
        return string2 != null && !string2.equals(string3) || TimeUtils.hasXHoursPassed((long)FetchReportCategoriesJob.getLastFetchedAt(), (long)86400000L);
    }

    private static void onGetResponse(@Nullable String string2) {
        BugSettings.getInstance().setRemoteReportCategories(string2);
    }

    public void resetLastFetchTimeout() {
        FetchReportCategoriesJob.setLastFetchedTime(0L);
        this.taskDebouncer.resetLastRun();
    }

    public void start() {
        String string2 = FetchReportCategoriesJob.getCurrentLocale();
        if (FetchReportCategoriesJob.shouldFetch(string2)) {
            FetchReportCategoriesJob fetchReportCategoriesJob = this;
            fetchReportCategoriesJob.enqueueJob("CORE", () -> this.taskDebouncer.debounce(() -> {
                if (Instabug.getApplicationContext() != null && string2 != null) {
                    try {
                        this.getReportCategories(string2);
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e((String)"IBG-BR", (String)"Error occurred while getting report categories", (Throwable)exception);
                    }
                } else {
                    InstabugSDKLogger.d((String)"IBG-BR", (String)"Context was null while getting report categories");
                }
            }));
        }
    }
}

