/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.view.WindowInsetsCompat;
import com.instabug.bug.R;
import com.instabug.bug.utils.BugReportingThemeResolver;
import com.instabug.chat.util.ViewUtilsKt;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugAppData;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.util.UiUtils;
import java.util.Locale;

public class InstabugThanksActivity
extends AppCompatActivity
implements _InstabugActivity {
    private void initViews() {
        ImageView imageView;
        String string2 = PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPORT_SUCCESSFULLY_SENT, (String)this.getSuccessNote());
        TextView textView = (TextView)this.findViewById(R.id.instabug_txt_success_note);
        if (textView != null) {
            textView.setText((CharSequence)string2);
        }
        if ((string2 = (TextView)this.findViewById(R.id.instabug_fragment_title)) != null) {
            string2.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.SUCCESS_DIALOG_HEADER, (String)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this), (int)R.string.instabug_str_thank_you, (Context)this)));
            if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                string2.setTextColor(InstabugCore.getPrimaryColor());
            } else {
                string2.setTextColor(ContextCompat.getColor((Context)this, (int)17170443));
            }
        }
        if ((imageView = (ImageView)this.findViewById(R.id.instabug_img_thanks)) != null) {
            imageView.setColorFilter(InstabugCore.getPrimaryColor());
            Drawable drawable2 = ContextCompat.getDrawable((Context)this, (int)R.drawable.ibg_bug_shape_thanks_background);
            if (drawable2 != null) {
                imageView.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable((Drawable)drawable2));
            }
        }
        InstabugThanksActivity instabugThanksActivity = this;
        imageView = instabugThanksActivity.findViewById(R.id.instabug_success_dialog_container);
        InstabugThanksActivity instabugThanksActivity2 = this;
        this.addPaddingToFitSystemWindow((View)imageView);
        instabugThanksActivity2.handlePoweredByFooter((View)imageView);
        imageView.setOnClickListener(view -> {
            InstabugThanksActivity instabugThanksActivity = this;
            instabugThanksActivity.setResult(-1);
            instabugThanksActivity.finish();
            instabugThanksActivity.overridePendingTransition(0x10A0000, 0x10A0001);
        });
        instabugThanksActivity.applyTheme(instabugThanksActivity.findViewById(R.id.ib_success_layout), (TextView)string2, textView);
    }

    private void addPaddingToFitSystemWindow(View view) {
        if (Build.VERSION.SDK_INT > 34 && view != null) {
            int n = WindowInsetsCompat.Type.systemBars();
            ViewUtilsKt.addSystemWindowInsetToPadding(view, true, true, true, true, n);
        }
    }

    protected void onCreate(@Nullable Bundle bundle) {
        InstabugThanksActivity instabugThanksActivity = this;
        StatusBarUtils.setStatusBar((Activity)instabugThanksActivity);
        LocaleUtils.setLocale((Activity)instabugThanksActivity, (Locale)InstabugCore.getLocale((Context)instabugThanksActivity));
        super.onCreate(bundle);
        if (InstabugCore.isFullScreen()) {
            UiUtils.showInFullscreen((Window)this.getWindow());
        }
        InstabugThanksActivity instabugThanksActivity2 = this;
        instabugThanksActivity2.setTheme(BugReportingThemeResolver.resolveTheme(InstabugCore.getTheme()));
        instabugThanksActivity2.setContentView(R.layout.ibg_bug_lyt_thanks);
        instabugThanksActivity2.initViews();
    }

    @VisibleForTesting
    void applyTheme(@Nullable View view, @Nullable TextView textView, @Nullable TextView textView2) {
        InstabugThanksActivity instabugThanksActivity = SettingsManager.getInstance().getIBGTheme();
        if (instabugThanksActivity != null) {
            if (view != null && instabugThanksActivity.getBackgroundColor() != 0) {
                view.setBackgroundColor(instabugThanksActivity.getBackgroundColor());
            }
            ThemeApplier.applyPrimaryTextStyle((TextView)textView, (IBGTheme)instabugThanksActivity);
            ThemeApplier.applySecondaryTextStyle((TextView)textView2, (IBGTheme)instabugThanksActivity);
        }
    }

    public void onStart() {
        InstabugThanksActivity instabugThanksActivity = this;
        super.onStart();
        instabugThanksActivity.overridePendingTransition(0x10A0000, 0x10A0001);
        if (AccessibilityUtils.isTalkbackEnabled() && Build.VERSION.SDK_INT >= 16) {
            AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain();
            accessibilityEvent.setEventType(16384);
            accessibilityEvent.setClassName((CharSequence)((Object)((Object)this)).getClass().getName());
            accessibilityEvent.setPackageName((CharSequence)this.getPackageName());
            accessibilityEvent.getText().add(LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this), (int)R.string.ibg_bug_report_thanks_title_content_description, (Context)this));
            TextView textView = (TextView)this.findViewById(R.id.instabug_fragment_title);
            if (textView != null) {
                accessibilityEvent.getText().add(textView.getText());
            }
            if ((textView = (TextView)this.findViewById(R.id.text_view_pb)) != null) {
                accessibilityEvent.getText().add(textView.getText());
            }
            ((AccessibilityManager)this.getSystemService("accessibility")).sendAccessibilityEvent(accessibilityEvent);
        }
    }

    protected void onResume() {
        super.onResume();
        new Handler(this.getMainLooper()).postDelayed(() -> {
            InstabugThanksActivity instabugThanksActivity = this;
            instabugThanksActivity.setResult(-1);
            instabugThanksActivity.finish();
            instabugThanksActivity.overridePendingTransition(0x10A0000, 0x10A0001);
        }, 4000L);
    }

    @VisibleForTesting
    void handlePoweredByFooter(View view) {
        InstabugCore.handlePbiFooter((View)view);
    }

    @VisibleForTesting
    String getSuccessNote() {
        String string2 = new InstabugAppData(this.getApplicationContext()).getAppName();
        if (string2 == null) {
            InstabugSDKLogger.w((String)"IBG-BR", (String)"It seems app:name isn't defined in your manifest. Using a generic name instead");
        }
        Object[] objectArray = InstabugCore.getLocale((Context)this);
        int n = R.string.instabug_str_success_note;
        if (string2 == null) {
            string2 = "App";
        }
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = string2;
        return LocaleUtils.getLocaleStringResource((Locale)objectArray2, (int)n, (Context)this, (Object[])objectArray);
    }
}

