/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.userConsent;

import com.instabug.bug.configurations.BugReportingConfigurationsProvider;
import com.instabug.bug.userConsent.UserConsent;
import com.instabug.bug.userConsent.UserConsentValidator;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0096\u0002J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u001e\u0010\u0013\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/instabug/bug/userConsent/UserConsentValidatorImpl;", "Lcom/instabug/bug/userConsent/UserConsentValidator;", "configs", "Lcom/instabug/bug/configurations/BugReportingConfigurationsProvider;", "(Lcom/instabug/bug/configurations/BugReportingConfigurationsProvider;)V", "invoke", "Lcom/instabug/bug/userConsent/UserConsent;", "consent", "currentConsentKeys", "", "", "isBelowConsentCountLimit", "", "it", "logInvalidKeyErrorIfRequired", "", "userConsent", "logWarning", "message", "logWarningIfPassedConsentCountLimit", "removedEmptyPrefixAndSuffix", "trimKeyIfRequired", "validateDescription", "instabug-bug_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nUserConsentValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserConsentValidator.kt\ncom/instabug/bug/userConsent/UserConsentValidatorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class UserConsentValidatorImpl
implements UserConsentValidator {
    @NotNull
    private final BugReportingConfigurationsProvider configs;

    public UserConsentValidatorImpl(@NotNull BugReportingConfigurationsProvider bugReportingConfigurationsProvider) {
        Intrinsics.checkNotNullParameter((Object)bugReportingConfigurationsProvider, (String)"configs");
        this.configs = bugReportingConfigurationsProvider;
    }

    private final UserConsent removedEmptyPrefixAndSuffix(UserConsent userConsent) {
        Object object = userConsent.getKey();
        object = object != null ? ((Object)StringsKt.trim((CharSequence)object)).toString() : null;
        String string2 = userConsent.getDescription();
        string2 = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
        UserConsent userConsent2 = Intrinsics.areEqual((Object)userConsent.getKey(), (Object)object) && Intrinsics.areEqual((Object)userConsent.getDescription(), (Object)string2) ? userConsent : null;
        if (userConsent2 == null) {
            userConsent2 = UserConsent.copy$default(userConsent, (String)object, string2, false, false, null, 28, null);
        }
        return userConsent2;
    }

    private final UserConsent trimKeyIfRequired(UserConsent object) {
        String string2 = ((UserConsent)object).getKey();
        if (string2 != null) {
            if (string2.length() <= ((UserConsentValidatorImpl)object2).configs.getConsentKeyLimitCharacterLimit()) {
                string2 = null;
            }
            if (string2 != null) {
                UserConsentValidatorImpl userConsentValidatorImpl = object2;
                Object object2 = userConsentValidatorImpl.configs.getConsentKeyLimitCharacterLimit();
                String string3 = String.format("{BugReporting.addUserConsent} User consent key exceeded the maximum character limit (%s) so it will be trimmed.", Arrays.copyOf(new Object[]{object2}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                userConsentValidatorImpl.logWarning(string3);
                String string4 = string2.substring(0, userConsentValidatorImpl.configs.getConsentKeyLimitCharacterLimit());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object2 = UserConsent.copy$default((UserConsent)object, string4, null, false, false, null, 30, null);
                if (object2 != null) {
                    object = object2;
                }
            }
        }
        return object;
    }

    private final void logWarningIfPassedConsentCountLimit(Set<String> object, UserConsent userConsent) {
        if (!((UserConsentValidatorImpl)object2).isBelowConsentCountLimit((Set<String>)object, userConsent)) {
            UserConsentValidatorImpl userConsentValidatorImpl = object2;
            Object object2 = CollectionsKt.first(object);
            object = userConsentValidatorImpl.configs.getConsentsLimit();
            String string2 = String.format("{BugReporting.addUserConsent} User consent with key \"%s\" was dropped as max allowed user consents reached. Please note that you can add up to %s user consents.", Arrays.copyOf(new Object[]{object2, object}, 2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            userConsentValidatorImpl.logWarning(string2);
        }
    }

    private final void logInvalidKeyErrorIfRequired(UserConsent userConsent) {
        if (userConsent == null) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"{BugReporting.addUserConsent} User consent wasn\u2019t added. key can't be null or empty.");
        }
    }

    private final boolean isBelowConsentCountLimit(Set<String> set, UserConsent userConsent) {
        return set.size() < this.configs.getConsentsLimit() || CollectionsKt.contains(set, (Object)userConsent.getKey());
    }

    private final UserConsent validateDescription(UserConsent object) {
        String string2 = ((UserConsent)object).getDescription();
        if (string2 != null) {
            Object object2;
            if (StringsKt.isBlank((CharSequence)string2)) {
                object2 = UserConsent.copy$default((UserConsent)object, null, null, false, false, null, 29, null);
            } else if (string2.length() > ((UserConsentValidatorImpl)object2).configs.getConsentDescriptionChaLimit()) {
                Object object3 = object2;
                object2 = ((UserConsentValidatorImpl)object3).configs.getConsentDescriptionChaLimit();
                String string3 = String.format("{BugReporting.addUserConsent} User consent description exceeded the maximum character limit (%s) so it will be trimmed.", Arrays.copyOf(new Object[]{object2}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                super.logWarning(string3);
                object2 = string2.substring(0, ((UserConsentValidatorImpl)object3).configs.getConsentDescriptionChaLimit());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object2 = UserConsent.copy$default((UserConsent)object, null, (String)object2, false, false, null, 29, null);
            } else {
                object2 = object;
            }
            if (object2 != null) {
                object = object2;
            }
        }
        return object;
    }

    private final void logWarning(String string2) {
        InstabugSDKLogger.w((String)"IBG-BR", (String)string2);
    }

    @Override
    @Nullable
    public UserConsent invoke(@NotNull UserConsent userConsent, @NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter((Object)userConsent, (String)"consent");
        Intrinsics.checkNotNullParameter(set, (String)"currentConsentKeys");
        String string2 = userConsent.getKey();
        if (string2 == null || StringsKt.isBlank((CharSequence)string2)) {
            userConsent = null;
        }
        if (userConsent != null && (userConsent = this.removedEmptyPrefixAndSuffix(userConsent)) != null && (userConsent = this.trimKeyIfRequired(userConsent)) != null && (userConsent = this.validateDescription(userConsent)) != null) {
            this.logWarningIfPassedConsentCountLimit(set, userConsent);
        } else {
            userConsent = null;
        }
        this.logInvalidKeyErrorIfRequired(userConsent);
        return userConsent;
    }
}

