/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

public class PersistableSettings {
    @Nullable
    private static PersistableSettings persistableSettings;
    @Nullable
    private SharedPreferences sharedPreferences;
    @Nullable
    private SharedPreferences.Editor sharedPreferencesEditor;

    private PersistableSettings(Context context) {
        context = CoreServiceLocator.getInstabugSharedPreferences((Context)context, (String)"instabug_bug_reporting");
        this.sharedPreferences = context;
        if (context != null) {
            this.sharedPreferencesEditor = context.edit();
        }
    }

    public static synchronized void init(Context context) {
        persistableSettings = new PersistableSettings(context);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static synchronized PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null) {
            PersistableSettings.init(Instabug.getApplicationContext());
        }
        return persistableSettings;
    }

    public long getLastBugTime() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return 0L;
        }
        return persistableSettings.getLong("last_bug_time", 0L);
    }

    public void setLastBugTime(long l) {
        SharedPreferences.Editor editor = this.sharedPreferencesEditor;
        if (editor == null) {
            return;
        }
        editor.putLong("last_bug_time", l);
        this.sharedPreferencesEditor.apply();
    }

    @Nullable
    String getRemoteReportCategories() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return null;
        }
        return persistableSettings.getString("ib_remote_report_categories", null);
    }

    public void setRemoteReportCategories(@Nullable String string2) {
        SharedPreferences.Editor editor = this.sharedPreferencesEditor;
        if (editor == null) {
            return;
        }
        editor.putString("ib_remote_report_categories", string2);
        this.sharedPreferencesEditor.apply();
    }

    public long getReportCategoriesLastFetchedTime() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return 0L;
        }
        return persistableSettings.getLong("report_categories_fetched_time", 0L);
    }

    public void setReportCategoriesLastFetchedTime(long l) {
        SharedPreferences.Editor editor = this.sharedPreferencesEditor;
        if (editor == null) {
            return;
        }
        editor.putLong("report_categories_fetched_time", l);
        this.sharedPreferencesEditor.apply();
    }

    public boolean isFirstRunAfterEncryptorUpdate() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return true;
        }
        return persistableSettings.getBoolean("ib_first_run_after_updating_encryptor", true);
    }

    public void setFirstRunAfterEncryptorUpdate(boolean bl) {
        SharedPreferences.Editor editor = this.sharedPreferencesEditor;
        if (editor == null) {
            return;
        }
        editor.putBoolean("ib_first_run_after_updating_encryptor", bl);
        this.sharedPreferencesEditor.apply();
    }
}

