/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.screenrecording;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.ReportingActivityLauncher;
import com.instabug.bug.internal.video.InternalScreenRecordHelper;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.internal.video.ScreenRecordingContract;
import com.instabug.library.model.Attachment;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import io.reactivexport.disposables.Disposable;

public class ExternalScreenRecordHelper
implements ScreenRecordingContract {
    private static ExternalScreenRecordHelper INSTANCE;
    @Nullable
    private Disposable disposable;

    public static ExternalScreenRecordHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExternalScreenRecordHelper();
        }
        return INSTANCE;
    }

    private void backToBugReport(@Nullable Uri uri) {
        ExternalScreenRecordHelper externalScreenRecordHelper = this;
        externalScreenRecordHelper.addVideoAttachment(uri);
        externalScreenRecordHelper.openReport();
    }

    @VisibleForTesting
    private void addVideoAttachment(@Nullable Uri uri) {
        if (uri != null && LiveBugManager.getInstance().getBug() != null) {
            LiveBugManager.getInstance().getBug().addAttachment(uri, Attachment.Type.EXTRA_VIDEO);
        }
    }

    private void openReport() {
        ExternalScreenRecordHelper externalScreenRecordHelper = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (externalScreenRecordHelper != null) {
            ExternalScreenRecordHelper externalScreenRecordHelper2 = externalScreenRecordHelper;
            externalScreenRecordHelper2.startActivity(ReportingActivityLauncher.newHangingBugIntent(externalScreenRecordHelper2.getApplicationContext()));
        }
    }

    private void unsubscribe() {
        Disposable disposable = this.disposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.disposable.dispose();
        }
    }

    public void start() {
        InternalScreenRecordHelper.getInstance().init();
        Disposable disposable = this.disposable;
        if (disposable == null || disposable.isDisposed()) {
            this.disposable = ScreenRecordingEventBus.getInstance().subscribe(screenRecordingEvent -> {
                if (screenRecordingEvent.getStatus() == 1) {
                    LiveBugManager.getInstance().setRecordingDuration(screenRecordingEvent.getVideoDuration());
                } else if (screenRecordingEvent.getStatus() == 2) {
                    ExternalScreenRecordHelper externalScreenRecordHelper = this;
                    externalScreenRecordHelper.backToBugReport(screenRecordingEvent.getVideoUri());
                    externalScreenRecordHelper.clear();
                } else if (screenRecordingEvent.getStatus() == 0) {
                    ExternalScreenRecordHelper externalScreenRecordHelper = this;
                    InternalScreenRecordHelper.getInstance().release();
                    externalScreenRecordHelper.backToBugReport(screenRecordingEvent.getVideoUri());
                    externalScreenRecordHelper.clear();
                } else if (screenRecordingEvent.getStatus() == 4) {
                    ExternalScreenRecordHelper externalScreenRecordHelper = this;
                    InternalScreenRecordHelper.getInstance().release();
                    externalScreenRecordHelper.backToBugReport(null);
                    externalScreenRecordHelper.clear();
                } else if (screenRecordingEvent.getStatus() == 3) {
                    InternalScreenRecordHelper.getInstance().release();
                    this.clear();
                }
            });
        }
    }

    public boolean isRecording() {
        return InternalScreenRecordHelper.getInstance().isRecording();
    }

    @Nullable
    public Uri getAutoScreenRecordingFileUri() {
        return InternalScreenRecordHelper.getInstance().getAutoScreenRecordingFileUri();
    }

    public void delete() {
        InternalScreenRecordHelper.getInstance().delete();
    }

    public void clear() {
        this.unsubscribe();
        InternalScreenRecordHelper.getInstance().clear();
    }

    public boolean isEnabled() {
        return InternalScreenRecordHelper.getInstance().isEnabled();
    }
}

