/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.util;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivexport.annotations.Nullable;

public class ShakeDetector
implements SensorEventListener {
    private final SensorManager sensorManager;
    @Nullable
    private final Sensor accelerometer;
    private long coordinatesLastUpdateTimeInMillis = 0L;
    private long lastDetectionTriggerTimeInMillis = 0L;
    private float lastX;
    private float lastY;
    private float lastZ;
    private OnShakeDetectedListener onShakeDetectedListener;
    private int accelerationThreshold = 650;

    public ShakeDetector(Context context, OnShakeDetectedListener onShakeDetectedListener) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.accelerometer = this.sensorManager.getDefaultSensor(1);
        this.onShakeDetectedListener = onShakeDetectedListener;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (sensorEvent.sensor.getType() == 1) {
            float f = sensorEvent.values[0];
            float f2 = sensorEvent.values[1];
            float f3 = sensorEvent.values[2];
            long l = System.currentTimeMillis();
            long l2 = l - this.coordinatesLastUpdateTimeInMillis;
            if (l2 > 400L) {
                float f4 = Math.abs(f + f2 + f3 - this.lastX - this.lastY - this.lastZ) / (float)l2 * 10000.0f;
                boolean bl = l - this.lastDetectionTriggerTimeInMillis > 2000L;
                if (f4 > (float)this.accelerationThreshold && bl) {
                    InstabugSDKLogger.d((String)"IBG-Core", (String)"shake detected, invoking shakeDetectedListener");
                    this.onShakeDetectedListener.onShakeDetected();
                }
                ShakeDetector shakeDetector = this;
                shakeDetector.coordinatesLastUpdateTimeInMillis = l;
                shakeDetector.lastX = f;
                shakeDetector.lastY = f2;
                shakeDetector.lastZ = f3;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    public void start() {
        this.lastDetectionTriggerTimeInMillis = System.currentTimeMillis();
        Sensor sensor = this.accelerometer;
        if (sensor != null) {
            this.sensorManager.registerListener((SensorEventListener)this, sensor, 3);
        } else {
            InstabugSDKLogger.e((String)"IBG-Core", (String)" accelerometer == null");
        }
    }

    public void stop() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    public void setAccelerationThreshold(int n) {
        this.accelerationThreshold = n;
    }

    public static interface OnShakeDetectedListener {
        public void onShakeDetected();
    }
}

