/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.invoker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.provider.MediaStore;
import androidx.annotation.Nullable;
import com.instabug.bug.invocation.InvocationListener;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.invocation.invoker.AbstractInvoker;
import com.instabug.bug.invocation.invoker.ScreenshotObserver;
import com.instabug.bug.utils.PermissionsUtils;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;

public class ScreenshotGestureInvoker
implements AbstractInvoker<Void> {
    @Nullable
    private ContentResolver contentResolver;
    private ScreenshotObserver screenshotObserver;
    private HandlerThread handlerThread;
    private Handler handler;
    private boolean shouldAskForPermission = true;
    private volatile boolean active;

    @SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED", "ERADICATE_PARAMETER_NOT_NULLABLE"})
    public ScreenshotGestureInvoker(InvocationListener invocationListener) {
        ScreenshotGestureInvoker screenshotGestureInvoker;
        if (Instabug.getApplicationContext() == null) {
            InstabugSDKLogger.e((String)"IBG-Core", (String)"ScreenshotGestureInvoker() called with null context");
            return;
        }
        screenshotGestureInvoker3.contentResolver = Instabug.getApplicationContext().getContentResolver();
        screenshotGestureInvoker3.handlerThread = new HandlerThread("ScreenshotObserver");
        screenshotGestureInvoker3.handlerThread.start();
        screenshotGestureInvoker3.handler = new Handler(screenshotGestureInvoker3.handlerThread.getLooper());
        ScreenshotGestureInvoker screenshotGestureInvoker2 = screenshotGestureInvoker3;
        ScreenshotGestureInvoker screenshotGestureInvoker3 = screenshotGestureInvoker2.handler;
        screenshotGestureInvoker.screenshotObserver = new ScreenshotObserver((Handler)screenshotGestureInvoker3, screenshotGestureInvoker2.contentResolver, invocationListener);
        screenshotGestureInvoker.subscribeToSessionState();
    }

    private void subscribeToSessionState() {
        IBGCoreEventSubscriber.subscribe(iBGSdkCoreEvent -> {
            if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.Session.SessionStarted) {
                this.shouldAskForPermission = true;
            }
        });
    }

    private void startObserving() {
        Object object;
        if (screenshotGestureInvoker3.isStoragePermissionGranted() && (object = screenshotGestureInvoker3.contentResolver) != null) {
            ScreenshotGestureInvoker screenshotGestureInvoker = screenshotGestureInvoker3;
            ContentResolver contentResolver = object;
            ScreenshotGestureInvoker screenshotGestureInvoker2 = screenshotGestureInvoker3;
            ScreenshotGestureInvoker screenshotGestureInvoker3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            object = screenshotGestureInvoker2.screenshotObserver;
            contentResolver.registerContentObserver((Uri)screenshotGestureInvoker3, true, (ContentObserver)object);
            screenshotGestureInvoker.active = true;
        }
    }

    private boolean isStoragePermissionGranted() {
        boolean bl = PermissionsUtils.isMediaStoragePermissionGranted((Context)InstabugInternalTrackingDelegate.getInstance().getCurrentActivity());
        InstabugSDKLogger.v((String)"IBG-Core", (String)("isStoragePermissionGranted = [" + bl + "]"));
        return bl;
    }

    private void requestExternalStorage() {
        Activity activity = InvocationManager.getInstance().getCurrentInstabugInvocationEvents();
        if (activity == null) {
            return;
        }
        int n = ((InstabugInvocationEvent[])activity).length;
        for (int i = 0; i < n; ++i) {
            if (activity[i] != InstabugInvocationEvent.SCREENSHOT) continue;
            activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
            if (activity == null) break;
            ScreenshotGestureInvoker.requestPermission(activity);
            this.shouldAskForPermission = false;
            break;
        }
    }

    private static void requestPermission(Activity activity) {
        try {
            PermissionsUtils.requestPermission(activity, PermissionsUtils.mediaStoragePermission(), 1, null, null);
        }
        catch (Exception exception) {
            if (Build.VERSION.SDK_INT == 33) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)"trying to request READ_MEDIA_IMAGES Without adding it to the manifest ", (Throwable)exception);
            }
            InstabugCore.reportError((Throwable)exception, (String)"Something Went Wrong while requesting Storage Permission");
        }
    }

    @Override
    public void listen() {
        if (this.shouldAskForPermission && !this.isStoragePermissionGranted()) {
            this.requestExternalStorage();
        } else {
            this.startObserving();
        }
    }

    @Override
    public void handle(Void void_) {
    }

    @Override
    public void sleep() {
        ContentResolver contentResolver = this.contentResolver;
        if (contentResolver != null) {
            contentResolver.unregisterContentObserver((ContentObserver)this.screenshotObserver);
            this.active = false;
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

