/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.invoker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.internal.video.InternalScreenRecordHelper;
import com.instabug.bug.view.floatingactionbutton.FloatingActionButton;
import com.instabug.bug.view.floatingactionbutton.MuteFloatingActionButton;
import com.instabug.bug.view.floatingactionbutton.RecordingFloatingActionButton;
import com.instabug.bug.view.floatingactionbutton.StopFloatingActionButton;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.CurrentActivityConfigurationChange;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.internal.media.AudioPlayer;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.view.BubbleTextView;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.KeyboardEventListener;
import com.instabug.library.util.KeyboardUtils;
import com.instabug.library.util.MicUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.library.util.TimeUtils;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivexport.disposables.CompositeDisposable;
import io.reactivexport.functions.Consumer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class ScreenRecordingFab
implements View.OnClickListener,
DefaultActivityLifeCycleEventHandler {
    @Nullable
    private FrameLayout.LayoutParams layoutParams;
    private final CompositeDisposable disposables;
    @VisibleForTesting
    @Nullable
    ActivityLifecycleSubscriber currentActivityLifeCycleSubscriber;
    private int x;
    private int y;
    private int width;
    private int height;
    private int realWidth;
    private int orientation;
    private float densityFactor;
    private int extraFloatingButtonSize;
    private boolean isRecording;
    private boolean expanded;
    private boolean isHintBubbleShown;
    private boolean isMicMuted;
    @Nullable
    private MuteFloatingActionButton muteButton;
    @Nullable
    private StopFloatingActionButton stopButton;
    @Nullable
    private BubbleTextView hintBubble;
    private int buttonSpacing;
    private int leftCorner;
    private int rightCorner;
    private int topCorner;
    private int bottomCorner;
    private final Handler handler;
    private long startTime;
    @Nullable
    private FrameLayout floatingButtonFrameLayout;
    private int floatingButtonSize;
    @Nullable
    private DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton;
    private final ScreenRecordingFloatingBtnEventListener listener;
    @Nullable
    private KeyboardEventListener keyboardEventListener;
    @Nullable
    private WeakReference<Activity> mCurrentActivity;
    private boolean isKeyboardOpen;
    private final Runnable updateTimeTask;

    private int getDurationInSeconds() {
        long l = this.startTime;
        return TimeUtils.millisToSeconds((long)(System.currentTimeMillis() - l));
    }

    private void announceDuration() {
        if (this.draggableRecordingFloatingActionButton == null) {
            return;
        }
        ScreenRecordingFab screenRecordingFab = this;
        AccessibilityUtils.sendTextEvent((String)screenRecordingFab.getAnnouncedDurationText(screenRecordingFab.getDurationInSeconds()));
    }

    private String getAnnouncedDurationText(long l) {
        String string2;
        Object object = object.draggableRecordingFloatingActionButton;
        if (object == null) {
            string2 = "";
        } else {
            int n = R.string.ibg_screen_recording_duration_for_accessibility;
            Long l2 = l;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = l2;
            string2 = object.getContext().getResources().getString(n, objectArray2);
        }
        return string2;
    }

    public ScreenRecordingFab(ScreenRecordingFloatingBtnEventListener screenRecordingFloatingBtnEventListener) {
        Runnable runnable;
        Handler handler;
        CompositeDisposable compositeDisposable;
        Object object = compositeDisposable;
        compositeDisposable = new CompositeDisposable();
        this.disposables = object;
        this.currentActivityLifeCycleSubscriber = null;
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
        this.realWidth = 0;
        this.orientation = 0;
        this.isRecording = false;
        this.expanded = false;
        this.isMicMuted = true;
        object = handler;
        handler = new Handler();
        this.handler = object;
        this.isKeyboardOpen = false;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (ScreenRecordingFab.this.isRecording) {
                    1 v0 = this;
                    long l = v0.ScreenRecordingFab.this.startTime;
                    l = System.currentTimeMillis() - l;
                    if (v0.ScreenRecordingFab.this.draggableRecordingFloatingActionButton != null) {
                        int n;
                        String string2 = AudioPlayer.getFormattedDurationText((long)l);
                        ScreenRecordingFab.this.draggableRecordingFloatingActionButton.setText(string2, true);
                        if (AccessibilityUtils.isTalkbackEnabled() && (n = TimeUtils.millisToSeconds((long)l)) != 0 && n % 10 == 0) {
                            ScreenRecordingFab.this.announceDuration();
                        }
                    }
                    if (l > 30000L) {
                        ScreenRecordingFab.this.listener.stop(ScreenRecordingFab.this.getDurationInSeconds());
                    }
                    ScreenRecordingFab.this.handler.postDelayed((Runnable)this, 1000L);
                }
            }
        };
        this.updateTimeTask = object;
        this.listener = screenRecordingFloatingBtnEventListener;
    }

    private void subscribeToCurrentActivityConfigChange() {
        this.disposables.add(CurrentActivityConfigurationChange.getInstance().subscribe((Consumer)new Consumer<CurrentActivityConfigurationChange>(){

            public void accept(CurrentActivityConfigurationChange currentActivityConfigurationChange) {
                if (currentActivityConfigurationChange.getNewConfig() != null) {
                    ScreenRecordingFab.this.handleConfigurationChange(currentActivityConfigurationChange.getNewConfig());
                }
            }
        }));
    }

    private void showFAB(Activity activity, int n, int n2) {
        DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton;
        StopFloatingActionButton stopFloatingActionButton;
        MuteFloatingActionButton muteFloatingActionButton;
        BubbleTextView bubbleTextView;
        Object object;
        DisplayMetrics displayMetrics;
        FrameLayout frameLayout;
        FrameLayout frameLayout2 = this.floatingButtonFrameLayout;
        if (frameLayout2 != null) {
            frameLayout2.removeAllViews();
        }
        Activity activity2 = activity;
        frameLayout2 = frameLayout;
        frameLayout = new FrameLayout((Context)activity);
        this.floatingButtonFrameLayout = frameLayout2;
        this.orientation = activity2.getResources().getConfiguration().orientation;
        this.densityFactor = activity2.getResources().getDisplayMetrics().density;
        frameLayout2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            activity.getWindowManager().getDefaultDisplay().getRealMetrics((DisplayMetrics)frameLayout2);
            this.realWidth = frameLayout2.widthPixels;
        }
        Activity activity3 = activity;
        this.floatingButtonSize = (int)activity3.getResources().getDimension(R.dimen.instabug_fab_size_normal);
        this.extraFloatingButtonSize = (int)activity3.getResources().getDimension(R.dimen.instabug_fab_size_mini);
        this.buttonSpacing = (int)activity3.getResources().getDimension(R.dimen.instabug_fab_actions_spacing);
        int n3 = ScreenUtility.getBottomInsets((Activity)activity3);
        this.leftCorner = 0;
        this.rightCorner = n - (this.floatingButtonSize + this.buttonSpacing);
        this.topCorner = StatusBarUtils.getStatusBarHeight((Activity)activity);
        this.bottomCorner = n2 - (this.floatingButtonSize + this.buttonSpacing + n3);
        this.hintBubble = object = bubbleTextView;
        new BubbleTextView((Context)activity).setText((CharSequence)PlaceHolderUtils.getPlaceHolder((Context)Instabug.getApplicationContext(), (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.VIDEO_RECORDING_FAB_BUBBLE_HINT, (int)R.string.instabug_str_video_recording_hint));
        object = muteFloatingActionButton;
        muteFloatingActionButton = new MuteFloatingActionButton((Context)activity);
        this.muteButton = object;
        if (!MicUtils.isAudioPermissionGranted() && this.muteButton.getVisibility() == 0) {
            this.muteButton.setVisibility(8);
        }
        if (this.isMicMuted) {
            this.muteButton.disable();
        } else {
            this.muteButton.enable();
        }
        this.muteButton.setOnClickListener(view -> {
            view = Instabug.getApplicationContext();
            if (view != null) {
                MuteFloatingActionButton muteFloatingActionButton = this.muteButton;
                if (muteFloatingActionButton != null && muteFloatingActionButton.toggle()) {
                    MicUtils.unmuteMic((Context)view);
                    this.isMicMuted = false;
                } else {
                    MicUtils.muteMic((Context)view);
                    this.isMicMuted = true;
                }
            }
        });
        object = stopFloatingActionButton;
        stopFloatingActionButton = new StopFloatingActionButton((Context)activity);
        this.stopButton = object;
        this.disposables.add(InternalScreenRecordHelper.getInstance().getIsStoppableObservable().subscribe(bl -> {
            Object object = object.stopButton;
            if (object != null) {
                object.setEnabled(bl);
            }
        }));
        object = this.stopButton;
        if (object != null) {
            object.setOnClickListener(view -> {
                if (this.isRecording) {
                    KeyboardUtils.hide((Activity)activity);
                    activity = this.listener;
                    if (activity != null) {
                        activity.stop(this.getDurationInSeconds());
                    }
                    this.isRecording = false;
                    this.handler.removeCallbacks(this.updateTimeTask);
                }
            });
        }
        object = draggableRecordingFloatingActionButton;
        draggableRecordingFloatingActionButton = new DraggableRecordingFloatingActionButton(this, activity);
        this.draggableRecordingFloatingActionButton = object;
        if (this.layoutParams == null) {
            FrameLayout.LayoutParams layoutParams;
            FrameLayout.LayoutParams layoutParams2 = layoutParams;
            int n4 = this.floatingButtonSize;
            layoutParams = new FrameLayout.LayoutParams(n4, n4, 51);
            this.layoutParams = layoutParams2;
            this.draggableRecordingFloatingActionButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            n = 4.$SwitchMap$com$instabug$library$invocation$util$InstabugVideoRecordingButtonPosition[SettingsManager.getInstance().getVideoRecordingButtonPosition().ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        this.draggableRecordingFloatingActionButton.setLocation(this.rightCorner, this.bottomCorner);
                    } else {
                        this.draggableRecordingFloatingActionButton.setLocation(this.rightCorner, this.topCorner);
                    }
                } else {
                    this.draggableRecordingFloatingActionButton.setLocation(this.leftCorner, this.topCorner);
                }
            } else {
                this.draggableRecordingFloatingActionButton.setLocation(this.leftCorner, this.bottomCorner);
            }
        } else {
            int n5;
            this.x = Math.round((float)(this.x * n) / (float)n);
            this.y = n5 = Math.round((float)(this.y * n2) / (float)n2);
            FrameLayout.LayoutParams layoutParams = this.layoutParams;
            int n6 = n;
            layoutParams.leftMargin = n = this.x;
            layoutParams.rightMargin = n6 - n;
            layoutParams.topMargin = n5;
            this.layoutParams.bottomMargin = n2 - n5;
            this.draggableRecordingFloatingActionButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.draggableRecordingFloatingActionButton.goToWall();
        }
        DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton2 = this.draggableRecordingFloatingActionButton;
        if (draggableRecordingFloatingActionButton2 != null) {
            draggableRecordingFloatingActionButton2.setOnClickListener(this);
            draggableRecordingFloatingActionButton2 = this.floatingButtonFrameLayout;
            if (draggableRecordingFloatingActionButton2 != null) {
                draggableRecordingFloatingActionButton2.addView((View)this.draggableRecordingFloatingActionButton);
            }
        }
        this.setRecordingButtonState();
        ((FrameLayout)activity.getWindow().getDecorView()).addView((View)this.floatingButtonFrameLayout, new ViewGroup.LayoutParams(-1, -1));
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (this.isKeyboardOpen(activity)) {
                this.isKeyboardOpen = true;
                activity = this.draggableRecordingFloatingActionButton;
                if (activity != null) {
                    ((DraggableRecordingFloatingActionButton)((Object)((Object)activity))).goToWall();
                }
            }
            if (!this.isRecording) {
                this.showHintBubble();
            }
        }, 100L);
        this.registerKeyboardListener(activity);
    }

    private boolean isKeyboardOpen(Activity activity) {
        ScreenRecordingFab screenRecordingFab = (InputMethodManager)activity.getSystemService("input_method");
        return screenRecordingFab != null && screenRecordingFab.isAcceptingText();
    }

    private void registerKeyboardListener(Activity activity) {
        KeyboardEventListener keyboardEventListener;
        KeyboardEventListener keyboardEventListener2;
        ScreenRecordingFab screenRecordingFab = this;
        KeyboardEventListener keyboardEventListener3 = keyboardEventListener2;
        keyboardEventListener2 = new WeakReference(activity);
        screenRecordingFab.mCurrentActivity = keyboardEventListener3;
        keyboardEventListener3 = keyboardEventListener;
        keyboardEventListener = new KeyboardEventListener(activity, bl -> {
            this.isKeyboardOpen = bl;
            if (bl) {
                this.handleKeyboardOpened();
            } else {
                this.handleKeyboardClosed();
            }
            if (this.expanded) {
                this.expand();
            }
        });
        screenRecordingFab.keyboardEventListener = keyboardEventListener3;
    }

    private void handleKeyboardOpened() {
        Object object = this.mCurrentActivity;
        object = object != null ? (Activity)object.get() : null;
        if (object == null) {
            return;
        }
        DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton = this.draggableRecordingFloatingActionButton;
        if (draggableRecordingFloatingActionButton != null) {
            int n = this.getBottomLocationWhenKeyboardOpened((Activity)object);
            int[] nArray = new int[]{0, 0};
            draggableRecordingFloatingActionButton.getLocationOnScreen(nArray);
            int n2 = nArray[0];
            int n3 = this.topCorner;
            if (nArray[1] == n3) {
                n = n3;
            }
            draggableRecordingFloatingActionButton.setLocation(n2, n);
        }
    }

    private int getBottomLocationWhenKeyboardOpened(@NonNull Activity activity) {
        Rect rect;
        View view = activity.getWindow().getDecorView().getRootView();
        activity = rect;
        view.getWindowVisibleDisplayFrame(new Rect());
        return activity.height() - this.buttonSpacing - this.floatingButtonSize;
    }

    private void handleKeyboardClosed() {
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        Object object = this.draggableRecordingFloatingActionButton;
        if (object != null) {
            object.getLocationOnScreen(nArray2);
        }
        if (nArray2[1] != this.topCorner && this.draggableRecordingFloatingActionButton != null) {
            int n;
            object = this.mCurrentActivity;
            if (object != null && ((Reference)object).get() != null) {
                this.height = ((Activity)this.mCurrentActivity.get()).getResources().getDisplayMetrics().heightPixels;
            }
            if ((n = nArray2[0]) == this.rightCorner) {
                this.bottomCorner = this.height - (this.floatingButtonSize + this.buttonSpacing);
            }
            ScreenRecordingFab screenRecordingFab = this;
            screenRecordingFab.draggableRecordingFloatingActionButton.setLocation(n, this.bottomCorner);
            if (screenRecordingFab.isHintBubbleShown) {
                this.hideHintBubble();
            }
            return;
        }
    }

    private void unregisterKeyboardListener() {
        screenRecordingFab.mCurrentActivity = null;
        ScreenRecordingFab screenRecordingFab = screenRecordingFab.keyboardEventListener;
        if (screenRecordingFab != null) {
            screenRecordingFab.unregisterKeyboardListener();
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void hideFAB() {
        ScreenRecordingFab screenRecordingFab = this;
        screenRecordingFab.unregisterKeyboardListener();
        DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton = screenRecordingFab.draggableRecordingFloatingActionButton;
        if (draggableRecordingFloatingActionButton != null) {
            draggableRecordingFloatingActionButton.setOnClickListener(null);
            this.draggableRecordingFloatingActionButton = null;
        }
        if ((draggableRecordingFloatingActionButton = this.floatingButtonFrameLayout) != null) {
            draggableRecordingFloatingActionButton.setOnClickListener(null);
            if (this.floatingButtonFrameLayout.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.floatingButtonFrameLayout.getParent()).removeView((View)this.floatingButtonFrameLayout);
            }
            this.floatingButtonFrameLayout = null;
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        if (this.currentActivityLifeCycleSubscriber == null) {
            this.currentActivityLifeCycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber((DefaultActivityLifeCycleEventHandler)this);
        }
        this.currentActivityLifeCycleSubscriber.subscribe();
    }

    private void setRecordingButtonState() {
        RecordingFloatingActionButton.RecordingState recordingState = object.isRecording ? RecordingFloatingActionButton.RecordingState.RECORDING : RecordingFloatingActionButton.RecordingState.STOPPED;
        Object object = object.draggableRecordingFloatingActionButton;
        if (object != null) {
            ((RecordingFloatingActionButton)((Object)object)).setRecordingState(recordingState);
        }
    }

    private void toggle() {
        if (this.expanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    private void expand() {
        StopFloatingActionButton stopFloatingActionButton;
        MuteFloatingActionButton muteFloatingActionButton;
        int n = 20;
        int n2 = this.topCorner;
        Object object = this.mCurrentActivity;
        object = object != null ? (Activity)object.get() : null;
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton = this.draggableRecordingFloatingActionButton;
        if (draggableRecordingFloatingActionButton != null) {
            draggableRecordingFloatingActionButton.getLocationOnScreen(nArray2);
        }
        if (this.isKeyboardOpen && object != null && nArray2[1] != this.topCorner) {
            n2 = this.getBottomLocationWhenKeyboardOpened((Activity)object);
        }
        if ((object = this.layoutParams) != null && (Math.abs(object.leftMargin - this.leftCorner) > n && Math.abs(this.layoutParams.leftMargin - this.rightCorner) > n || Math.abs(this.layoutParams.topMargin - n2) > n && Math.abs(this.layoutParams.topMargin - this.bottomCorner) > n)) {
            return;
        }
        this.setExtraButtonsLayoutParams();
        FloatingActionButton floatingActionButton = this.muteButton;
        if (floatingActionButton != null && floatingActionButton.getParent() != null) {
            ((ViewGroup)this.muteButton.getParent()).removeView((View)this.muteButton);
        }
        if ((floatingActionButton = this.floatingButtonFrameLayout) != null && (muteFloatingActionButton = this.muteButton) != null) {
            floatingActionButton.addView((View)muteFloatingActionButton);
            this.floatingButtonFrameLayout.setNextFocusForwardId(R.id.instabug_video_mute_button);
        }
        if ((floatingActionButton = this.stopButton) != null && floatingActionButton.getParent() != null) {
            ((ViewGroup)this.stopButton.getParent()).removeView((View)this.stopButton);
        }
        if ((floatingActionButton = this.floatingButtonFrameLayout) != null && (stopFloatingActionButton = this.stopButton) != null) {
            floatingActionButton.addView((View)stopFloatingActionButton);
        }
        this.expanded = true;
    }

    private void collapse() {
        FloatingActionButton floatingActionButton;
        FrameLayout frameLayout = this.floatingButtonFrameLayout;
        if (frameLayout != null && (floatingActionButton = this.muteButton) != null) {
            frameLayout.removeView((View)floatingActionButton);
        }
        if ((frameLayout = this.floatingButtonFrameLayout) != null && (floatingActionButton = this.stopButton) != null) {
            frameLayout.removeView((View)floatingActionButton);
        }
        this.expanded = false;
    }

    private void setExtraButtonsLayoutParams() {
        StopFloatingActionButton stopFloatingActionButton;
        MuteFloatingActionButton muteFloatingActionButton;
        int n;
        int n2;
        FrameLayout.LayoutParams layoutParams;
        FrameLayout.LayoutParams layoutParams2 = layoutParams;
        int n3 = this.extraFloatingButtonSize;
        layoutParams = new FrameLayout.LayoutParams(n3, n3);
        FrameLayout.LayoutParams n5 = this.layoutParams;
        if (n5 != null) {
            int layoutParams4 = this.floatingButtonSize;
            n2 = this.extraFloatingButtonSize;
            layoutParams2.leftMargin = n5.leftMargin + (layoutParams4 - n2) / 2;
            layoutParams2.rightMargin = n5.rightMargin + (layoutParams4 - n2) / 2;
        }
        FrameLayout.LayoutParams layoutParams3 = null;
        if (this.stopButton != null && n5 != null) {
            FrameLayout.LayoutParams layoutParams4;
            layoutParams3 = layoutParams4;
            layoutParams3(this.stopButton.getWidth(), this.stopButton.getHeight());
            n5 = this.layoutParams;
            n2 = this.floatingButtonSize;
            n = this.extraFloatingButtonSize;
            layoutParams4.leftMargin = n5.leftMargin + (n2 - n) / 2;
            layoutParams4.rightMargin = n5.rightMargin + (n2 - n) / 2;
        }
        ScreenRecordingFab screenRecordingFab = this;
        int muteFloatingActionButton2 = screenRecordingFab.extraFloatingButtonSize;
        n2 = this.buttonSpacing;
        n = (muteFloatingActionButton2 + n2 * 2) * 2;
        FrameLayout.LayoutParams n6 = screenRecordingFab.layoutParams;
        if (n6 != null) {
            int n4 = n6.topMargin;
            if (n4 > n) {
                n = n4 - (muteFloatingActionButton2 + n2);
                muteFloatingActionButton2 = n - (muteFloatingActionButton2 + n2);
            } else {
                n = n4 + this.floatingButtonSize + n2;
                muteFloatingActionButton2 = n + muteFloatingActionButton2 + n2;
            }
            if (layoutParams3 != null) {
                layoutParams3.topMargin = n;
            }
            layoutParams2.topMargin = muteFloatingActionButton2;
        }
        if ((muteFloatingActionButton = this.muteButton) != null) {
            muteFloatingActionButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        }
        if ((stopFloatingActionButton = this.stopButton) != null && layoutParams3 != null) {
            stopFloatingActionButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }
    }

    private void showHintBubble() {
        final FrameLayout.LayoutParams layoutParams = this.layoutParams;
        if (layoutParams != null && !this.isHintBubbleShown && layoutParams.leftMargin != this.leftCorner) {
            FrameLayout.LayoutParams layoutParams2;
            this.isHintBubbleShown = true;
            layoutParams = layoutParams2;
            layoutParams2 = new FrameLayout.LayoutParams(-2, -2);
            BubbleTextView bubbleTextView = this.hintBubble;
            if (bubbleTextView != null) {
                bubbleTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.hintBubble.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (ScreenRecordingFab.this.hintBubble != null && ScreenRecordingFab.this.layoutParams != null) {
                            layoutParams.leftMargin = ((ScreenRecordingFab)ScreenRecordingFab.this).layoutParams.leftMargin - ScreenRecordingFab.this.hintBubble.getWidth();
                            layoutParams.rightMargin = ScreenRecordingFab.this.width - ((ScreenRecordingFab)ScreenRecordingFab.this).layoutParams.leftMargin;
                            layoutParams.topMargin = ((ScreenRecordingFab)ScreenRecordingFab.this).layoutParams.topMargin + ((((ScreenRecordingFab)ScreenRecordingFab.this).layoutParams.height + ScreenRecordingFab.this.floatingButtonSize) / 2 - ScreenRecordingFab.this.hintBubble.getHeight()) / 2;
                            ScreenRecordingFab.this.hintBubble.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        }
                    }
                }, 100L);
            }
            if ((layoutParams = this.floatingButtonFrameLayout) != null && (this = this.hintBubble) != null) {
                layoutParams.addView((View)this);
            }
        }
    }

    private void hideHintBubble() {
        if (this.isHintBubbleShown) {
            this.isHintBubbleShown = false;
            FrameLayout frameLayout = this.floatingButtonFrameLayout;
            if (frameLayout != null && (this = this.hintBubble) != null) {
                frameLayout.removeView((View)this);
            }
        }
    }

    private boolean isExceedingMinDragLimit(float f, float f2) {
        return f != 0.0f && f2 != 0.0f && f * f2 > 1.0f || f * f2 < -1.0f;
    }

    private static float dpToPixel(Context context, float f) {
        return f * context.getResources().getDisplayMetrics().density;
    }

    static /* synthetic */ FrameLayout.LayoutParams access$902(ScreenRecordingFab screenRecordingFab, FrameLayout.LayoutParams layoutParams) {
        screenRecordingFab.layoutParams = layoutParams;
        return layoutParams;
    }

    static /* synthetic */ int access$1402(ScreenRecordingFab screenRecordingFab, int n) {
        screenRecordingFab.x = n;
        return n;
    }

    static /* synthetic */ int access$2002(ScreenRecordingFab screenRecordingFab, int n) {
        screenRecordingFab.y = n;
        return n;
    }

    public void init() {
        ScreenRecordingFab screenRecordingFab = this;
        screenRecordingFab.subscribeToCurranActivityLifeCycle();
        screenRecordingFab.subscribeToCurrentActivityConfigChange();
    }

    public void release() {
        ScreenRecordingFab screenRecordingFab = this;
        screenRecordingFab.handleKeyboardClosed();
        ActivityLifecycleSubscriber activityLifecycleSubscriber = screenRecordingFab.currentActivityLifeCycleSubscriber;
        if (activityLifecycleSubscriber != null) {
            activityLifecycleSubscriber.unsubscribe();
        }
        ScreenRecordingFab screenRecordingFab2 = this;
        screenRecordingFab2.disposables.clear();
        screenRecordingFab2.stop();
    }

    public void stop() {
        ScreenRecordingFab screenRecordingFab = this;
        screenRecordingFab.isRecording = false;
        screenRecordingFab.isMicMuted = true;
        screenRecordingFab.expanded = false;
        screenRecordingFab.handler.removeCallbacks(this.updateTimeTask);
        screenRecordingFab.hideFAB();
        screenRecordingFab.muteButton = null;
        screenRecordingFab.stopButton = null;
        screenRecordingFab.hintBubble = null;
    }

    public void stopAndWait() {
        this.listener.stop(this.getDurationInSeconds());
    }

    public void onClick(View object) {
        ScreenRecordingFab screenRecordingFab = this;
        screenRecordingFab.toggle();
        if (!screenRecordingFab.isRecording) {
            object = this.draggableRecordingFloatingActionButton;
            if (object != null) {
                object.setText("00:00", true);
            }
            this.isRecording = true;
            object = this.listener;
            if (object != null) {
                object.start();
            }
            if ((object = this.draggableRecordingFloatingActionButton) != null) {
                object.setRecordingState(RecordingFloatingActionButton.RecordingState.RECORDING);
            }
        }
        this.hideHintBubble();
    }

    @VisibleForTesting
    void handleConfigurationChange(Configuration configuration) {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            int n;
            this.handleActivityPaused();
            this.layoutParams = null;
            this.width = (int)ScreenRecordingFab.dpToPixel(activity.getApplicationContext(), configuration.screenWidthDp);
            this.height = n = (int)ScreenRecordingFab.dpToPixel(activity.getApplicationContext(), configuration.screenHeightDp);
            this.showFAB(activity, this.width, n);
        }
    }

    @MainThread
    public void handleActivityResumed() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity == null) {
            return;
        }
        if (ScreenUtility.getWindowHeight((Activity)activity) > 0) {
            this.showFab(activity);
        } else {
            PoolProvider.postDelayedTask(() -> PoolProvider.postMainThreadTask(() -> {
                Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
                if (activity != null) {
                    this.showFab(activity);
                }
            }), (long)500L);
        }
    }

    void showFab(@NonNull Activity activity) {
        int n;
        this.height = ScreenUtility.getWindowHeight((Activity)activity);
        this.width = n = ScreenUtility.getWindowWidth((Activity)activity);
        this.showFAB(activity, n, this.height);
    }

    @MainThread
    public void handleActivityPaused() {
        ScreenRecordingFab screenRecordingFab = this;
        screenRecordingFab.hideFAB();
        screenRecordingFab.hideHintBubble();
    }

    public void startTimerOnRecordingButton() {
        ScreenRecordingFab screenRecordingFab = this;
        screenRecordingFab.startTime = System.currentTimeMillis();
        screenRecordingFab.handler.removeCallbacks(this.updateTimeTask);
        screenRecordingFab.handler.postDelayed(this.updateTimeTask, 0L);
    }

    public static interface ScreenRecordingFloatingBtnEventListener {
        public void start();

        public void stop(int var1);
    }

    public class DraggableRecordingFloatingActionButton
    extends RecordingFloatingActionButton {
        @Nullable
        private GestureDetector mGestureDetector;
        @Nullable
        private MoveAnimator mAnimator;
        private long lastTouchDown;
        private float lastXPose;
        private float lastYPose;
        private boolean isBeingDragged;
        final /* synthetic */ ScreenRecordingFab this$0;

        public DraggableRecordingFloatingActionButton(ScreenRecordingFab object, Activity activity) {
            FlingListener flingListener;
            DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton = this;
            this.this$0 = object;
            super((Context)activity);
            draggableRecordingFloatingActionButton.isBeingDragged = false;
            object = flingListener;
            flingListener = new FlingListener();
            draggableRecordingFloatingActionButton.mGestureDetector = new GestureDetector((Context)activity, (GestureDetector.OnGestureListener)object);
            draggableRecordingFloatingActionButton.mAnimator = new MoveAnimator();
            draggableRecordingFloatingActionButton.setId(R.id.instabug_floating_button);
        }

        private void goToWall() {
            int n;
            int n2 = object.this$0.x >= object.this$0.width / 2 ? object.this$0.rightCorner : object.this$0.leftCorner;
            if (object.this$0.isKeyboardOpen && object.this$0.mCurrentActivity != null && object.this$0.mCurrentActivity.get() != null) {
                DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton = object;
                ScreenRecordingFab screenRecordingFab = draggableRecordingFloatingActionButton.this$0;
                n = screenRecordingFab.getBottomLocationWhenKeyboardOpened((Activity)screenRecordingFab.mCurrentActivity.get());
                if (draggableRecordingFloatingActionButton.this$0.y < (object.this$0.height - n) / 2) {
                    n = object.this$0.topCorner;
                }
            } else {
                n = object.this$0.y >= object.this$0.height / 2 ? object.this$0.bottomCorner : object.this$0.topCorner;
            }
            Object object = object.mAnimator;
            if (object != null) {
                float f = n2;
                ((MoveAnimator)object).start(f, n);
            }
        }

        public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
            ScreenRecordingFab.access$902(this.this$0, (FrameLayout.LayoutParams)layoutParams);
            super.setLayoutParams(layoutParams);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            boolean bl = false;
            GestureDetector gestureDetector = this.mGestureDetector;
            if (gestureDetector != null) {
                bl = gestureDetector.onTouchEvent(motionEvent);
            }
            if (bl) {
                this.goToWall();
            } else {
                MotionEvent motionEvent2 = motionEvent;
                float f = motionEvent2.getRawX();
                float f2 = motionEvent2.getRawY();
                int n = motionEvent2.getAction();
                if (n == 0) {
                    this.lastTouchDown = System.currentTimeMillis();
                    MoveAnimator moveAnimator = this.mAnimator;
                    if (moveAnimator != null) {
                        moveAnimator.stop();
                    }
                    this.isBeingDragged = true;
                } else if (n == 1) {
                    if (System.currentTimeMillis() - this.lastTouchDown < 200L) {
                        this.performClick();
                    }
                    this.isBeingDragged = false;
                    this.goToWall();
                } else if (n == 2 && this.isBeingDragged) {
                    float f3 = f - this.lastXPose;
                    this.move(f3, f2 - this.lastYPose);
                }
                DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton = this;
                draggableRecordingFloatingActionButton.lastXPose = f;
                draggableRecordingFloatingActionButton.lastYPose = f2;
            }
            return true;
        }

        void setLocation(int n, int n2) {
            ScreenRecordingFab.access$1402(this.this$0, n);
            ScreenRecordingFab.access$2002(this.this$0, n2);
            if (this.this$0.layoutParams != null) {
                ((ScreenRecordingFab)this.this$0).layoutParams.leftMargin = this.this$0.x;
                ((ScreenRecordingFab)this.this$0).layoutParams.rightMargin = this.this$0.width - this.this$0.x;
                if (this.this$0.orientation == 2 && this.this$0.realWidth > this.this$0.width) {
                    ((ScreenRecordingFab)this.this$0).layoutParams.rightMargin = (int)((float)((ScreenRecordingFab)this.this$0).layoutParams.rightMargin + this.this$0.densityFactor * 48.0f);
                }
                ((ScreenRecordingFab)this.this$0).layoutParams.topMargin = this.this$0.y;
                ((ScreenRecordingFab)this.this$0).layoutParams.bottomMargin = this.this$0.height - this.this$0.y;
                this.setLayoutParams((ViewGroup.LayoutParams)this.this$0.layoutParams);
            }
        }

        void move(float f, float f2) {
            if ((float)this.this$0.y + f2 > 50.0f) {
                DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton = this;
                draggableRecordingFloatingActionButton.setLocation((int)((float)draggableRecordingFloatingActionButton.this$0.x + f), (int)((float)this.this$0.y + f2));
                draggableRecordingFloatingActionButton.this$0.setExtraButtonsLayoutParams();
                if (draggableRecordingFloatingActionButton.this$0.expanded && this.this$0.isExceedingMinDragLimit(f, f2)) {
                    this.this$0.collapse();
                }
                this.this$0.hideHintBubble();
            }
            if (!this.isBeingDragged && this.this$0.layoutParams != null && Math.abs(((ScreenRecordingFab)this.this$0).layoutParams.rightMargin) < 50 && Math.abs(((ScreenRecordingFab)this.this$0).layoutParams.topMargin - this.getContext().getResources().getDisplayMetrics().heightPixels / 2) < 250) {
                this.goToWall();
            }
        }

        private class MoveAnimator
        implements Runnable {
            private final Handler handler = new Handler(Looper.getMainLooper());
            private float destinationX;
            private float destinationY;
            private long startingTime;

            private MoveAnimator() {
            }

            private void start(float f, float f2) {
                this.destinationX = f;
                this.destinationY = f2;
                this.startingTime = System.currentTimeMillis();
                this.handler.post((Runnable)this);
            }

            private void stop() {
                this.handler.removeCallbacks((Runnable)this);
            }

            @Override
            public void run() {
                if (DraggableRecordingFloatingActionButton.this.getParent() != null) {
                    float f;
                    float f2 = Math.min(1.0f, (float)(System.currentTimeMillis() - this.startingTime) / 400.0f);
                    MoveAnimator moveAnimator = this;
                    float f3 = (moveAnimator.destinationX - (float)DraggableRecordingFloatingActionButton.this.this$0.x) * f2;
                    f2 = (moveAnimator.destinationY - (float)DraggableRecordingFloatingActionButton.this.this$0.y) * f2;
                    DraggableRecordingFloatingActionButton draggableRecordingFloatingActionButton = moveAnimator.DraggableRecordingFloatingActionButton.this;
                    draggableRecordingFloatingActionButton.setLocation((int)((float)draggableRecordingFloatingActionButton.this$0.x + f3), (int)((float)DraggableRecordingFloatingActionButton.this.this$0.y + f2));
                    if (f < 1.0f) {
                        this.handler.post((Runnable)this);
                    }
                }
            }
        }
    }

    static class FlingListener
    extends GestureDetector.SimpleOnGestureListener {
        FlingListener() {
        }

        public boolean onFling(@Nullable MotionEvent motionEvent, @Nullable MotionEvent motionEvent2, float f, float f2) {
            if (motionEvent != null && motionEvent2 != null) {
                return Math.abs(motionEvent2.getX() - motionEvent.getX()) < 90.0f && motionEvent2.getY() - motionEvent.getY() > 90.0f;
            }
            return false;
        }
    }
}

