/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import android.os.Build;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import androidx.annotation.Nullable;
import com.instabug.bug.BugReporting;
import com.instabug.bug.ProactiveReportingConfigs;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.proactivereporting.configs.ProactiveReportingConfigProvider;
import com.instabug.bug.settings.AttachmentsTypesParams;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.utils.RegexUtils;
import com.instabug.chat.ChatsDelegate;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.MediaProjectionHelper;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.util.Locale;

public abstract class BugReportingWrapper {
    public static void setReportTypes(int ... nArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int n : nArray) {
            InstabugSDKLogger.d((String)"IBG-BR", (String)("setReportTypes: " + n));
            if (n != 0) {
                if (n != 1) {
                    if (n != 2) continue;
                    bl3 = true;
                    continue;
                }
                bl2 = true;
                continue;
            }
            bl = true;
        }
        BugSettings.getInstance().setReportTypeStatus("bug", bl);
        BugSettings.getInstance().setReportTypeStatus("feedback", bl2);
        BugSettings.getInstance().setReportTypeStatus("ask a question", bl3);
        InvocationManager.getInstance().notifyInvocationOptionChanged();
    }

    public static void setOptions(int[] nArray) {
        for (int n : nArray) {
            InstabugSDKLogger.d((String)"IBG-BR", (String)("setOptions: " + n));
            if (n != 2) {
                if (n != 4) {
                    if (n != 8) {
                        if (n != 16) continue;
                        BugSettings.getInstance().setSuccessDialogEnabled(false);
                        continue;
                    }
                    BugSettings.getInstance().setCommentFieldRequired(true);
                    continue;
                }
                BugSettings.getInstance().setEmailFieldVisibility(true);
                BugSettings.getInstance().setEmailFieldRequired(false);
                continue;
            }
            BugSettings.getInstance().setEmailFieldVisibility(false);
            BugSettings.getInstance().setEmailFieldRequired(false);
        }
    }

    public static void show(@BugReporting.ReportType int n) {
        InstabugSDKLogger.d((String)"IBG-BR", (String)("[BugReportingWrapper#show], type: " + n));
        boolean bl = InstabugCore.isForegroundBusy();
        InstabugSDKLogger.d((String)"IBG-BR", (String)("[BugReportingWrapper#show] isForegroundBusy: " + bl));
        if (bl) {
            return;
        }
        boolean bl2 = InstabugCore.isFeatureEnabled((String)"BUG_REPORTING");
        InstabugSDKLogger.d((String)"IBG-BR", (String)("[BugReportingWrapper#show] isFeatureEnabled: " + bl2));
        if (bl2) {
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        InvocationManager.getInstance().invoke(3);
                    }
                } else {
                    InvocationManager.getInstance().invoke(2);
                }
            } else {
                InvocationManager.getInstance().invoke(1);
            }
        }
    }

    public static void show(int n, int[] nArray) {
        BugReportingWrapper.setOptions(nArray);
        BugReportingWrapper.show(n);
    }

    public static void setState(Feature.State state) {
        InstabugSDKLogger.d((String)"IBG-BR", (String)("setState: " + state));
        BugSettings.getInstance().setBugReportingState(state);
        InstabugCore.setBugReportingState((Feature.State)state);
        ServiceLocator.getReproProxy().evaluate((ReproConfigurationsProvider)ServiceLocator.getConfigurationsProvider());
        InvocationManager.getInstance().notifyInvocationOptionChanged();
    }

    public static void setAttachmentTypesEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        AttachmentsTypesParams attachmentsTypesParams;
        InstabugSDKLogger.d((String)"IBG-BR", (String)("setAttachementTypes: initialScreenshot: " + bl + " extraScreenshot: " + bl2 + " imageFromGallery: " + bl3 + "screenRecording: " + bl4));
        AttachmentsTypesParams attachmentsTypesParams2 = attachmentsTypesParams;
        attachmentsTypesParams = new AttachmentsTypesParams(bl, bl2, bl3, bl4);
        BugSettings.getInstance().setAttachmentsTypesParams(attachmentsTypesParams2);
        ChatsDelegate.setAttachmentTypesEnabled(bl2, bl3, bl4);
    }

    public static void setAutoScreenRecordingEnabled(boolean bl) {
        InstabugSDKLogger.d((String)"IBG-BR", (String)("setAutoScreenRecordingEnabled: " + bl));
        Context context = Instabug.getApplicationContext();
        if (context != null && bl && !MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable(context)) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Please make sure to add FOREGROUND_SERVICE_MEDIA_PROJECTION to your manifest file before enabling auto screen recording.");
            return;
        }
        if (bl && InstabugCore.isAutoScreenRecordingEnabled()) {
            return;
        }
        boolean bl2 = bl;
        InstabugCore.setAutoScreenRecordingEnabled((boolean)bl2);
        if (bl2) {
            InternalAutoScreenRecorderHelper.getInstance().start();
        }
    }

    public static void setDisclaimerText(String object) {
        if (object != null && !((String)object).equals("")) {
            String string2 = object;
            object = SettingsManager.getInstance().getPrimaryColor() & 0xFFFFFF;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            object = BugReportingWrapper.getSpannedFromString(RegexUtils.reformatMarkdownText(string2, String.format("<font color=\"#%06X\"><a href=\"$2\">$1</a></font>", objectArray2)));
            if (object.length() > 100) {
                Object object2 = object;
                object = 100;
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = object;
                InstabugSDKLogger.w((String)"IBG-BR", (String)String.format(Locale.getDefault(), "The maximum limit of Disclaimer text is reached. Please note that maximum characters count is %d", objectArray2));
                object = (Spanned)object2.subSequence(0, 100);
                if (object instanceof SpannableStringBuilder) {
                    ((SpannableStringBuilder)object).append((CharSequence)"...");
                }
            }
            BugSettings.getInstance().setDisclaimerText((Spanned)object);
            return;
        }
    }

    private static Spanned getSpannedFromString(String string2) {
        return Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)string2, (int)0) : Html.fromHtml((String)string2);
    }

    public static void setCommentMinimumCharacterCount(int n, int ... nArray) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            BugReportingWrapper.setReportTypeMinCharLimit(nArray[i], n);
        }
    }

    private static void setReportTypeMinCharLimit(@BugReporting.IBGBugReportingType int n, int n2) {
        switch (n) {
            default: {
                break;
            }
            case 3: {
                BugSettings.getInstance().setReportTypeCommentMinCharLimit("Frustrating experience", n2);
                break;
            }
            case 2: {
                BugSettings.getInstance().setReportTypeCommentMinCharLimit("ask a question", n2);
                break;
            }
            case 1: {
                BugSettings.getInstance().setReportTypeCommentMinCharLimit("feedback", n2);
                break;
            }
            case 0: {
                BugSettings.getInstance().setReportTypeCommentMinCharLimit("bug", n2);
            }
        }
    }

    public static void addUserConsent(@Nullable String string2, @Nullable String string3, boolean bl, boolean bl2, @Nullable String string4) {
        ServiceLocator.getUserConsentsManager().addUserConsent(string2, string3, bl, bl2, string4);
    }

    public static void setProactiveReportingConfigurations(ProactiveReportingConfigs proactiveReportingConfigs) {
        ProactiveReportingConfigProvider proactiveReportingConfigProvider = ServiceLocator.getProactiveReportingConfigProvider();
        if (!proactiveReportingConfigProvider.getProactiveReportingBEAvailability() && proactiveReportingConfigs.isEnabled()) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Proactive Reporting wasn't enabled as it seems to be disabled for your Instabug company account. Please, contact support to switch it on for you.");
        } else {
            proactiveReportingConfigProvider.setProactiveReportingApiAvailability(proactiveReportingConfigs.isEnabled());
            proactiveReportingConfigProvider.setModalsGapApiValue(proactiveReportingConfigs.getModalsGap());
            proactiveReportingConfigProvider.setDetectionGapApiValue(proactiveReportingConfigs.getDetectionGap());
        }
    }
}

