package com.instabug.chat.settings;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;

import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;

import com.instabug.library.Instabug;

public class PersistableSettings {

    private static final String IBC_TTL = "ibc_ttl";
    private static final String IBC_LAST_CHAT_TIME = "ibc_last_chat_time";
    private static final String IBC_CONVERSATION_SOUNDS = "ibc_conversation_sounds";
    private static final String IBC_SYSTEM_NOTIFICATION_SOUND = "ibc_notification_sound";
    private static final String IBC_IN_APP_NOTIFICATION_SOUND = "ibc_in_app_notification_sound";
    private static final String IBC_PUSH_NOTIFICATION_ICON = "ibc_push_notification_icon";
    private static final String IBC_IS_CHAT_NOTIFICATIONS_ENABLED = "ibc__notifications_state";

    private static PersistableSettings persistableSettings;
    @Nullable
    private SharedPreferences sharedPreferences;

    private PersistableSettings(@Nullable SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    static void init(@Nullable SharedPreferences sharedPreferences) {
        persistableSettings = new PersistableSettings(sharedPreferences);
    }

    static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null)
            init(ChatSettings.getChatSharedPreferences(Instabug.getApplicationContext()));
        return persistableSettings;
    }

    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    public static void release() {
        persistableSettings = null;
    }

    long getLastChatTime() {
        if (sharedPreferences == null) return System.currentTimeMillis();
        return sharedPreferences.getLong(IBC_LAST_CHAT_TIME, System.currentTimeMillis());
    }

    void setLastChatTime(long time) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putLong(IBC_LAST_CHAT_TIME, time).apply();
    }

    long getTTL() {
        if (sharedPreferences == null) return 60L;
        return sharedPreferences.getLong(IBC_TTL, 60L);
    }

    void setTTL(long ttl) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putLong(IBC_TTL, ttl).apply();
    }

    boolean isConversationSoundEnable() {
        if (sharedPreferences == null) return false;
        return sharedPreferences.getBoolean(IBC_CONVERSATION_SOUNDS, false);
    }

    void enableConversationSound(boolean shouldPlayConversationSounds) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putBoolean(IBC_CONVERSATION_SOUNDS,
                shouldPlayConversationSounds).apply();
    }

    boolean isSystemNotificationSoundEnabled() {
        if (sharedPreferences == null) return false;
        return sharedPreferences.getBoolean(IBC_SYSTEM_NOTIFICATION_SOUND, false);
    }

    void enableSystemNotificationSound(boolean shouldPlaySound) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putBoolean(IBC_SYSTEM_NOTIFICATION_SOUND, shouldPlaySound).apply();
    }

    boolean isInAppNotificationSoundEnabled() {
        if (sharedPreferences == null) return false;
        return sharedPreferences.getBoolean(IBC_IN_APP_NOTIFICATION_SOUND, false);
    }

    void enableInAppNotificationSound(boolean shouldPlaySound) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putBoolean(IBC_IN_APP_NOTIFICATION_SOUND, shouldPlaySound).apply();
    }

    @DrawableRes
    int getNotificationIcon() {
        if (sharedPreferences == null) return -1;
        return sharedPreferences.getInt(IBC_PUSH_NOTIFICATION_ICON, -1);
    }

    void setNotificationIcon(@DrawableRes int notificationIcon) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putInt(IBC_PUSH_NOTIFICATION_ICON, notificationIcon).apply();
    }

    boolean isNotificationEnable() {
        if (sharedPreferences == null) return true;
        return sharedPreferences.getBoolean(IBC_IS_CHAT_NOTIFICATIONS_ENABLED, true);
    }

    void enableNotification(boolean isNotificationEnable) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putBoolean(IBC_IS_CHAT_NOTIFICATIONS_ENABLED,
                isNotificationEnable).apply();
    }
}